/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.description;
import org.apache.hadoop.hive.ql.udf.UDFBaseBitOP;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;

@description(name="|", value="a _FUNC_ b - Bitwise or", extended="Example:\n  > SELECT 3 _FUNC_ 5 FROM src LIMIT 1;\n  7")
public class UDFOPBitOr
extends UDFBaseBitOP {
    private static Log LOG = LogFactory.getLog((String)"org.apache.hadoop.hive.ql.udf.UDFOPBitOr");

    public ByteWritable evaluate(ByteWritable a, ByteWritable b) {
        if (a == null || b == null) {
            return null;
        }
        this.byteWritable.set((byte)(a.get() | b.get()));
        return this.byteWritable;
    }

    public ShortWritable evaluate(ShortWritable a, ShortWritable b) {
        if (a == null || b == null) {
            return null;
        }
        this.shortWritable.set((short)(a.get() | b.get()));
        return this.shortWritable;
    }

    public IntWritable evaluate(IntWritable a, IntWritable b) {
        if (a == null || b == null) {
            return null;
        }
        this.intWritable.set(a.get() | b.get());
        return this.intWritable;
    }

    public LongWritable evaluate(LongWritable a, LongWritable b) {
        if (a == null || b == null) {
            return null;
        }
        this.longWritable.set(a.get() | b.get());
        return this.longWritable;
    }
}

