/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.description;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;

@description(name="rpad", value="_FUNC_(str, len, pad) - Returns str, right-padded with pad to a length of len", extended="If str is longer than len, the return value is shortened to len characters.\nExample:\n  > SELECT _FUNC_('hi', 5, '??') FROM src LIMIT 1;\n  'hi???'  > SELECT _FUNC_('hi', 1, '??') FROM src LIMIT 1;\n  'h'")
public class UDFRpad
extends UDF {
    private Text result = new Text();

    public Text evaluate(Text s, IntWritable n, Text pad) {
        int pos;
        if (s == null || n == null || pad == null) {
            return null;
        }
        int len = n.get();
        byte[] data = this.result.getBytes();
        if (data.length < len) {
            data = new byte[len];
        }
        byte[] txt = s.getBytes();
        byte[] padTxt = pad.getBytes();
        for (pos = 0; pos < s.getLength() && pos < len; ++pos) {
            data[pos] = txt[pos];
        }
        while (pos < len) {
            for (int i = 0; i < pad.getLength() && i < len - pos; ++i) {
                data[pos + i] = padTxt[i];
            }
            pos += pad.getLength();
        }
        this.result.set(data, 0, len);
        return this.result;
    }
}

