/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.objectinspector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableListObjectInspector;

public class StandardListObjectInspector
implements SettableListObjectInspector {
    ObjectInspector listElementObjectInspector;

    protected StandardListObjectInspector(ObjectInspector listElementObjectInspector) {
        this.listElementObjectInspector = listElementObjectInspector;
    }

    @Override
    public final ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.LIST;
    }

    @Override
    public ObjectInspector getListElementObjectInspector() {
        return this.listElementObjectInspector;
    }

    @Override
    public Object getListElement(Object data, int index) {
        if (data == null) {
            return null;
        }
        boolean isArray = data.getClass().isArray();
        if (isArray) {
            Object[] list = (Object[])data;
            if (index < 0 || index >= list.length) {
                return null;
            }
            return list[index];
        }
        List list = (List)data;
        if (index < 0 || index >= list.size()) {
            return null;
        }
        return list.get(index);
    }

    @Override
    public int getListLength(Object data) {
        if (data == null) {
            return -1;
        }
        boolean isArray = data.getClass().isArray();
        if (isArray) {
            Object[] list = (Object[])data;
            return list.length;
        }
        List list = (List)data;
        return list.size();
    }

    @Override
    public List<?> getList(Object data) {
        if (data == null) {
            return null;
        }
        if (data.getClass().isArray()) {
            data = Arrays.asList((Object[])data);
        }
        List list = data;
        return list;
    }

    @Override
    public String getTypeName() {
        return "array<" + this.listElementObjectInspector.getTypeName() + ">";
    }

    @Override
    public Object create(int size) {
        ArrayList<Object> a = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            a.add(null);
        }
        return a;
    }

    @Override
    public Object resize(Object list, int newSize) {
        List a = (List)list;
        while (a.size() < newSize) {
            a.add(null);
        }
        while (a.size() > newSize) {
            a.remove(a.size() - 1);
        }
        return a;
    }

    @Override
    public Object set(Object list, int index, Object element) {
        List a = (List)list;
        a.set(index, element);
        return a;
    }
}

