/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.objectinspector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;

public class StandardStructObjectInspector
extends SettableStructObjectInspector {
    public static final Log LOG = LogFactory.getLog((String)StandardStructObjectInspector.class.getName());
    protected List<MyField> fields;
    boolean warned = false;

    @Override
    public String getTypeName() {
        return ObjectInspectorUtils.getStandardStructTypeName(this);
    }

    protected StandardStructObjectInspector(List<String> structFieldNames, List<ObjectInspector> structFieldObjectInspectors) {
        this.init(structFieldNames, structFieldObjectInspectors);
    }

    protected void init(List<String> structFieldNames, List<ObjectInspector> structFieldObjectInspectors) {
        assert (structFieldNames.size() == structFieldObjectInspectors.size());
        this.fields = new ArrayList<MyField>(structFieldNames.size());
        for (int i = 0; i < structFieldNames.size(); ++i) {
            this.fields.add(new MyField(i, structFieldNames.get(i), structFieldObjectInspectors.get(i)));
        }
    }

    protected StandardStructObjectInspector(List<StructField> fields) {
        this.init(fields);
    }

    protected void init(List<StructField> fields) {
        this.fields = new ArrayList<MyField>(fields.size());
        for (int i = 0; i < fields.size(); ++i) {
            this.fields.add(new MyField(i, fields.get(i).getFieldName(), fields.get(i).getFieldObjectInspector()));
        }
    }

    @Override
    public final ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.STRUCT;
    }

    @Override
    public StructField getStructFieldRef(String fieldName) {
        return ObjectInspectorUtils.getStandardStructFieldRef(fieldName, this.fields);
    }

    @Override
    public List<? extends StructField> getAllStructFieldRefs() {
        return this.fields;
    }

    @Override
    public Object getStructFieldData(Object data, StructField fieldRef) {
        if (data == null) {
            return null;
        }
        boolean isArray = data.getClass().isArray();
        if (!isArray && !(data instanceof List)) {
            return data;
        }
        int listSize = isArray ? ((Object[])data).length : ((List)data).size();
        MyField f = (MyField)fieldRef;
        if (this.fields.size() != listSize && !this.warned) {
            this.warned = true;
            LOG.warn((Object)("Trying to access " + this.fields.size() + " fields inside a list of " + listSize + " elements: " + (isArray ? Arrays.asList((Object[])data) : (List<Object>)data)));
            LOG.warn((Object)"ignoring similar errors.");
        }
        int fieldID = f.getFieldID();
        assert (fieldID >= 0 && fieldID < this.fields.size());
        if (fieldID >= listSize) {
            return null;
        }
        if (isArray) {
            return ((Object[])data)[fieldID];
        }
        return ((List)data).get(fieldID);
    }

    @Override
    public List<Object> getStructFieldsDataAsList(Object data) {
        if (data == null) {
            return null;
        }
        if (data.getClass().isArray()) {
            data = Arrays.asList((Object[])data);
        }
        List list = data;
        assert (list.size() == this.fields.size());
        return list;
    }

    @Override
    public Object create() {
        ArrayList<Object> a = new ArrayList<Object>(this.fields.size());
        for (int i = 0; i < this.fields.size(); ++i) {
            a.add(null);
        }
        return a;
    }

    @Override
    public Object setStructFieldData(Object struct, StructField field, Object fieldValue) {
        ArrayList a = (ArrayList)struct;
        MyField myField = (MyField)field;
        a.set(myField.fieldID, fieldValue);
        return a;
    }

    protected static class MyField
    implements StructField {
        protected int fieldID;
        protected String fieldName;
        protected ObjectInspector fieldObjectInspector;

        public MyField(int fieldID, String fieldName, ObjectInspector fieldObjectInspector) {
            this.fieldID = fieldID;
            this.fieldName = fieldName.toLowerCase();
            this.fieldObjectInspector = fieldObjectInspector;
        }

        public int getFieldID() {
            return this.fieldID;
        }

        @Override
        public String getFieldName() {
            return this.fieldName;
        }

        @Override
        public ObjectInspector getFieldObjectInspector() {
            return this.fieldObjectInspector;
        }

        public String toString() {
            return "" + this.fieldID + ":" + this.fieldName;
        }
    }
}

