/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.ast;

import org.aspectj.org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.Constant;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ProblemFieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class JavadocFieldReference
extends FieldReference {
    public int tagSourceStart;
    public int tagSourceEnd;
    public int tagValue;
    public MethodBinding methodBinding;

    public JavadocFieldReference(char[] source, long pos) {
        super(source, pos);
        this.bits |= 0x8000;
    }

    protected TypeBinding internalResolveType(Scope scope) {
        FieldBinding fieldBinding;
        this.constant = Constant.NotAConstant;
        this.receiverType = this.receiver == null ? scope.enclosingSourceType() : (scope.kind == 3 ? this.receiver.resolveType((ClassScope)scope) : this.receiver.resolveType((BlockScope)scope));
        if (this.receiverType == null) {
            return null;
        }
        Binding binding = fieldBinding = this.receiver != null && this.receiver.isThis() ? scope.classScope().getBinding(this.token, this.bits & 7, this, true) : scope.getField(this.receiverType, this.token, this);
        if (!fieldBinding.isValidBinding()) {
            switch (fieldBinding.problemId()) {
                case 5: 
                case 6: 
                case 7: {
                    FieldBinding closestMatch = ((ProblemFieldBinding)fieldBinding).closestMatch;
                    if (closestMatch == null) break;
                    fieldBinding = closestMatch;
                }
            }
        }
        if (!fieldBinding.isValidBinding() || !(fieldBinding instanceof FieldBinding)) {
            if (this.receiverType instanceof ReferenceBinding) {
                ReferenceBinding refBinding = (ReferenceBinding)this.receiverType;
                MethodBinding[] methodBindings = refBinding.getMethods(this.token);
                if (methodBindings == null) {
                    scope.problemReporter().javadocInvalidField(this.sourceStart, this.sourceEnd, fieldBinding, this.receiverType, scope.getDeclarationModifiers());
                } else {
                    switch (methodBindings.length) {
                        case 0: {
                            scope.problemReporter().javadocInvalidField(this.sourceStart, this.sourceEnd, fieldBinding, this.receiverType, scope.getDeclarationModifiers());
                            break;
                        }
                        case 1: {
                            this.methodBinding = methodBindings[0];
                            break;
                        }
                        default: {
                            this.methodBinding = methodBindings[0];
                            scope.problemReporter().javadocAmbiguousMethodReference(this.sourceStart, this.sourceEnd, fieldBinding, scope.getDeclarationModifiers());
                        }
                    }
                }
            }
            return null;
        }
        this.binding = fieldBinding;
        if (this.isFieldUseDeprecated(this.binding, scope, (this.bits & 0x2000) != 0)) {
            scope.problemReporter().javadocDeprecatedField(this.binding, this, scope.getDeclarationModifiers());
        }
        this.resolvedType = this.binding.type;
        return this.resolvedType;
    }

    public boolean isSuperAccess() {
        return (this.bits & 0x4000) != 0;
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        if (this.receiver != null) {
            this.receiver.printExpression(0, output);
        }
        output.append('#').append(this.token);
        return output;
    }

    public TypeBinding resolveType(BlockScope scope) {
        return this.internalResolveType(scope);
    }

    public TypeBinding resolveType(ClassScope scope) {
        return this.internalResolveType(scope);
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope) && this.receiver != null) {
            this.receiver.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }

    public void traverse(ASTVisitor visitor, ClassScope scope) {
        if (visitor.visit(this, scope) && this.receiver != null) {
            this.receiver.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }
}

