/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.evaluation.math;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.piggybank.evaluation.math.DoubleCopySign;
import org.apache.pig.piggybank.evaluation.math.FloatCopySign;
import org.apache.pig.piggybank.evaluation.math.Util;

public class copySign
extends EvalFunc<Double> {
    public Double exec(Tuple input) throws IOException {
        if (input == null || input.size() < 2) {
            return null;
        }
        try {
            double first = DataType.toDouble((Object)input.get(0));
            double second = DataType.toDouble((Object)input.get(1));
            return Math.copySign(first, second);
        }
        catch (NumberFormatException nfe) {
            System.err.println("Failed to process input; error - " + nfe.getMessage());
            return null;
        }
        catch (Exception e) {
            throw new IOException("Caught exception processing input row ", e);
        }
    }

    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), input), 25));
    }

    public List<FuncSpec> getArgToFuncMapping() throws FrontendException {
        ArrayList<FuncSpec> funcList = new ArrayList<FuncSpec>();
        Util.addToFunctionList(funcList, ((Object)((Object)this)).getClass().getName(), (byte)50);
        Util.addToFunctionList(funcList, DoubleCopySign.class.getName(), (byte)25);
        Util.addToFunctionList(funcList, FloatCopySign.class.getName(), (byte)20);
        return funcList;
    }
}

