/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.enhancer.asm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.jdo.spi.StateManager;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.enhancer.AbstractClassEnhancer;
import org.datanucleus.enhancer.ClassField;
import org.datanucleus.enhancer.DataNucleusEnhancer;
import org.datanucleus.enhancer.asm.JdoClassAdapter;
import org.datanucleus.enhancer.asm.JdoClassChecker;
import org.datanucleus.enhancer.asm.method.InitFieldFlags;
import org.datanucleus.enhancer.asm.method.InitFieldNames;
import org.datanucleus.enhancer.asm.method.InitFieldTypes;
import org.datanucleus.enhancer.asm.method.InitPersistenceCapableSuperclass;
import org.datanucleus.enhancer.asm.method.JdoCopyField;
import org.datanucleus.enhancer.asm.method.JdoCopyFields;
import org.datanucleus.enhancer.asm.method.JdoCopyKeyFieldsFromObjectId;
import org.datanucleus.enhancer.asm.method.JdoCopyKeyFieldsFromObjectId2;
import org.datanucleus.enhancer.asm.method.JdoCopyKeyFieldsToObjectId;
import org.datanucleus.enhancer.asm.method.JdoCopyKeyFieldsToObjectId2;
import org.datanucleus.enhancer.asm.method.JdoGetInheritedFieldCount;
import org.datanucleus.enhancer.asm.method.JdoGetManagedFieldCount;
import org.datanucleus.enhancer.asm.method.JdoGetObjectId;
import org.datanucleus.enhancer.asm.method.JdoGetPersistenceManager;
import org.datanucleus.enhancer.asm.method.JdoGetTransactionalObjectId;
import org.datanucleus.enhancer.asm.method.JdoGetVersion;
import org.datanucleus.enhancer.asm.method.JdoIsDeleted;
import org.datanucleus.enhancer.asm.method.JdoIsDetached;
import org.datanucleus.enhancer.asm.method.JdoIsDirty;
import org.datanucleus.enhancer.asm.method.JdoIsNew;
import org.datanucleus.enhancer.asm.method.JdoIsPersistent;
import org.datanucleus.enhancer.asm.method.JdoIsTransactional;
import org.datanucleus.enhancer.asm.method.JdoMakeDirty;
import org.datanucleus.enhancer.asm.method.JdoNewInstance1;
import org.datanucleus.enhancer.asm.method.JdoNewInstance2;
import org.datanucleus.enhancer.asm.method.JdoNewObjectIdInstance1;
import org.datanucleus.enhancer.asm.method.JdoNewObjectIdInstance2;
import org.datanucleus.enhancer.asm.method.JdoPreSerialize;
import org.datanucleus.enhancer.asm.method.JdoProvideField;
import org.datanucleus.enhancer.asm.method.JdoProvideFields;
import org.datanucleus.enhancer.asm.method.JdoReplaceDetachedState;
import org.datanucleus.enhancer.asm.method.JdoReplaceField;
import org.datanucleus.enhancer.asm.method.JdoReplaceFields;
import org.datanucleus.enhancer.asm.method.JdoReplaceFlags;
import org.datanucleus.enhancer.asm.method.JdoReplaceStateManager;
import org.datanucleus.enhancer.asm.method.JdoSuperClone;
import org.datanucleus.enhancer.asm.method.LoadClass;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.util.StringUtils;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ASMClassEnhancer
extends AbstractClassEnhancer {
    protected String inputResourceName;
    protected byte[] inputBytes;
    protected final Class cls;
    protected byte[] classBytes = null;
    protected String asmClassName = null;
    protected String classDescriptor = null;

    public ASMClassEnhancer(ClassMetaData cmd, ClassLoaderResolver clr) {
        super(cmd, clr);
        this.cls = clr.classForName(cmd.getFullClassName());
        this.asmClassName = cmd.getFullClassName().replace('.', '/');
        this.classDescriptor = Type.getDescriptor((Class)this.cls);
        this.inputResourceName = "/" + this.className.replace('.', '/') + ".class";
    }

    public ASMClassEnhancer(ClassMetaData cmd, ClassLoaderResolver clr, byte[] classBytes) {
        super(cmd, clr);
        this.cls = clr.classForName(cmd.getFullClassName());
        this.asmClassName = cmd.getFullClassName().replace('.', '/');
        this.classDescriptor = Type.getDescriptor((Class)this.cls);
        this.inputBytes = classBytes;
    }

    public static String getClassNameForFileName(String filename) {
        MyClassVisitor vis = new MyClassVisitor();
        try {
            new ClassReader((InputStream)new FileInputStream(filename)).accept((ClassVisitor)vis, 0);
            return vis.getClassName();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public Class getClassEnhanced() {
        return this.cls;
    }

    public String getASMClassName() {
        return this.asmClassName;
    }

    public String getClassDescriptor() {
        return this.classDescriptor;
    }

    protected void initialiseMethodsList() {
        if (this.cmd.getPersistenceCapableSuperclass() == null) {
            this.methodsToAdd.add(JdoCopyKeyFieldsFromObjectId.getInstance(this));
            this.methodsToAdd.add(JdoCopyKeyFieldsFromObjectId2.getInstance(this));
            this.methodsToAdd.add(JdoCopyKeyFieldsToObjectId.getInstance(this));
            this.methodsToAdd.add(JdoCopyKeyFieldsToObjectId2.getInstance(this));
            this.methodsToAdd.add(JdoGetObjectId.getInstance(this));
            this.methodsToAdd.add(JdoGetVersion.getInstance(this));
            this.methodsToAdd.add(JdoPreSerialize.getInstance(this));
            this.methodsToAdd.add(JdoGetPersistenceManager.getInstance(this));
            this.methodsToAdd.add(JdoGetTransactionalObjectId.getInstance(this));
            this.methodsToAdd.add(JdoIsDeleted.getInstance(this));
            this.methodsToAdd.add(JdoIsDirty.getInstance(this));
            this.methodsToAdd.add(JdoIsNew.getInstance(this));
            this.methodsToAdd.add(JdoIsPersistent.getInstance(this));
            this.methodsToAdd.add(JdoIsTransactional.getInstance(this));
            this.methodsToAdd.add(JdoMakeDirty.getInstance(this));
            this.methodsToAdd.add(JdoNewObjectIdInstance1.getInstance(this));
            this.methodsToAdd.add(JdoNewObjectIdInstance2.getInstance(this));
            this.methodsToAdd.add(JdoProvideFields.getInstance(this));
            this.methodsToAdd.add(JdoReplaceFields.getInstance(this));
            this.methodsToAdd.add(JdoReplaceFlags.getInstance(this));
            this.methodsToAdd.add(JdoReplaceStateManager.getInstance(this));
        }
        if (this.requiresDetachable()) {
            this.methodsToAdd.add(JdoReplaceDetachedState.getInstance(this));
        }
        if (this.cmd.isDetachable() && this.cmd.getPersistenceCapableSuperclass() != null) {
            this.methodsToAdd.add(JdoMakeDirty.getInstance(this));
        }
        this.methodsToAdd.add(JdoIsDetached.getInstance(this));
        this.methodsToAdd.add(JdoNewInstance1.getInstance(this));
        this.methodsToAdd.add(JdoNewInstance2.getInstance(this));
        this.methodsToAdd.add(JdoReplaceField.getInstance(this));
        this.methodsToAdd.add(JdoProvideField.getInstance(this));
        this.methodsToAdd.add(JdoCopyField.getInstance(this));
        this.methodsToAdd.add(JdoCopyFields.getInstance(this));
        this.methodsToAdd.add(InitFieldNames.getInstance(this));
        this.methodsToAdd.add(InitFieldTypes.getInstance(this));
        this.methodsToAdd.add(InitFieldFlags.getInstance(this));
        this.methodsToAdd.add(JdoGetInheritedFieldCount.getInstance(this));
        this.methodsToAdd.add(JdoGetManagedFieldCount.getInstance(this));
        this.methodsToAdd.add(InitPersistenceCapableSuperclass.getInstance(this));
        this.methodsToAdd.add(LoadClass.getInstance(this));
        this.methodsToAdd.add(JdoSuperClone.getInstance(this));
    }

    protected void initialiseFieldsList() {
        if (this.cmd.getPersistenceCapableSuperclass() == null) {
            this.fieldsToAdd.add(new ClassField(this, "jdoStateManager", 132, StateManager.class));
            this.fieldsToAdd.add(new ClassField(this, "jdoFlags", 132, Byte.TYPE));
        }
        if (this.requiresDetachable()) {
            this.fieldsToAdd.add(new ClassField(this, "jdoDetachedState", 4, Object[].class));
        }
        this.fieldsToAdd.add(new ClassField(this, "jdoFieldFlags", 26, byte[].class));
        this.fieldsToAdd.add(new ClassField(this, "jdoPersistenceCapableSuperclass", 26, Class.class));
        this.fieldsToAdd.add(new ClassField(this, "jdoFieldTypes", 26, Class[].class));
        this.fieldsToAdd.add(new ClassField(this, "jdoFieldNames", 26, String[].class));
        this.fieldsToAdd.add(new ClassField(this, "jdoInheritedFieldCount", 26, Integer.TYPE));
    }

    public boolean enhance() {
        if (this.cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE && this.cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_AWARE) {
            return false;
        }
        this.initialise();
        if (this.checkClassIsEnhanced(false)) {
            DataNucleusEnhancer.LOGGER.info((Object)LOCALISER.msg("Enhancer.ClassIsAlreadyEnhanced", (Object)this.className));
            return true;
        }
        try {
            ClassWriter cw = new ClassWriter(1);
            JdoClassAdapter cv = new JdoClassAdapter((ClassVisitor)cw, this);
            ClassReader cr = null;
            cr = this.inputBytes != null ? new ClassReader(this.inputBytes) : new ClassReader(this.clr.getResource(this.inputResourceName, null).openStream());
            cr.accept((ClassVisitor)cv, 0);
            this.classBytes = cw.toByteArray();
        }
        catch (Exception e) {
            DataNucleusEnhancer.LOGGER.error((Object)"Error thrown enhancing with ASMClassEnhancer", (Throwable)e);
            return false;
        }
        this.update = true;
        return true;
    }

    public byte[] getBytes() {
        return this.classBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String directoryName) throws IOException {
        if (!this.update) {
            return;
        }
        File file = null;
        if (directoryName != null) {
            File baseDir = new File(directoryName);
            if (!baseDir.exists()) {
                baseDir.mkdirs();
            } else if (!baseDir.isDirectory()) {
                throw new RuntimeException("not directory " + directoryName);
            }
            String sep = System.getProperty("file.separator");
            String name = this.cmd.getFullClassName();
            name = name.replace('.', sep.charAt(0));
            name = name + ".class";
            file = new File(directoryName, name);
            file.getParentFile().mkdirs();
            DataNucleusEnhancer.LOGGER.info((Object)LOCALISER.msg("Enhancer.UpdateClass", (Object)file.getCanonicalPath()));
        } else {
            URL classURL = this.clr.getResource(this.className.replace('.', '/') + ".class", null);
            DataNucleusEnhancer.LOGGER.info((Object)LOCALISER.msg("Enhancer.UpdateClass", (Object)classURL));
            URL convertedPath = this.cmd.getMetaDataManager().getOMFContext().getPluginManager().resolveURLAsFileURL(classURL);
            if (!convertedPath.toString().equals(classURL.toString())) {
                DataNucleusEnhancer.LOGGER.info((Object)LOCALISER.msg("Enhancer.UpdateClass", (Object)classURL));
            }
            file = StringUtils.getFileForFilename((String)convertedPath.getFile());
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            out.write(this.getBytes());
        }
        finally {
            try {
                out.close();
                out = null;
            }
            catch (Exception ignore) {}
        }
    }

    public boolean validate() {
        if (this.cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE && this.cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_AWARE) {
            return false;
        }
        this.initialise();
        return this.checkClassIsEnhanced(true);
    }

    protected boolean checkClassIsEnhanced(boolean logErrors) {
        try {
            JdoClassChecker checker = new JdoClassChecker(this, logErrors);
            ClassReader cr = null;
            cr = this.inputBytes != null ? new ClassReader(this.inputBytes) : new ClassReader(this.clr.getResource(this.inputResourceName, null).openStream());
            cr.accept((ClassVisitor)checker, 0);
            return checker.isEnhanced();
        }
        catch (Exception e) {
            DataNucleusEnhancer.LOGGER.error((Object)"Error thrown enhancing with ASMClassEnhancer", (Throwable)e);
            return false;
        }
    }

    public static class MyClassVisitor
    implements ClassVisitor {
        String className = null;

        public String getClassName() {
            return this.className;
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
        }

        public void visit(int version, int access, String name, String sig, String supername, String[] intfs) {
            this.className = name.replace('/', '.');
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return null;
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            return null;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] excpts) {
            return null;
        }

        public void visitAttribute(Attribute attr) {
        }

        public void visitOuterClass(String owner, String name, String desc) {
        }

        public void visitSource(String source, String debug) {
        }

        public void visitEnd() {
        }
    }
}

