/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping;

import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.exceptions.UnsupportedDataTypeException;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.adapter.RDBMSAdapter;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.util.Localiser;

public abstract class RDBMSMapping
implements DatastoreMapping {
    protected static final Localiser LOCALISER_STORE = Localiser.getInstance((String)"org.datanucleus.Localisation", (ClassLoader)ObjectManagerFactoryImpl.class.getClassLoader());
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSManager.class.getClassLoader());
    protected final MappedStoreManager storeMgr;
    protected final JavaTypeMapping mapping;
    protected Column column;

    protected RDBMSMapping(MappedStoreManager storeMgr, JavaTypeMapping mapping) {
        this.storeMgr = storeMgr;
        this.mapping = mapping;
        if (mapping != null) {
            mapping.addDataStoreMapping((DatastoreMapping)this);
        }
    }

    protected RDBMSAdapter getDatabaseAdapter() {
        return (RDBMSAdapter)this.storeMgr.getDatastoreAdapter();
    }

    public JavaTypeMapping getJavaTypeMapping() {
        return this.mapping;
    }

    public abstract SQLTypeInfo getTypeInfo();

    public boolean isNullable() {
        if (this.column != null) {
            return this.column.isNullable();
        }
        return true;
    }

    public boolean includeInFetchStatement() {
        return true;
    }

    public boolean insertValuesOnInsert() {
        return this.getInsertionInputParameter().indexOf(63) > -1;
    }

    public String getInsertionInputParameter() {
        return this.column.getWrapperFunction(1);
    }

    public String getUpdateInputParameter() {
        return this.column.getWrapperFunction(2);
    }

    protected String failureMessage(String method) {
        return LOCALISER_STORE.msg("041005", (Object)this.getClass().getName(), (Object)method, (Object)this.mapping.getMemberMetaData().getFullFieldName());
    }

    public void setBoolean(Object preparedStatement, int exprIndex, boolean value) {
        throw new NucleusException(this.failureMessage("setBoolean")).setFatal();
    }

    public boolean getBoolean(Object resultSet, int exprIndex) {
        throw new NucleusException(this.failureMessage("getBoolean")).setFatal();
    }

    public void setChar(Object preparedStatement, int exprIndex, char value) {
        throw new NucleusException(this.failureMessage("setChar")).setFatal();
    }

    public char getChar(Object resultSet, int exprIndex) {
        throw new NucleusException(this.failureMessage("getChar")).setFatal();
    }

    public void setByte(Object preparedStatement, int exprIndex, byte value) {
        throw new NucleusException(this.failureMessage("setByte")).setFatal();
    }

    public byte getByte(Object resultSet, int exprIndex) {
        throw new NucleusException(this.failureMessage("getByte")).setFatal();
    }

    public void setShort(Object preparedStatement, int exprIndex, short value) {
        throw new NucleusException(this.failureMessage("setShort")).setFatal();
    }

    public short getShort(Object resultSet, int exprIndex) {
        throw new NucleusException(this.failureMessage("getShort")).setFatal();
    }

    public void setInt(Object preparedStatement, int exprIndex, int value) {
        throw new NucleusException(this.failureMessage("setInt")).setFatal();
    }

    public int getInt(Object resultSet, int exprIndex) {
        throw new NucleusException(this.failureMessage("getInt")).setFatal();
    }

    public void setLong(Object preparedStatement, int exprIndex, long value) {
        throw new NucleusException(this.failureMessage("setLong")).setFatal();
    }

    public long getLong(Object resultSet, int exprIndex) {
        throw new NucleusException(this.failureMessage("getLong")).setFatal();
    }

    public void setFloat(Object preparedStatement, int exprIndex, float value) {
        throw new NucleusException(this.failureMessage("setFloat")).setFatal();
    }

    public float getFloat(Object resultSet, int exprIndex) {
        throw new NucleusException(this.failureMessage("getFloat")).setFatal();
    }

    public void setDouble(Object preparedStatement, int exprIndex, double value) {
        throw new NucleusException(this.failureMessage("setDouble")).setFatal();
    }

    public double getDouble(Object resultSet, int exprIndex) {
        throw new NucleusException(this.failureMessage("getDouble")).setFatal();
    }

    public void setString(Object preparedStatement, int exprIndex, String value) {
        throw new NucleusException(this.failureMessage("setString")).setFatal();
    }

    public String getString(Object resultSet, int exprIndex) {
        throw new NucleusException(this.failureMessage("getString")).setFatal();
    }

    public void setObject(Object preparedStatement, int exprIndex, Object value) {
        throw new NucleusException(this.failureMessage("setObject")).setFatal();
    }

    public Object getObject(Object resultSet, int exprIndex) {
        throw new NucleusException(this.failureMessage("getObject")).setFatal();
    }

    public boolean isDecimalBased() {
        return false;
    }

    public boolean isIntegerBased() {
        return false;
    }

    public boolean isStringBased() {
        return false;
    }

    public boolean isBitBased() {
        return false;
    }

    public boolean isBooleanBased() {
        return false;
    }

    public DatastoreField getDatastoreField() {
        return this.column;
    }

    protected void initTypeInfo() {
        SQLTypeInfo typeInfo = this.getTypeInfo();
        if (typeInfo == null) {
            throw new UnsupportedDataTypeException(LOCALISER.msg("055000", (Object)this.column));
        }
        if (this.column != null) {
            this.column.setTypeInfo(typeInfo);
        }
    }

    public Column getColumn() {
        return this.column;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RDBMSMapping)) {
            return false;
        }
        RDBMSMapping cm = (RDBMSMapping)obj;
        return this.getClass().equals(cm.getClass()) && this.storeMgr.equals(cm.storeMgr) && (this.column == null ? cm.column == null : this.column.equals(cm.column));
    }

    public int hashCode() {
        return this.storeMgr.hashCode() ^ (this.column == null ? 0 : this.column.hashCode());
    }
}

