/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class ColumnInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String internalName;
    private String alias = null;
    private String tabAlias;
    private boolean isPartitionCol;
    private transient TypeInfo type;

    public ColumnInfo() {
    }

    public ColumnInfo(String internalName, TypeInfo type, String tabAlias, boolean isPartitionCol) {
        this.internalName = internalName;
        this.type = type;
        this.tabAlias = tabAlias;
        this.isPartitionCol = isPartitionCol;
    }

    public ColumnInfo(String internalName, Class type, String tabAlias, boolean isPartitionCol) {
        this.internalName = internalName;
        this.type = TypeInfoFactory.getPrimitiveTypeInfoFromPrimitiveWritable(type);
        this.tabAlias = tabAlias;
        this.isPartitionCol = isPartitionCol;
    }

    public TypeInfo getType() {
        return this.type;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public void setType(TypeInfo type) {
        this.type = type;
    }

    public void setInternalName(String internalName) {
        this.internalName = internalName;
    }

    public String getTabAlias() {
        return this.tabAlias;
    }

    public boolean getIsPartitionCol() {
        return this.isPartitionCol;
    }

    public String toString() {
        return this.internalName + ": " + this.type;
    }

    public void setAlias(String col_alias) {
        this.alias = col_alias;
    }

    public String getAlias() {
        return this.alias;
    }
}

