/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.exprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

public class ExprNodeGenericFuncEvaluator
extends ExprNodeEvaluator {
    private static final Log LOG = LogFactory.getLog((String)ExprNodeGenericFuncEvaluator.class.getName());
    protected exprNodeGenericFuncDesc expr;
    transient GenericUDF genericUDF;
    transient Object rowObject;
    transient ExprNodeEvaluator[] children;
    transient DeferredExprObject[] deferredChildren;

    public ExprNodeGenericFuncEvaluator(exprNodeGenericFuncDesc expr) {
        int i;
        this.expr = expr;
        this.children = new ExprNodeEvaluator[expr.getChildExprs().size()];
        for (i = 0; i < this.children.length; ++i) {
            this.children[i] = ExprNodeEvaluatorFactory.get(expr.getChildExprs().get(i));
        }
        this.deferredChildren = new DeferredExprObject[expr.getChildExprs().size()];
        for (i = 0; i < this.deferredChildren.length; ++i) {
            this.deferredChildren[i] = new DeferredExprObject(this.children[i]);
        }
    }

    @Override
    public ObjectInspector initialize(ObjectInspector rowInspector) throws HiveException {
        ObjectInspector[] childrenOIs = new ObjectInspector[this.children.length];
        for (int i = 0; i < this.children.length; ++i) {
            childrenOIs[i] = this.children[i].initialize(rowInspector);
        }
        this.genericUDF = this.expr.getGenericUDF();
        return this.genericUDF.initialize(childrenOIs);
    }

    @Override
    public Object evaluate(Object row) throws HiveException {
        this.rowObject = row;
        return this.genericUDF.evaluate(this.deferredChildren);
    }

    class DeferredExprObject
    implements GenericUDF.DeferredObject {
        ExprNodeEvaluator eval;

        DeferredExprObject(ExprNodeEvaluator eval) {
            this.eval = eval;
        }

        @Override
        public Object get() throws HiveException {
            return this.eval.evaluate(ExprNodeGenericFuncEvaluator.this.rowObject);
        }
    }
}

