/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.CommonJoinOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.persistence.RowContainer;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.ql.plan.joinDesc;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public class JoinOperator
extends CommonJoinOperator<joinDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        this.initializeChildren(hconf);
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        try {
            this.alias = (byte)tag;
            if (this.lastAlias == null || !this.lastAlias.equals(this.alias)) {
                this.nextSz = this.joinEmitInterval;
            }
            ArrayList<Object> nr = JoinOperator.computeValues(row, (List)this.joinValues.get(this.alias), (List)this.joinValuesObjectInspectors.get(this.alias));
            int sz = ((RowContainer)this.storage.get(this.alias)).size();
            if (this.alias == this.numAliases - 1) {
                if (sz == this.joinEmitInterval) {
                    this.checkAndGenObject();
                    ((RowContainer)this.storage.get(this.alias)).clear();
                }
            } else if (sz == this.nextSz) {
                StructObjectInspector soi = (StructObjectInspector)this.inputObjInspectors[tag];
                StructField sf = soi.getStructFieldRef(Utilities.ReduceField.KEY.toString());
                Object keyObject = soi.getStructFieldData(row, sf);
                LOG.warn((Object)("table " + this.alias + " has " + sz + " rows for join key " + keyObject));
                this.nextSz = this.getNextSize(this.nextSz);
            }
            ((RowContainer)this.storage.get(this.alias)).add(nr);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HiveException(e);
        }
    }

    @Override
    public OperatorType getType() {
        return OperatorType.JOIN;
    }
}

