/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.mapredWork;
import org.apache.hadoop.hive.ql.plan.partitionDesc;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class MapOperator
extends Operator<mapredWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient LongWritable deserialize_error_count = new LongWritable();
    private transient Deserializer deserializer;
    private transient Object[] rowWithPart;
    private transient StructObjectInspector rowObjectInspector;
    private transient boolean isPartitioned;
    private Map<MapInputPath, MapOpCtx> opCtxMap;
    private Map<Operator<? extends Serializable>, ArrayList<String>> operatorToPaths;
    private ArrayList<String> childrenPaths = new ArrayList();
    private ArrayList<Operator<? extends Serializable>> extraChildrenToClose = null;

    public void initializeAsRoot(Configuration hconf, mapredWork mrwork) throws HiveException {
        this.setConf(mrwork);
        this.setChildren(hconf);
        this.initialize(hconf, null);
    }

    private static MapOpCtx initObjectInspector(mapredWork conf, Configuration hconf, String onefile) throws HiveException, ClassNotFoundException, InstantiationException, IllegalAccessException, SerDeException {
        partitionDesc td = conf.getPathToPartitionInfo().get(onefile);
        LinkedHashMap<String, String> partSpec = td.getPartSpec();
        Properties tblProps = td.getProperties();
        Class sdclass = td.getDeserializerClass();
        if (sdclass == null) {
            String className = td.getSerdeClassName();
            if (className == "" || className == null) {
                throw new HiveException("SerDe class or the SerDe class name is not set for table: " + td.getProperties().getProperty("name"));
            }
            sdclass = hconf.getClassByName(className);
        }
        String tableName = String.valueOf(tblProps.getProperty("name"));
        String partName = String.valueOf(partSpec);
        Deserializer deserializer = sdclass.newInstance();
        deserializer.initialize(hconf, tblProps);
        StructObjectInspector rowObjectInspector = (StructObjectInspector)deserializer.getObjectInspector();
        MapOpCtx opCtx = null;
        String pcols = tblProps.getProperty("partition_columns");
        if (pcols != null && pcols.length() > 0) {
            String[] partKeys = pcols.trim().split("/");
            ArrayList<String> partNames = new ArrayList<String>(partKeys.length);
            Object[] partValues = new Object[partKeys.length];
            ArrayList<ObjectInspector> partObjectInspectors = new ArrayList<ObjectInspector>(partKeys.length);
            for (int i = 0; i < partKeys.length; ++i) {
                String key = partKeys[i];
                partNames.add(key);
                partValues[i] = partSpec == null ? new Text() : new Text(partSpec.get(key));
                partObjectInspectors.add(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
            }
            StandardStructObjectInspector partObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(partNames, partObjectInspectors);
            Object[] rowWithPart = new Object[2];
            rowWithPart[1] = partValues;
            rowObjectInspector = ObjectInspectorFactory.getUnionStructObjectInspector(Arrays.asList(rowObjectInspector, partObjectInspector));
            opCtx = new MapOpCtx(true, rowObjectInspector, rowWithPart, deserializer);
        } else {
            opCtx = new MapOpCtx(false, rowObjectInspector, null, deserializer);
        }
        opCtx.tableName = tableName;
        opCtx.partName = partName;
        return opCtx;
    }

    public void setChildren(Configuration hconf) throws HiveException {
        Path fpath = new Path(new Path(HiveConf.getVar(hconf, HiveConf.ConfVars.HADOOPMAPFILENAME)).toUri().getPath());
        ArrayList<Operator<? extends Serializable>> children = new ArrayList<Operator<? extends Serializable>>();
        this.opCtxMap = new HashMap<MapInputPath, MapOpCtx>();
        this.operatorToPaths = new HashMap<Operator<? extends Serializable>, ArrayList<String>>();
        this.statsMap.put(Counter.DESERIALIZE_ERRORS, this.deserialize_error_count);
        try {
            boolean done = false;
            for (String onefile : ((mapredWork)this.conf).getPathToAliases().keySet()) {
                MapOpCtx opCtx = MapOperator.initObjectInspector((mapredWork)this.conf, hconf, onefile);
                Path onepath = new Path(new Path(onefile).toUri().getPath());
                List aliases = ((mapredWork)this.conf).getPathToAliases().get(onefile);
                for (String onealias : aliases) {
                    Operator<? extends Serializable> op = ((mapredWork)this.conf).getAliasToWork().get(onealias);
                    this.LOG.info((Object)("Adding alias " + onealias + " to work list for file " + fpath.toUri().getPath()));
                    MapInputPath inp = new MapInputPath(onefile, onealias, op);
                    this.opCtxMap.put(inp, opCtx);
                    if (this.operatorToPaths.get(op) == null) {
                        this.operatorToPaths.put(op, new ArrayList());
                    }
                    this.operatorToPaths.get(op).add(onefile);
                    op.setParentOperators(new ArrayList<Operator<? extends Serializable>>());
                    op.getParentOperators().add(this);
                    if (onepath.toUri().relativize(fpath.toUri()).equals(fpath.toUri())) continue;
                    children.add(op);
                    this.childrenPaths.add(onefile);
                    this.LOG.info((Object)("dump " + op.getName() + " " + this.opCtxMap.get(inp).getRowObjectInspector().getTypeName()));
                    if (done) continue;
                    this.deserializer = this.opCtxMap.get(inp).getDeserializer();
                    this.isPartitioned = this.opCtxMap.get(inp).isPartitioned();
                    this.rowWithPart = this.opCtxMap.get(inp).getRowWithPart();
                    this.rowObjectInspector = this.opCtxMap.get(inp).getRowObjectInspector();
                    done = true;
                }
            }
            if (children.size() == 0) {
                this.LOG.error((Object)("Configuration does not have any alias for path: " + fpath.toUri().getPath()));
                throw new HiveException("Configuration and input path are inconsistent");
            }
            this.setChildOperators(children);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    @Override
    public void initializeOp(Configuration hconf) throws HiveException {
        this.state = Operator.State.INIT;
        List<Operator<Serializable>> children = this.getChildOperators();
        for (Map.Entry<MapInputPath, MapOpCtx> entry : this.opCtxMap.entrySet()) {
            HiveConf.setVar(hconf, HiveConf.ConfVars.HIVETABLENAME, entry.getValue().tableName);
            HiveConf.setVar(hconf, HiveConf.ConfVars.HIVEPARTITIONNAME, entry.getValue().partName);
            MapInputPath input = entry.getKey();
            Operator<? extends Serializable> op = input.op;
            if (children.indexOf(op) == -1) {
                if (this.extraChildrenToClose == null) {
                    this.extraChildrenToClose = new ArrayList();
                }
                this.extraChildrenToClose.add(op);
            }
            boolean shouldInit = true;
            List paths = this.operatorToPaths.get(op);
            for (String path : paths) {
                if (!this.childrenPaths.contains(path) || path.equals(input.path)) continue;
                shouldInit = false;
                break;
            }
            if (!shouldInit) continue;
            op.initialize(hconf, new ObjectInspector[]{entry.getValue().getRowObjectInspector()});
        }
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        if (this.extraChildrenToClose != null) {
            for (Operator<? extends Serializable> op : this.extraChildrenToClose) {
                op.close(abort);
            }
        }
    }

    public void process(Writable value) throws HiveException {
        try {
            if (!this.isPartitioned) {
                Object row = this.deserializer.deserialize(value);
                this.forward(row, this.rowObjectInspector);
            } else {
                this.rowWithPart[0] = this.deserializer.deserialize(value);
                this.forward(this.rowWithPart, this.rowObjectInspector);
            }
        }
        catch (SerDeException e) {
            this.deserialize_error_count.set(this.deserialize_error_count.get() + 1L);
            throw new HiveException(e);
        }
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        throw new HiveException("Hive 2 Internal error: should not be called!");
    }

    @Override
    public String getName() {
        return "MAP";
    }

    private static class MapOpCtx {
        boolean isPartitioned;
        StructObjectInspector rowObjectInspector;
        Object[] rowWithPart;
        Deserializer deserializer;
        public String tableName;
        public String partName;

        public MapOpCtx(boolean isPartitioned, StructObjectInspector rowObjectInspector, Object[] rowWithPart, Deserializer deserializer) {
            this.isPartitioned = isPartitioned;
            this.rowObjectInspector = rowObjectInspector;
            this.rowWithPart = rowWithPart;
            this.deserializer = deserializer;
        }

        public boolean isPartitioned() {
            return this.isPartitioned;
        }

        public StructObjectInspector getRowObjectInspector() {
            return this.rowObjectInspector;
        }

        public Object[] getRowWithPart() {
            return this.rowWithPart;
        }

        public Deserializer getDeserializer() {
            return this.deserializer;
        }
    }

    private static class MapInputPath {
        String path;
        String alias;
        Operator<? extends Serializable> op;

        public MapInputPath(String path, String alias, Operator<? extends Serializable> op) {
            this.path = path;
            this.alias = alias;
            this.op = op;
        }

        public boolean equals(Object o) {
            if (o instanceof MapInputPath) {
                MapInputPath mObj = (MapInputPath)o;
                if (mObj == null) {
                    return false;
                }
                return this.path.equals(mObj.path) && this.alias.equals(mObj.alias) && this.op.equals(mObj.op);
            }
            return false;
        }

        public int hashCode() {
            return this.op == null ? 0 : this.op.hashCode();
        }
    }

    public static enum Counter {
        DESERIALIZE_ERRORS;

    }
}

