/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.AmbiguousMethodException;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ErrorMsg;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.TypeCheckCtx;
import org.apache.hadoop.hive.ql.plan.exprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.exprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.exprNodeDesc;
import org.apache.hadoop.hive.ql.plan.exprNodeFieldDesc;
import org.apache.hadoop.hive.ql.plan.exprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.exprNodeNullDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class TypeCheckProcFactory {
    protected static final Log LOG = LogFactory.getLog((String)TypeCheckProcFactory.class.getName());

    public static exprNodeDesc processGByExpr(Node nd, Object procCtx) throws SemanticException {
        ASTNode expr = (ASTNode)nd;
        TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
        RowResolver input = ctx.getInputRR();
        exprNodeColumnDesc desc = null;
        ColumnInfo colInfo = input.get("", expr.toStringTree());
        if (colInfo != null) {
            desc = new exprNodeColumnDesc(colInfo.getType(), colInfo.getInternalName(), colInfo.getTabAlias(), colInfo.getIsPartitionCol());
            return desc;
        }
        return desc;
    }

    public static NullExprProcessor getNullExprProcessor() {
        return new NullExprProcessor();
    }

    public static NumExprProcessor getNumExprProcessor() {
        return new NumExprProcessor();
    }

    public static StrExprProcessor getStrExprProcessor() {
        return new StrExprProcessor();
    }

    public static BoolExprProcessor getBoolExprProcessor() {
        return new BoolExprProcessor();
    }

    public static ColumnExprProcessor getColumnExprProcessor() {
        return new ColumnExprProcessor();
    }

    public static DefaultExprProcessor getDefaultExprProcessor() {
        return new DefaultExprProcessor();
    }

    public static class DefaultExprProcessor
    implements NodeProcessor {
        static HashMap<Integer, String> specialUnaryOperatorTextHashMap = new HashMap();
        static HashMap<Integer, String> specialFunctionTextHashMap;
        static HashMap<Integer, String> conversionFunctionTextHashMap;

        public static boolean isRedundantConversionFunction(ASTNode expr, boolean isFunction, ArrayList<exprNodeDesc> children) {
            if (!isFunction) {
                return false;
            }
            assert (children.size() == expr.getChildCount() - 1);
            if (children.size() != 1) {
                return false;
            }
            String funcText = conversionFunctionTextHashMap.get(((ASTNode)expr.getChild(0)).getType());
            if (funcText == null) {
                return false;
            }
            return ((PrimitiveTypeInfo)children.get(0).getTypeInfo()).getTypeName().equalsIgnoreCase(funcText);
        }

        public static String getFunctionText(ASTNode expr, boolean isFunction) {
            String funcText = null;
            if (!isFunction) {
                if (expr.getChildCount() == 1) {
                    funcText = specialUnaryOperatorTextHashMap.get(expr.getType());
                }
                if (funcText == null) {
                    funcText = expr.getText();
                }
            } else {
                assert (expr.getChildCount() >= 1);
                int funcType = ((ASTNode)expr.getChild(0)).getType();
                funcText = specialFunctionTextHashMap.get(funcType);
                if (funcText == null) {
                    funcText = conversionFunctionTextHashMap.get(funcType);
                }
                if (funcText == null) {
                    funcText = ((ASTNode)expr.getChild(0)).getText();
                }
            }
            return funcText;
        }

        public static exprNodeDesc getFuncExprNodeDesc(String name, exprNodeDesc ... children) {
            ArrayList<exprNodeDesc> c = new ArrayList<exprNodeDesc>(Arrays.asList(children));
            try {
                return DefaultExprProcessor.getFuncExprNodeDesc(name, c);
            }
            catch (UDFArgumentException e) {
                throw new RuntimeException("Hive 2 internal error", e);
            }
        }

        public static exprNodeDesc getFuncExprNodeDesc(String udfName, List<exprNodeDesc> children) throws UDFArgumentException {
            FunctionInfo fi = FunctionRegistry.getFunctionInfo(udfName);
            if (fi == null) {
                throw new UDFArgumentException("udf:" + udfName + " not found.");
            }
            GenericUDF genericUDF = fi.getGenericUDF();
            if (genericUDF == null) {
                throw new UDFArgumentException("udf:" + udfName + " is an aggregation function.");
            }
            return exprNodeGenericFuncDesc.newInstance(genericUDF, children);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static exprNodeDesc getXpathOrFuncExprNodeDesc(ASTNode expr, boolean isFunction, ArrayList<exprNodeDesc> children) throws SemanticException, UDFArgumentException {
            exprNodeDesc desc;
            if (DefaultExprProcessor.isRedundantConversionFunction(expr, isFunction, children)) {
                assert (children.size() == 1);
                assert (children.get(0) != null);
                return children.get(0);
            }
            String funcText = DefaultExprProcessor.getFunctionText(expr, isFunction);
            if (funcText.equals(".")) {
                boolean isList;
                assert (children.size() == 2);
                assert (children.get(1) instanceof exprNodeConstantDesc);
                exprNodeDesc object = children.get(0);
                exprNodeConstantDesc fieldName = (exprNodeConstantDesc)children.get(1);
                assert (fieldName.getValue() instanceof String);
                String fieldNameString = (String)fieldName.getValue();
                TypeInfo objectTypeInfo = object.getTypeInfo();
                boolean bl = isList = object.getTypeInfo().getCategory() == ObjectInspector.Category.LIST;
                if (isList) {
                    objectTypeInfo = ((ListTypeInfo)objectTypeInfo).getListElementTypeInfo();
                }
                if (objectTypeInfo.getCategory() != ObjectInspector.Category.STRUCT) {
                    throw new SemanticException(ErrorMsg.INVALID_DOT.getMsg(expr));
                }
                TypeInfo t = ((StructTypeInfo)objectTypeInfo).getStructFieldTypeInfo(fieldNameString);
                if (isList) {
                    t = TypeInfoFactory.getListTypeInfo(t);
                }
                desc = new exprNodeFieldDesc(t, children.get(0), fieldNameString, isList);
            } else if (funcText.equals("[")) {
                assert (children.size() == 2);
                TypeInfo myt = children.get(0).getTypeInfo();
                if (myt.getCategory() == ObjectInspector.Category.LIST) {
                    if (!(children.get(1) instanceof exprNodeConstantDesc) || !((exprNodeConstantDesc)children.get(1)).getTypeInfo().equals(TypeInfoFactory.intTypeInfo)) {
                        throw new SemanticException(ErrorMsg.INVALID_ARRAYINDEX_CONSTANT.getMsg(expr));
                    }
                    TypeInfo t = ((ListTypeInfo)myt).getListElementTypeInfo();
                    desc = new exprNodeGenericFuncDesc(t, FunctionRegistry.getGenericUDFForIndex(), children);
                } else {
                    if (myt.getCategory() != ObjectInspector.Category.MAP) throw new SemanticException(ErrorMsg.NON_COLLECTION_TYPE.getMsg(expr, myt.getTypeName()));
                    if (!(children.get(1) instanceof exprNodeConstantDesc)) {
                        throw new SemanticException(ErrorMsg.INVALID_MAPINDEX_CONSTANT.getMsg(expr));
                    }
                    if (!((exprNodeConstantDesc)children.get(1)).getTypeInfo().equals(((MapTypeInfo)myt).getMapKeyTypeInfo())) {
                        throw new SemanticException(ErrorMsg.INVALID_MAPINDEX_TYPE.getMsg(expr));
                    }
                    TypeInfo t = ((MapTypeInfo)myt).getMapValueTypeInfo();
                    desc = new exprNodeGenericFuncDesc(t, FunctionRegistry.getGenericUDFForIndex(), children);
                }
            } else {
                FunctionInfo fi = FunctionRegistry.getFunctionInfo(funcText);
                if (fi == null) {
                    if (!isFunction) throw new SemanticException(ErrorMsg.INVALID_FUNCTION.getMsg(expr));
                    throw new SemanticException(ErrorMsg.INVALID_FUNCTION.getMsg((ASTNode)expr.getChild(0)));
                }
                if (fi.getGenericUDTF() != null) {
                    throw new SemanticException(ErrorMsg.UDTF_INVALID_LOCATION.getMsg());
                }
                try {
                    desc = DefaultExprProcessor.getFuncExprNodeDesc(funcText, children);
                }
                catch (AmbiguousMethodException e) {
                    ArrayList argumentClasses = new ArrayList(children.size());
                    for (int i = 0; i < children.size(); ++i) {
                        argumentClasses.add(((PrimitiveTypeInfo)children.get(i).getTypeInfo()).getPrimitiveWritableClass());
                    }
                    if (isFunction) {
                        String reason = "Looking for UDF \"" + expr.getChild(0).getText() + "\" with parameters " + argumentClasses;
                        throw new SemanticException(ErrorMsg.INVALID_FUNCTION_SIGNATURE.getMsg((ASTNode)expr.getChild(0), reason), e);
                    }
                    String reason = "Looking for Operator \"" + expr.getText() + "\" with parameters " + argumentClasses;
                    throw new SemanticException(ErrorMsg.INVALID_OPERATOR_SIGNATURE.getMsg(expr, reason), e);
                }
            }
            if (FunctionRegistry.isOpPositive(desc)) {
                assert (desc.getChildren().size() == 1);
                desc = desc.getChildren().get(0);
            }
            assert (desc != null);
            return desc;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            exprNodeDesc desc = TypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                ctx.setError(null);
                return desc;
            }
            if (ctx.getError() != null) {
                return null;
            }
            ASTNode expr = (ASTNode)nd;
            if (expr.getType() == 190 && expr.getChild(0).getType() == 19 && nodeOutputs[0] == null) {
                String tableAlias;
                RowResolver input = ctx.getInputRR();
                ColumnInfo colInfo = input.get(tableAlias = SemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getChild(0).getText()), ((exprNodeConstantDesc)nodeOutputs[1]).getValue().toString());
                if (colInfo == null) {
                    ctx.setError(ErrorMsg.INVALID_COLUMN.getMsg(expr.getChild(1)));
                    return null;
                }
                return new exprNodeColumnDesc(colInfo.getType(), colInfo.getInternalName(), colInfo.getTabAlias(), colInfo.getIsPartitionCol());
            }
            if (conversionFunctionTextHashMap.keySet().contains(expr.getType()) || specialFunctionTextHashMap.keySet().contains(expr.getType()) || expr.getToken().getType() == 286 || expr.getToken().getType() == 287) {
                return null;
            }
            boolean isFunction = expr.getType() == 20;
            int childrenBegin = isFunction ? 1 : 0;
            ArrayList<exprNodeDesc> children = new ArrayList<exprNodeDesc>(expr.getChildCount() - childrenBegin);
            for (int ci = childrenBegin; ci < expr.getChildCount(); ++ci) {
                children.add((exprNodeDesc)nodeOutputs[ci]);
            }
            if (children.contains(null)) {
                return null;
            }
            try {
                return DefaultExprProcessor.getXpathOrFuncExprNodeDesc(expr, isFunction, children);
            }
            catch (UDFArgumentTypeException e) {
                throw new SemanticException(ErrorMsg.INVALID_ARGUMENT_TYPE.getMsg(expr.getChild(childrenBegin + e.getArgumentId()), e.getMessage()));
            }
            catch (UDFArgumentLengthException e) {
                throw new SemanticException(ErrorMsg.INVALID_ARGUMENT_LENGTH.getMsg(expr, e.getMessage()));
            }
            catch (UDFArgumentException e) {
                throw new SemanticException(ErrorMsg.INVALID_ARGUMENT.getMsg(expr, e.getMessage()));
            }
        }

        static {
            specialUnaryOperatorTextHashMap.put(253, "positive");
            specialUnaryOperatorTextHashMap.put(291, "negative");
            specialFunctionTextHashMap = new HashMap();
            specialFunctionTextHashMap.put(63, "isnull");
            specialFunctionTextHashMap.put(64, "isnotnull");
            conversionFunctionTextHashMap = new HashMap();
            conversionFunctionTextHashMap.put(69, "boolean");
            conversionFunctionTextHashMap.put(65, "tinyint");
            conversionFunctionTextHashMap.put(66, "smallint");
            conversionFunctionTextHashMap.put(67, "int");
            conversionFunctionTextHashMap.put(68, "bigint");
            conversionFunctionTextHashMap.put(70, "float");
            conversionFunctionTextHashMap.put(71, "double");
            conversionFunctionTextHashMap.put(75, "string");
        }
    }

    public static class ColumnExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            exprNodeDesc desc = TypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            ASTNode expr = (ASTNode)nd;
            RowResolver input = ctx.getInputRR();
            if (expr.getType() != 19) {
                ctx.setError(ErrorMsg.INVALID_COLUMN.getMsg(expr));
                return null;
            }
            assert (expr.getChildCount() == 1);
            String tableOrCol = BaseSemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getText());
            boolean isTableAlias = input.hasTableAlias(tableOrCol);
            ColumnInfo colInfo = input.get(null, tableOrCol);
            if (isTableAlias) {
                if (colInfo != null) {
                    ctx.setError(ErrorMsg.AMBIGUOUS_TABLE_OR_COLUMN.getMsg(expr));
                    return null;
                }
                return null;
            }
            if (colInfo == null) {
                if (input.getIsExprResolver()) {
                    ctx.setError(ErrorMsg.NON_KEY_EXPR_IN_GROUPBY.getMsg(expr));
                    return null;
                }
                ctx.setError(ErrorMsg.INVALID_TABLE_OR_COLUMN.getMsg(expr.getChild(0)));
                LOG.debug((Object)(ErrorMsg.INVALID_TABLE_OR_COLUMN.toString() + ":" + input.toString()));
                return null;
            }
            return new exprNodeColumnDesc(colInfo.getType(), colInfo.getInternalName(), colInfo.getTabAlias(), colInfo.getIsPartitionCol());
        }
    }

    public static class BoolExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            exprNodeDesc desc = TypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            ASTNode expr = (ASTNode)nd;
            Boolean bool = null;
            switch (expr.getToken().getType()) {
                case 306: {
                    bool = Boolean.TRUE;
                    break;
                }
                case 307: {
                    bool = Boolean.FALSE;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return new exprNodeConstantDesc(TypeInfoFactory.booleanTypeInfo, bool);
        }
    }

    public static class StrExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            exprNodeDesc desc = TypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            ASTNode expr = (ASTNode)nd;
            String str = null;
            switch (expr.getToken().getType()) {
                case 151: {
                    str = BaseSemanticAnalyzer.unescapeSQLString(expr.getText());
                    break;
                }
                case 122: {
                    str = BaseSemanticAnalyzer.charSetString(expr.getChild(0).getText(), expr.getChild(1).getText());
                    break;
                }
                default: {
                    str = BaseSemanticAnalyzer.unescapeIdentifier(expr.getText());
                }
            }
            return new exprNodeConstantDesc(TypeInfoFactory.stringTypeInfo, str);
        }
    }

    public static class NumExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            exprNodeDesc desc = TypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            Number v = null;
            ASTNode expr = (ASTNode)nd;
            try {
                v = Double.valueOf(expr.getText());
                v = Long.valueOf(expr.getText());
                v = Integer.valueOf(expr.getText());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (v == null) {
                throw new SemanticException(ErrorMsg.INVALID_NUMERICAL_CONSTANT.getMsg(expr));
            }
            return new exprNodeConstantDesc(v);
        }
    }

    public static class NullExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            exprNodeDesc desc = TypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            return new exprNodeNullDesc();
        }
    }
}

