/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.description;
import org.apache.hadoop.hive.ql.udf.UDFBaseCompare;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;

@description(name=">", value="a _FUNC_ b - Returns TRUE if a is greater than b")
public class UDFOPGreaterThan
extends UDFBaseCompare {
    private static Log LOG = LogFactory.getLog((String)UDFOPGreaterThan.class.getName());
    BooleanWritable resultCache = new BooleanWritable();

    public BooleanWritable evaluate(Text a, Text b) {
        BooleanWritable r = this.resultCache;
        if (a == null || b == null) {
            r = null;
        } else {
            r.set(ShimLoader.getHadoopShims().compareText(a, b) > 0);
        }
        return r;
    }

    public BooleanWritable evaluate(ByteWritable a, ByteWritable b) {
        BooleanWritable r = this.resultCache;
        if (a == null || b == null) {
            r = null;
        } else {
            r.set(a.get() > b.get());
        }
        return r;
    }

    public BooleanWritable evaluate(ShortWritable a, ShortWritable b) {
        BooleanWritable r = this.resultCache;
        if (a == null || b == null) {
            r = null;
        } else {
            r.set(a.get() > b.get());
        }
        return r;
    }

    public BooleanWritable evaluate(IntWritable a, IntWritable b) {
        BooleanWritable r = this.resultCache;
        if (a == null || b == null) {
            r = null;
        } else {
            r.set(a.get() > b.get());
        }
        return r;
    }

    public BooleanWritable evaluate(LongWritable a, LongWritable b) {
        BooleanWritable r = this.resultCache;
        if (a == null || b == null) {
            r = null;
        } else {
            r.set(a.get() > b.get());
        }
        return r;
    }

    public BooleanWritable evaluate(FloatWritable a, FloatWritable b) {
        BooleanWritable r = this.resultCache;
        if (a == null || b == null) {
            r = null;
        } else {
            r.set(a.get() > b.get());
        }
        return r;
    }

    @Override
    public BooleanWritable evaluate(DoubleWritable a, DoubleWritable b) {
        BooleanWritable r = this.resultCache;
        if (a == null || b == null) {
            r = null;
        } else {
            r.set(a.get() > b.get());
        }
        return r;
    }
}

