/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.description;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;

@UDFType(deterministic=false)
@description(name="unix_timestamp", value="_FUNC_([date[, pattern]]) - Returns the UNIX timestamp", extended="Converts the current or specified time to number of seconds since 1970-01-01.")
public class UDFUnixTimeStamp
extends UDF {
    private static Log LOG = LogFactory.getLog((String)UDFUnixTimeStamp.class.getName());
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    LongWritable result = new LongWritable();
    Text lastPatternText = new Text();

    public LongWritable evaluate() {
        Date date = new Date();
        this.result.set(date.getTime() / 1000L);
        return this.result;
    }

    public LongWritable evaluate(Text dateText) {
        if (dateText == null) {
            return null;
        }
        try {
            Date date = this.formatter.parse(dateText.toString());
            this.result.set(date.getTime() / 1000L);
            return this.result;
        }
        catch (ParseException e) {
            return null;
        }
    }

    public LongWritable evaluate(Text dateText, Text patternText) {
        if (dateText == null || patternText == null) {
            return null;
        }
        try {
            if (!patternText.equals((Object)this.lastPatternText)) {
                this.formatter.applyPattern(patternText.toString());
                this.lastPatternText.set(patternText);
            }
        }
        catch (Exception e) {
            return null;
        }
        return this.evaluate(dateText);
    }
}

