/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.util.ReflectionUtils;

public class GenericUDFBridge
extends GenericUDF
implements Serializable {
    private static Log LOG = LogFactory.getLog((String)GenericUDFBridge.class.getName());
    String udfName;
    boolean isOperator;
    Class<? extends UDF> udfClass;
    transient Method udfMethod;
    transient GenericUDFUtils.ConversionHelper conversionHelper;
    transient UDF udf;
    transient Object[] realArguments;

    public GenericUDFBridge(String udfName, boolean isOperator, Class<? extends UDF> udfClass) {
        this.udfName = udfName;
        this.isOperator = isOperator;
        this.udfClass = udfClass;
    }

    public GenericUDFBridge() {
    }

    public void setUdfName(String udfName) {
        this.udfName = udfName;
    }

    public String getUdfName() {
        return this.udfName;
    }

    public boolean isOperator() {
        return this.isOperator;
    }

    public void setOperator(boolean isOperator) {
        this.isOperator = isOperator;
    }

    public void setUdfClass(Class<? extends UDF> udfClass) {
        this.udfClass = udfClass;
    }

    public Class<? extends UDF> getUdfClass() {
        return this.udfClass;
    }

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        this.udf = (UDF)ReflectionUtils.newInstance(this.udfClass, null);
        ArrayList<TypeInfo> argumentTypeInfos = new ArrayList<TypeInfo>(arguments.length);
        for (int i = 0; i < arguments.length; ++i) {
            argumentTypeInfos.add(TypeInfoUtils.getTypeInfoFromObjectInspector(arguments[i]));
        }
        this.udfMethod = this.udf.getResolver().getEvalMethod(argumentTypeInfos);
        this.conversionHelper = new GenericUDFUtils.ConversionHelper(this.udfMethod, arguments);
        this.realArguments = new Object[arguments.length];
        ObjectInspector returnOI = ObjectInspectorFactory.getReflectionObjectInspector(this.udfMethod.getGenericReturnType(), ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
        return returnOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        assert (arguments.length == this.realArguments.length);
        for (int i = 0; i < this.realArguments.length; ++i) {
            this.realArguments[i] = arguments[i].get();
        }
        Object result = FunctionRegistry.invoke(this.udfMethod, this.udf, this.conversionHelper.convertIfNecessary(this.realArguments));
        return result;
    }

    @Override
    public String getDisplayString(String[] children) {
        if (this.isOperator) {
            if (children.length == 1) {
                return "(" + this.udfName + " " + children[0] + ")";
            }
            assert (children.length == 2);
            return "(" + children[0] + " " + this.udfName + " " + children[1] + ")";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.udfName);
        sb.append("(");
        for (int i = 0; i < children.length; ++i) {
            sb.append(children[i]);
            if (i + 1 >= children.length) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }
}

