/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.facebook.fb303.FacebookBase;
import com.facebook.fb303.fb_status;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.AlterHandler;
import org.apache.hadoop.hive.metastore.HiveAlterHandler;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.ConfigValSecurityException;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.IndexAlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.hadoop.hive.metastore.api.Type;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportFactory;

public class HiveMetaStore
extends ThriftHiveMetastore {
    public static void main(String[] args) {
        int port = 9083;
        if (args.length > 0) {
            port = Integer.getInteger(args[0]);
        }
        try {
            TServerSocket serverTransport = new TServerSocket(port);
            HMSHandler handler = new HMSHandler("new db based metaserver");
            ThriftHiveMetastore.Processor processor = new ThriftHiveMetastore.Processor(handler);
            TThreadPoolServer.Options options = new TThreadPoolServer.Options();
            options.minWorkerThreads = 200;
            TThreadPoolServer server = new TThreadPoolServer((TProcessor)processor, (TServerTransport)serverTransport, new TTransportFactory(), new TTransportFactory(), (TProtocolFactory)new TBinaryProtocol.Factory(), (TProtocolFactory)new TBinaryProtocol.Factory(), options);
            HMSHandler.LOG.info((Object)("Started the new metaserver on port [" + port + "]..."));
            HMSHandler.LOG.info((Object)("Options.minWorkerThreads = " + options.minWorkerThreads));
            HMSHandler.LOG.info((Object)("Options.maxWorkerThreads = " + options.maxWorkerThreads));
            server.serve();
        }
        catch (Throwable x) {
            x.printStackTrace();
            HMSHandler.LOG.error((Object)"Metastore Thrift Server threw an exception. Exiting...");
            HMSHandler.LOG.error((Object)StringUtils.stringifyException((Throwable)x));
            System.exit(1);
        }
    }

    public static class HMSHandler
    extends FacebookBase
    implements ThriftHiveMetastore.Iface {
        public static final Log LOG = LogFactory.getLog((String)HiveMetaStore.class.getName());
        private static boolean createDefaultDB = false;
        private String rawStoreClassName;
        private HiveConf hiveConf;
        private Warehouse wh;
        private ThreadLocal<RawStore> threadLocalMS = new ThreadLocal(){

            protected synchronized Object initialValue() {
                return null;
            }
        };
        private boolean checkForDefaultDb;
        private static int nextSerialNum = 0;
        private static ThreadLocal<Integer> threadLocalId = new ThreadLocal(){

            protected synchronized Object initialValue() {
                return new Integer(nextSerialNum++);
            }
        };
        private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        private AlterHandler alterHandler;

        public static Integer get() {
            return threadLocalId.get();
        }

        public HMSHandler(String name) throws MetaException {
            super(name);
            if (this.classLoader == null) {
                this.classLoader = Configuration.class.getClassLoader();
            }
            this.hiveConf = new HiveConf(this.getClass());
            this.init();
        }

        public HMSHandler(String name, HiveConf conf) throws MetaException {
            super(name);
            if (this.classLoader == null) {
                this.classLoader = Configuration.class.getClassLoader();
            }
            this.hiveConf = conf;
            this.init();
        }

        private boolean init() throws MetaException {
            this.rawStoreClassName = this.hiveConf.get("hive.metastore.rawstore.impl");
            this.checkForDefaultDb = this.hiveConf.getBoolean("hive.metastore.checkForDefaultDb", true);
            String alterHandlerName = this.hiveConf.get("hive.metastore.alter.impl", HiveAlterHandler.class.getName());
            this.alterHandler = (AlterHandler)ReflectionUtils.newInstance(this.getClass(alterHandlerName, AlterHandler.class), (Configuration)this.hiveConf);
            this.wh = new Warehouse((Configuration)this.hiveConf);
            this.createDefaultDB();
            return true;
        }

        private RawStore getMS() throws MetaException {
            RawStore ms = this.threadLocalMS.get();
            if (ms == null) {
                LOG.info((Object)(threadLocalId.get() + ": Opening raw store with implemenation class:" + this.rawStoreClassName));
                ms = (RawStore)ReflectionUtils.newInstance(this.getClass(this.rawStoreClassName, RawStore.class), (Configuration)this.hiveConf);
                this.threadLocalMS.set(ms);
                ms = this.threadLocalMS.get();
            }
            return ms;
        }

        private void createDefaultDB() throws MetaException {
            if (createDefaultDB || !this.checkForDefaultDb) {
                return;
            }
            try {
                this.getMS().getDatabase("default");
            }
            catch (NoSuchObjectException e) {
                this.getMS().createDatabase(new Database("default", this.wh.getDefaultDatabasePath("default").toString()));
            }
            createDefaultDB = true;
        }

        private Class<?> getClass(String rawStoreClassName, Class<?> class1) throws MetaException {
            try {
                return Class.forName(rawStoreClassName, true, this.classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new MetaException(rawStoreClassName + " class not found");
            }
        }

        private void logStartFunction(String m) {
            LOG.info((Object)(threadLocalId.get().toString() + ": " + m));
        }

        private void logStartFunction(String f, String db, String tbl) {
            LOG.info((Object)(threadLocalId.get().toString() + ": " + f + " : db=" + db + " tbl=" + tbl));
        }

        public fb_status getStatus() {
            return fb_status.ALIVE;
        }

        public void shutdown() {
            this.logStartFunction("Shutting down the object store...");
            try {
                if (this.threadLocalMS.get() != null) {
                    this.getMS().shutdown();
                }
            }
            catch (MetaException e) {
                LOG.error((Object)"unable to shutdown metastore", (Throwable)e);
            }
            System.exit(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean create_database(String name, String location_uri) throws AlreadyExistsException, MetaException {
            this.incrementCounter("create_database");
            this.logStartFunction("create_database: " + name);
            boolean success = false;
            try {
                this.getMS().openTransaction();
                Database db = new Database(name, location_uri);
                if (this.getMS().createDatabase(db) && this.wh.mkdirs(this.wh.getDefaultDatabasePath(name))) {
                    success = this.getMS().commitTransaction();
                }
            }
            finally {
                if (!success) {
                    this.getMS().rollbackTransaction();
                }
            }
            return success;
        }

        @Override
        public Database get_database(String name) throws NoSuchObjectException, MetaException {
            this.incrementCounter("get_database");
            this.logStartFunction("get_database: " + name);
            return this.getMS().getDatabase(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean drop_database(String name) throws MetaException {
            this.incrementCounter("drop_database");
            this.logStartFunction("drop_database: " + name);
            if (name.equalsIgnoreCase("default")) {
                throw new MetaException("Can't drop default database");
            }
            boolean success = false;
            try {
                this.getMS().openTransaction();
                if (this.getMS().dropDatabase(name)) {
                    success = this.getMS().commitTransaction();
                }
            }
            finally {
                if (!success) {
                    this.getMS().rollbackTransaction();
                } else {
                    this.wh.deleteDir(this.wh.getDefaultDatabasePath(name), true);
                }
            }
            return success;
        }

        @Override
        public List<String> get_databases() throws MetaException {
            this.incrementCounter("get_databases");
            this.logStartFunction("get_databases");
            return this.getMS().getDatabases();
        }

        @Override
        public boolean create_type(Type type) throws AlreadyExistsException, MetaException, InvalidObjectException {
            this.incrementCounter("create_type");
            this.logStartFunction("create_type: " + type.getName());
            if (this.get_type(type.getName()) != null) {
                throw new AlreadyExistsException("Type " + type.getName() + " already exists");
            }
            return this.getMS().createType(type);
        }

        @Override
        public Type get_type(String name) throws MetaException {
            this.incrementCounter("get_type");
            this.logStartFunction("get_type: " + name);
            return this.getMS().getType(name);
        }

        @Override
        public boolean drop_type(String name) throws MetaException {
            this.incrementCounter("drop_type");
            this.logStartFunction("drop_type: " + name);
            return this.getMS().dropType(name);
        }

        @Override
        public Map<String, Type> get_type_all(String name) throws MetaException {
            this.incrementCounter("get_type_all");
            this.logStartFunction("get_type_all");
            throw new MetaException("Not yet implemented");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void create_table(Table tbl) throws AlreadyExistsException, MetaException, InvalidObjectException {
            this.incrementCounter("create_table");
            this.logStartFunction("create_table: db=" + tbl.getDbName() + " tbl=" + tbl.getTableName());
            if (!MetaStoreUtils.validateName(tbl.getTableName()) || !MetaStoreUtils.validateColNames(tbl.getSd().getCols()) || tbl.getPartitionKeys() != null && !MetaStoreUtils.validateColNames(tbl.getPartitionKeys())) {
                throw new InvalidObjectException(tbl.getTableName() + " is not a valid object name");
            }
            Path tblPath = null;
            boolean success = false;
            boolean madeDir = false;
            try {
                this.getMS().openTransaction();
                if (tbl.getSd().getLocation() == null || tbl.getSd().getLocation().isEmpty()) {
                    tblPath = this.wh.getDefaultTablePath(tbl.getDbName(), tbl.getTableName());
                } else {
                    if (!this.isExternal(tbl)) {
                        LOG.warn((Object)("Location: " + tbl.getSd().getLocation() + "specified for non-external table:" + tbl.getTableName()));
                    }
                    tblPath = this.wh.getDnsPath(new Path(tbl.getSd().getLocation()));
                }
                tbl.getSd().setLocation(tblPath.toString());
                if (this.is_table_exists(tbl.getDbName(), tbl.getTableName())) {
                    throw new AlreadyExistsException("Table " + tbl.getTableName() + " already exists");
                }
                if (!this.wh.isDir(tblPath)) {
                    if (!this.wh.mkdirs(tblPath)) {
                        throw new MetaException(tblPath + " is not a directory or unable to create one");
                    }
                    madeDir = true;
                }
                long time = System.currentTimeMillis() / 1000L;
                tbl.setCreateTime((int)time);
                tbl.putToParameters("transient_lastDdlTime", Long.toString(time));
                this.getMS().createTable(tbl);
                success = this.getMS().commitTransaction();
                if (success) return;
                this.getMS().rollbackTransaction();
                if (!madeDir) return;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                this.getMS().rollbackTransaction();
                if (!madeDir) throw throwable;
                this.wh.deleteDir(tblPath, true);
                throw throwable;
            }
            this.wh.deleteDir(tblPath, true);
        }

        public boolean is_table_exists(String dbname, String name) throws MetaException {
            try {
                return this.get_table(dbname, name) != null;
            }
            catch (NoSuchObjectException e) {
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void drop_table(String dbname, String name, boolean deleteData) throws NoSuchObjectException, MetaException {
            this.incrementCounter("drop_table");
            this.logStartFunction("drop_table", dbname, name);
            boolean success = false;
            boolean isExternal = false;
            Path tblPath = null;
            Table tbl = null;
            isExternal = false;
            try {
                this.getMS().openTransaction();
                tbl = this.get_table(dbname, name);
                if (tbl == null) {
                    throw new NoSuchObjectException(name + " doesn't exist");
                }
                if (tbl.getSd() == null || tbl.getSd().getLocation() == null) {
                    throw new MetaException("Table metadata is corrupted");
                }
                isExternal = this.isExternal(tbl);
                tblPath = new Path(tbl.getSd().getLocation());
                if (!this.getMS().dropTable(dbname, name)) {
                    throw new MetaException("Unable to drop table");
                }
                tbl = null;
                success = this.getMS().commitTransaction();
                if (!success) {
                    this.getMS().rollbackTransaction();
                    return;
                }
                if (!deleteData || tblPath == null || isExternal) return;
            }
            catch (Throwable throwable) {
                if (!success) {
                    this.getMS().rollbackTransaction();
                    throw throwable;
                } else {
                    if (!deleteData || tblPath == null || isExternal) throw throwable;
                    this.wh.deleteDir(tblPath, true);
                }
                throw throwable;
            }
            this.wh.deleteDir(tblPath, true);
        }

        private boolean isExternal(Table table) {
            if (table == null) {
                return false;
            }
            Map<String, String> params = table.getParameters();
            if (params == null) {
                return false;
            }
            return "TRUE".equalsIgnoreCase(params.get("EXTERNAL"));
        }

        @Override
        public Table get_table(String dbname, String name) throws MetaException, NoSuchObjectException {
            this.incrementCounter("get_table");
            this.logStartFunction("get_table", dbname, name);
            Table t = this.getMS().getTable(dbname, name);
            if (t == null) {
                throw new NoSuchObjectException(dbname + "." + name + " table not found");
            }
            return t;
        }

        public boolean set_table_parameters(String dbname, String name, Map<String, String> params) throws NoSuchObjectException, MetaException {
            this.incrementCounter("set_table_parameters");
            this.logStartFunction("set_table_parameters", dbname, name);
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Partition append_partition(String dbName, String tableName, List<String> part_vals) throws InvalidObjectException, AlreadyExistsException, MetaException {
            this.incrementCounter("append_partition");
            this.logStartFunction("append_partition", dbName, tableName);
            if (LOG.isDebugEnabled()) {
                for (String part : part_vals) {
                    LOG.debug((Object)part);
                }
            }
            Partition part = new Partition();
            boolean success = false;
            boolean madeDir = false;
            Path partLocation = null;
            try {
                this.getMS().openTransaction();
                part = new Partition();
                part.setDbName(dbName);
                part.setTableName(tableName);
                part.setValues(part_vals);
                Table tbl = this.getMS().getTable(part.getDbName(), part.getTableName());
                if (tbl == null) {
                    throw new InvalidObjectException("Unable to add partition because table or database do not exist");
                }
                part.setSd(tbl.getSd());
                partLocation = new Path(tbl.getSd().getLocation(), Warehouse.makePartName(tbl.getPartitionKeys(), part_vals));
                part.getSd().setLocation(partLocation.toString());
                Partition old_part = this.get_partition(part.getDbName(), part.getTableName(), part.getValues());
                if (old_part != null) {
                    throw new AlreadyExistsException("Partition already exists:" + part);
                }
                if (!this.wh.isDir(partLocation)) {
                    if (!this.wh.mkdirs(partLocation)) {
                        throw new MetaException(partLocation + " is not a directory or unable to create one");
                    }
                    madeDir = true;
                }
                long time = System.currentTimeMillis() / 1000L;
                part.setCreateTime((int)time);
                part.putToParameters("transient_lastDdlTime", Long.toString(time));
                success = this.getMS().addPartition(part);
                if (success) {
                    success = this.getMS().commitTransaction();
                }
                if (success) return part;
                this.getMS().rollbackTransaction();
                if (!madeDir) return part;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                this.getMS().rollbackTransaction();
                if (!madeDir) throw throwable;
                this.wh.deleteDir(partLocation, true);
                throw throwable;
            }
            this.wh.deleteDir(partLocation, true);
            return part;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int add_partitions(List<Partition> parts) throws MetaException, InvalidObjectException, AlreadyExistsException {
            this.incrementCounter("add_partition");
            if (parts.size() == 0) {
                return 0;
            }
            String db = parts.get(0).getDbName();
            String tbl = parts.get(0).getTableName();
            this.logStartFunction("add_partitions", db, tbl);
            boolean success = false;
            try {
                this.getMS().openTransaction();
                for (Partition part : parts) {
                    this.add_partition(part);
                }
                success = true;
                this.getMS().commitTransaction();
            }
            finally {
                if (!success) {
                    this.getMS().rollbackTransaction();
                }
            }
            return parts.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Partition add_partition(Partition part) throws InvalidObjectException, AlreadyExistsException, MetaException {
            this.incrementCounter("add_partition");
            this.logStartFunction("add_partition", part.getDbName(), part.getTableName());
            boolean success = false;
            boolean madeDir = false;
            Path partLocation = null;
            try {
                this.getMS().openTransaction();
                Partition old_part = this.get_partition(part.getDbName(), part.getTableName(), part.getValues());
                if (old_part != null) {
                    throw new AlreadyExistsException("Partition already exists:" + part);
                }
                Table tbl = this.getMS().getTable(part.getDbName(), part.getTableName());
                if (tbl == null) {
                    throw new InvalidObjectException("Unable to add partition because table or database do not exist");
                }
                String partLocationStr = part.getSd().getLocation();
                partLocation = partLocationStr == null || partLocationStr.isEmpty() ? new Path(tbl.getSd().getLocation(), Warehouse.makePartName(tbl.getPartitionKeys(), part.getValues())) : this.wh.getDnsPath(new Path(partLocationStr));
                part.getSd().setLocation(partLocation.toString());
                if (!this.wh.isDir(partLocation)) {
                    if (!this.wh.mkdirs(partLocation)) {
                        throw new MetaException(partLocation + " is not a directory or unable to create one");
                    }
                    madeDir = true;
                }
                long time = System.currentTimeMillis() / 1000L;
                part.setCreateTime((int)time);
                part.putToParameters("transient_lastDdlTime", Long.toString(time));
                boolean bl = success = this.getMS().addPartition(part) && this.getMS().commitTransaction();
                if (success) return part;
                this.getMS().rollbackTransaction();
                if (!madeDir) return part;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                this.getMS().rollbackTransaction();
                if (!madeDir) throw throwable;
                this.wh.deleteDir(partLocation, true);
                throw throwable;
            }
            this.wh.deleteDir(partLocation, true);
            return part;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean drop_partition(String db_name, String tbl_name, List<String> part_vals, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
            this.incrementCounter("drop_partition");
            this.logStartFunction("drop_partition", db_name, tbl_name);
            LOG.info((Object)("Partition values:" + part_vals));
            boolean success = false;
            Path partPath = null;
            Table tbl = null;
            try {
                this.getMS().openTransaction();
                Partition part = this.get_partition(db_name, tbl_name, part_vals);
                if (part == null) {
                    throw new NoSuchObjectException("Partition doesn't exist. " + part_vals);
                }
                if (part.getSd() == null || part.getSd().getLocation() == null) {
                    throw new MetaException("Partition metadata is corrupted");
                }
                if (!this.getMS().dropPartition(db_name, tbl_name, part_vals)) {
                    throw new MetaException("Unable to drop partition");
                }
                success = this.getMS().commitTransaction();
                partPath = new Path(part.getSd().getLocation());
                tbl = this.get_table(db_name, tbl_name);
                if (!success) {
                    this.getMS().rollbackTransaction();
                    return true;
                }
                if (!deleteData || partPath == null || tbl == null || this.isExternal(tbl)) return true;
            }
            catch (Throwable throwable) {
                if (!success) {
                    this.getMS().rollbackTransaction();
                    throw throwable;
                } else {
                    if (!deleteData || partPath == null || tbl == null || this.isExternal(tbl)) throw throwable;
                    this.wh.deleteDir(partPath, true);
                }
                throw throwable;
            }
            this.wh.deleteDir(partPath, true);
            return true;
        }

        @Override
        public Partition get_partition(String db_name, String tbl_name, List<String> part_vals) throws MetaException {
            this.incrementCounter("get_partition");
            this.logStartFunction("get_partition", db_name, tbl_name);
            return this.getMS().getPartition(db_name, tbl_name, part_vals);
        }

        @Override
        public List<Partition> get_partitions(String db_name, String tbl_name, short max_parts) throws NoSuchObjectException, MetaException {
            this.incrementCounter("get_partitions");
            this.logStartFunction("get_partitions", db_name, tbl_name);
            return this.getMS().getPartitions(db_name, tbl_name, max_parts);
        }

        @Override
        public List<String> get_partition_names(String db_name, String tbl_name, short max_parts) throws MetaException {
            this.incrementCounter("get_partition_names");
            this.logStartFunction("get_partition_names", db_name, tbl_name);
            return this.getMS().listPartitionNames(db_name, tbl_name, max_parts);
        }

        @Override
        public void alter_partition(String db_name, String tbl_name, Partition new_part) throws InvalidOperationException, MetaException, TException {
            this.incrementCounter("alter_partition");
            this.logStartFunction("alter_partition", db_name, tbl_name);
            LOG.info((Object)("Partition values:" + new_part.getValues()));
            try {
                new_part.putToParameters("transient_lastDdlTime", Long.toString(System.currentTimeMillis() / 1000L));
                this.getMS().alterPartition(db_name, tbl_name, new_part);
            }
            catch (InvalidObjectException e) {
                LOG.error((Object)StringUtils.stringifyException((Throwable)e));
                throw new InvalidOperationException("alter is not possible");
            }
        }

        public boolean create_index(Index index_def) throws IndexAlreadyExistsException, MetaException {
            this.incrementCounter("create_index");
            throw new MetaException("Not yet implemented");
        }

        public String getVersion() throws TException {
            this.incrementCounter("getVersion");
            this.logStartFunction("getVersion");
            return "3.0";
        }

        @Override
        public void alter_table(String dbname, String name, Table newTable) throws InvalidOperationException, MetaException {
            this.incrementCounter("alter_table");
            this.logStartFunction("truncate_table: db=" + dbname + " tbl=" + name + " newtbl=" + newTable.getTableName());
            newTable.putToParameters("transient_lastDdlTime", Long.toString(System.currentTimeMillis() / 1000L));
            this.alterHandler.alterTable(this.getMS(), this.wh, dbname, name, newTable);
        }

        @Override
        public List<String> get_tables(String dbname, String pattern) throws MetaException {
            this.incrementCounter("get_tables");
            this.logStartFunction("get_tables: db=" + dbname + " pat=" + pattern);
            return this.getMS().getTables(dbname, pattern);
        }

        @Override
        public List<FieldSchema> get_fields(String db, String tableName) throws MetaException, UnknownTableException, UnknownDBException {
            Table tbl;
            this.incrementCounter("get_fields");
            this.logStartFunction("get_fields: db=" + db + "tbl=" + tableName);
            String[] names = tableName.split("\\.");
            String base_table_name = names[0];
            try {
                tbl = this.get_table(db, base_table_name);
            }
            catch (NoSuchObjectException e) {
                throw new UnknownTableException(e.getMessage());
            }
            boolean isNative = SerDeUtils.isNativeSerDe((String)tbl.getSd().getSerdeInfo().getSerializationLib());
            if (isNative) {
                return tbl.getSd().getCols();
            }
            try {
                Deserializer s = MetaStoreUtils.getDeserializer((Configuration)this.hiveConf, tbl);
                return MetaStoreUtils.getFieldsFromDeserializer(tableName, s);
            }
            catch (SerDeException e) {
                StringUtils.stringifyException((Throwable)e);
                throw new MetaException(e.getMessage());
            }
        }

        @Override
        public List<FieldSchema> get_schema(String db, String tableName) throws MetaException, UnknownTableException, UnknownDBException {
            Table tbl;
            this.incrementCounter("get_schema");
            this.logStartFunction("get_schema: db=" + db + "tbl=" + tableName);
            String[] names = tableName.split("\\.");
            String base_table_name = names[0];
            try {
                tbl = this.get_table(db, base_table_name);
            }
            catch (NoSuchObjectException e) {
                throw new UnknownTableException(e.getMessage());
            }
            List<FieldSchema> fieldSchemas = this.get_fields(db, base_table_name);
            if (tbl == null || fieldSchemas == null) {
                throw new UnknownTableException(tableName + " doesn't exist");
            }
            if (tbl.getPartitionKeys() != null) {
                fieldSchemas.addAll(tbl.getPartitionKeys());
            }
            return fieldSchemas;
        }

        public String getCpuProfile(int profileDurationInSec) throws TException {
            return "";
        }

        @Override
        public String get_config_value(String name, String defaultValue) throws TException, ConfigValSecurityException {
            this.incrementCounter("get_config_value");
            this.logStartFunction("get_config_value: name=" + name + " defaultValue=" + defaultValue);
            if (name == null) {
                return defaultValue;
            }
            if (!Pattern.matches("(hive|hdfs|mapred).*", name)) {
                throw new ConfigValSecurityException("For security reasons, the config key " + name + " cannot be accessed");
            }
            String toReturn = defaultValue;
            try {
                toReturn = this.hiveConf.get(name, defaultValue);
            }
            catch (RuntimeException e) {
                LOG.error((Object)(threadLocalId.get().toString() + ": " + "RuntimeException thrown in get_config_value - msg: " + e.getMessage() + " cause: " + e.getCause()));
            }
            return toReturn;
        }
    }
}

