/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jdo.JDOHelper;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.jdo.Transaction;
import javax.jdo.datastore.DataStoreCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.Type;
import org.apache.hadoop.hive.metastore.model.MDatabase;
import org.apache.hadoop.hive.metastore.model.MFieldSchema;
import org.apache.hadoop.hive.metastore.model.MOrder;
import org.apache.hadoop.hive.metastore.model.MPartition;
import org.apache.hadoop.hive.metastore.model.MSerDeInfo;
import org.apache.hadoop.hive.metastore.model.MStorageDescriptor;
import org.apache.hadoop.hive.metastore.model.MTable;
import org.apache.hadoop.hive.metastore.model.MType;
import org.apache.hadoop.util.StringUtils;

public class ObjectStore
implements RawStore,
Configurable {
    private static final String JPOX_CONFIG = "jpox.properties";
    private static Properties prop = null;
    private static PersistenceManagerFactory pmf = null;
    private static final Log LOG = LogFactory.getLog((String)ObjectStore.class.getName());
    private boolean isInitialized = false;
    private PersistenceManager pm = null;
    private Configuration hiveConf;
    private int openTrasactionCalls = 0;
    private Transaction currentTransaction = null;
    private TXN_STATUS transactionStatus = TXN_STATUS.NO_STATE;
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    public ObjectStore() {
        if (this.classLoader == null) {
            this.classLoader = ObjectStore.class.getClassLoader();
        }
    }

    public Configuration getConf() {
        return this.hiveConf;
    }

    public void setConf(Configuration conf) {
        this.hiveConf = conf;
        if (this.isInitialized) {
            return;
        }
        this.initialize();
        if (!this.isInitialized) {
            throw new RuntimeException("Unable to create persistence manager. Check dss.log for details");
        }
        LOG.info((Object)"Initialized ObjectStore");
    }

    private void initialize() {
        LOG.info((Object)"ObjectStore, initialize called");
        this.initDataSourceProps();
        this.pm = this.getPersistenceManager();
        if (this.pm != null) {
            this.isInitialized = true;
        }
    }

    private void initDataSourceProps() {
        if (prop != null) {
            return;
        }
        prop = new Properties();
        for (Map.Entry e : this.hiveConf) {
            if (!((String)e.getKey()).contains("datanucleus") && !((String)e.getKey()).contains("jdo")) continue;
            Object prevVal = prop.setProperty((String)e.getKey(), (String)e.getValue());
            if (!LOG.isDebugEnabled() || ((String)e.getKey()).equals(HiveConf.ConfVars.METASTOREPWD.varname)) continue;
            LOG.debug((Object)("Overriding " + (String)e.getKey() + " value " + prevVal + " from  jpox.properties with " + (String)e.getValue()));
        }
        if (LOG.isDebugEnabled()) {
            for (Map.Entry<Object, Object> e : prop.entrySet()) {
                if (e.getKey().equals(HiveConf.ConfVars.METASTOREPWD.varname)) continue;
                LOG.debug((Object)(e.getKey() + " = " + e.getValue()));
            }
        }
    }

    private static PersistenceManagerFactory getPMF() {
        DataStoreCache dsc;
        if (pmf == null && (dsc = (pmf = JDOHelper.getPersistenceManagerFactory((Map)prop)).getDataStoreCache()) != null) {
            dsc.pinAll(true, MTable.class);
            dsc.pinAll(true, MStorageDescriptor.class);
            dsc.pinAll(true, MSerDeInfo.class);
            dsc.pinAll(true, MPartition.class);
            dsc.pinAll(true, MDatabase.class);
            dsc.pinAll(true, MType.class);
            dsc.pinAll(true, MFieldSchema.class);
            dsc.pinAll(true, MOrder.class);
        }
        return pmf;
    }

    private PersistenceManager getPersistenceManager() {
        return ObjectStore.getPMF().getPersistenceManager();
    }

    @Override
    public void shutdown() {
        if (this.pm != null) {
            this.pm.close();
        }
    }

    @Override
    public boolean openTransaction() {
        ++this.openTrasactionCalls;
        if (this.openTrasactionCalls == 1) {
            this.currentTransaction = this.pm.currentTransaction();
            this.currentTransaction.begin();
            this.transactionStatus = TXN_STATUS.OPEN;
        } else assert (this.currentTransaction != null && this.currentTransaction.isActive());
        return this.currentTransaction.isActive();
    }

    @Override
    public boolean commitTransaction() {
        assert (this.openTrasactionCalls >= 1);
        if (!this.currentTransaction.isActive()) {
            throw new RuntimeException("Commit is called, but transaction is not active. Either there aremismatching open and close calls or rollback was called in the same trasaction");
        }
        --this.openTrasactionCalls;
        if (this.openTrasactionCalls == 0 && this.currentTransaction.isActive()) {
            this.transactionStatus = TXN_STATUS.COMMITED;
            this.currentTransaction.commit();
        }
        return true;
    }

    public boolean isActiveTransaction() {
        if (this.currentTransaction == null) {
            return false;
        }
        return this.currentTransaction.isActive();
    }

    @Override
    public void rollbackTransaction() {
        if (this.openTrasactionCalls < 1) {
            return;
        }
        this.openTrasactionCalls = 0;
        if (this.currentTransaction.isActive() && this.transactionStatus != TXN_STATUS.ROLLBACK) {
            this.transactionStatus = TXN_STATUS.ROLLBACK;
            this.currentTransaction.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createDatabase(Database db) {
        boolean success = false;
        boolean commited = false;
        MDatabase mdb = new MDatabase(db.getName().toLowerCase(), db.getDescription());
        try {
            this.openTransaction();
            this.pm.makePersistent((Object)mdb);
            success = true;
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
        return success;
    }

    @Override
    public boolean createDatabase(String name) {
        Database db = new Database(name, "default_path");
        return this.createDatabase(db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MDatabase getMDatabase(String name) throws NoSuchObjectException {
        MDatabase db = null;
        boolean commited = false;
        try {
            this.openTransaction();
            name = name.toLowerCase();
            Query query = this.pm.newQuery(MDatabase.class, "name == dbname");
            query.declareParameters("java.lang.String dbname");
            query.setUnique(true);
            db = (MDatabase)query.execute((Object)name.trim());
            this.pm.retrieve((Object)db);
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
        if (db == null) {
            throw new NoSuchObjectException("There is no database named " + name);
        }
        return db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Database getDatabase(String name) throws NoSuchObjectException {
        MDatabase db = null;
        boolean commited = false;
        try {
            this.openTransaction();
            db = this.getMDatabase(name);
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
        return new Database(db.getName(), db.getDescription());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dropDatabase(String dbname) {
        boolean success = false;
        boolean commited = false;
        try {
            this.openTransaction();
            dbname = dbname.toLowerCase();
            LOG.info((Object)("Dropping database along with all tables " + dbname));
            Query q1 = this.pm.newQuery(MTable.class, "database.name == dbName");
            q1.declareParameters("java.lang.String dbName");
            List mtbls = (List)q1.execute((Object)dbname.trim());
            this.pm.deletePersistentAll((Collection)mtbls);
            Query query = this.pm.newQuery(MDatabase.class, "name == dbName");
            query.declareParameters("java.lang.String dbName");
            query.setUnique(true);
            MDatabase db = (MDatabase)query.execute((Object)dbname.trim());
            this.pm.retrieve((Object)db);
            if (db != null) {
                this.pm.deletePersistent((Object)db);
            }
            commited = this.commitTransaction();
            success = true;
        }
        catch (JDOObjectNotFoundException e) {
            LOG.debug((Object)("database not found " + dbname), (Throwable)e);
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getDatabases() {
        List dbs = null;
        boolean commited = false;
        try {
            this.openTransaction();
            Query query = this.pm.newQuery(MDatabase.class);
            query.setResult("name");
            query.setResultClass(String.class);
            query.setOrdering("name asc");
            dbs = (List)query.execute();
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
        return dbs;
    }

    private MType getMType(Type type) {
        ArrayList<MFieldSchema> fields = new ArrayList<MFieldSchema>();
        if (type.getFields() != null) {
            for (FieldSchema field : type.getFields()) {
                fields.add(new MFieldSchema(field.getName(), field.getType(), field.getComment()));
            }
        }
        return new MType(type.getName(), type.getType1(), type.getType2(), fields);
    }

    private Type getType(MType mtype) {
        ArrayList<FieldSchema> fields = new ArrayList<FieldSchema>();
        if (mtype.getFields() != null) {
            for (MFieldSchema field : mtype.getFields()) {
                fields.add(new FieldSchema(field.getName(), field.getType(), field.getComment()));
            }
        }
        Type ret = new Type();
        ret.setName(mtype.getName());
        ret.setType1(mtype.getType1());
        ret.setType2(mtype.getType2());
        ret.setFields(fields);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createType(Type type) {
        boolean success = false;
        MType mtype = this.getMType(type);
        boolean commited = false;
        try {
            this.openTransaction();
            this.pm.makePersistent((Object)mtype);
            commited = this.commitTransaction();
            success = true;
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Type getType(String typeName) {
        Type type = null;
        boolean commited = false;
        try {
            this.openTransaction();
            Query query = this.pm.newQuery(MType.class, "name == typeName");
            query.declareParameters("java.lang.String typeName");
            query.setUnique(true);
            MType mtype = (MType)query.execute((Object)typeName.trim());
            this.pm.retrieve(type);
            if (mtype != null) {
                type = this.getType(mtype);
            }
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dropType(String typeName) {
        boolean success = false;
        boolean commited = false;
        try {
            this.openTransaction();
            Query query = this.pm.newQuery(MType.class, "name == typeName");
            query.declareParameters("java.lang.String typeName");
            query.setUnique(true);
            MType type = (MType)query.execute((Object)typeName.trim());
            this.pm.retrieve((Object)type);
            this.pm.deletePersistent((Object)type);
            commited = this.commitTransaction();
            success = true;
        }
        catch (JDOObjectNotFoundException e) {
            commited = this.commitTransaction();
            LOG.debug((Object)("type not found " + typeName), (Throwable)e);
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createTable(Table tbl) throws InvalidObjectException, MetaException {
        boolean commited = false;
        try {
            this.openTransaction();
            MTable mtbl = this.convertToMTable(tbl);
            this.pm.makePersistent((Object)mtbl);
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dropTable(String dbName, String tableName) {
        boolean success = false;
        try {
            this.openTransaction();
            MTable tbl = this.getMTable(dbName, tableName);
            this.pm.retrieve((Object)tbl);
            if (tbl != null) {
                this.pm.deletePersistentAll(this.listMPartitions(dbName, tableName, -1));
                this.pm.deletePersistent((Object)tbl);
            }
            success = this.commitTransaction();
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Table getTable(String dbName, String tableName) throws MetaException {
        boolean commited = false;
        Table tbl = null;
        try {
            this.openTransaction();
            tbl = this.convertToTable(this.getMTable(dbName, tableName));
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
        return tbl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getTables(String dbName, String pattern) throws MetaException {
        boolean commited = false;
        ArrayList<String> tbls = null;
        try {
            this.openTransaction();
            dbName = dbName.toLowerCase();
            String[] subpatterns = pattern.trim().split("\\|");
            String query = "select tableName from org.apache.hadoop.hive.metastore.model.MTable where database.name == dbName && (";
            boolean first = true;
            for (String subpattern : subpatterns) {
                subpattern = "(?i)" + subpattern.replaceAll("\\*", ".*");
                if (!first) {
                    query = query + " || ";
                }
                query = query + " tableName.matches(\"" + subpattern + "\")";
                first = false;
            }
            query = query + ")";
            Query q = this.pm.newQuery(query);
            q.declareParameters("java.lang.String dbName");
            q.setResult("tableName");
            Collection names = (Collection)q.execute((Object)dbName.trim());
            tbls = new ArrayList<String>();
            Iterator i = names.iterator();
            while (i.hasNext()) {
                tbls.add((String)i.next());
            }
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
        return tbls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MTable getMTable(String db, String table) {
        MTable mtbl = null;
        boolean commited = false;
        try {
            this.openTransaction();
            db = db.toLowerCase();
            table = table.toLowerCase();
            Query query = this.pm.newQuery(MTable.class, "tableName == table && database.name == db");
            query.declareParameters("java.lang.String table, java.lang.String db");
            query.setUnique(true);
            mtbl = (MTable)query.execute((Object)table.trim(), (Object)db.trim());
            this.pm.retrieve((Object)mtbl);
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
        return mtbl;
    }

    private Table convertToTable(MTable mtbl) throws MetaException {
        if (mtbl == null) {
            return null;
        }
        return new Table(mtbl.getTableName(), mtbl.getDatabase().getName(), mtbl.getOwner(), mtbl.getCreateTime(), mtbl.getLastAccessTime(), mtbl.getRetention(), this.convertToStorageDescriptor(mtbl.getSd()), this.convertToFieldSchemas(mtbl.getPartitionKeys()), mtbl.getParameters());
    }

    private MTable convertToMTable(Table tbl) throws InvalidObjectException, MetaException {
        if (tbl == null) {
            return null;
        }
        MDatabase mdb = null;
        try {
            mdb = this.getMDatabase(tbl.getDbName());
        }
        catch (NoSuchObjectException e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            throw new InvalidObjectException("Database " + tbl.getDbName() + " doesn't exsit.");
        }
        return new MTable(tbl.getTableName().toLowerCase(), mdb, this.convertToMStorageDescriptor(tbl.getSd()), tbl.getOwner(), tbl.getCreateTime(), tbl.getLastAccessTime(), tbl.getRetention(), this.convertToMFieldSchemas(tbl.getPartitionKeys()), tbl.getParameters());
    }

    private List<MFieldSchema> convertToMFieldSchemas(List<FieldSchema> keys) {
        ArrayList<MFieldSchema> mkeys = null;
        if (keys != null) {
            mkeys = new ArrayList<MFieldSchema>(keys.size());
            for (FieldSchema part : keys) {
                mkeys.add(new MFieldSchema(part.getName().toLowerCase(), part.getType(), part.getComment()));
            }
        }
        return mkeys;
    }

    private List<FieldSchema> convertToFieldSchemas(List<MFieldSchema> mkeys) {
        ArrayList<FieldSchema> keys = null;
        if (mkeys != null) {
            keys = new ArrayList<FieldSchema>(mkeys.size());
            for (MFieldSchema part : mkeys) {
                keys.add(new FieldSchema(part.getName(), part.getType(), part.getComment()));
            }
        }
        return keys;
    }

    private List<MOrder> convertToMOrders(List<Order> keys) {
        ArrayList<MOrder> mkeys = null;
        if (keys != null) {
            mkeys = new ArrayList<MOrder>(keys.size());
            for (Order part : keys) {
                mkeys.add(new MOrder(part.getCol().toLowerCase(), part.getOrder()));
            }
        }
        return mkeys;
    }

    private List<Order> convertToOrders(List<MOrder> mkeys) {
        ArrayList<Order> keys = null;
        if (mkeys != null) {
            keys = new ArrayList<Order>();
            for (MOrder part : mkeys) {
                keys.add(new Order(part.getCol(), part.getOrder()));
            }
        }
        return keys;
    }

    private SerDeInfo converToSerDeInfo(MSerDeInfo ms) throws MetaException {
        if (ms == null) {
            throw new MetaException("Invalid SerDeInfo object");
        }
        return new SerDeInfo(ms.getName(), ms.getSerializationLib(), ms.getParameters());
    }

    private MSerDeInfo converToMSerDeInfo(SerDeInfo ms) throws MetaException {
        if (ms == null) {
            throw new MetaException("Invalid SerDeInfo object");
        }
        return new MSerDeInfo(ms.getName(), ms.getSerializationLib(), ms.getParameters());
    }

    private StorageDescriptor convertToStorageDescriptor(MStorageDescriptor msd) throws MetaException {
        if (msd == null) {
            return null;
        }
        return new StorageDescriptor(this.convertToFieldSchemas(msd.getCols()), msd.getLocation(), msd.getInputFormat(), msd.getOutputFormat(), msd.isCompressed(), msd.getNumBuckets(), this.converToSerDeInfo(msd.getSerDeInfo()), msd.getBucketCols(), this.convertToOrders(msd.getSortCols()), msd.getParameters());
    }

    private MStorageDescriptor convertToMStorageDescriptor(StorageDescriptor sd) throws MetaException {
        if (sd == null) {
            return null;
        }
        return new MStorageDescriptor(this.convertToMFieldSchemas(sd.getCols()), sd.getLocation(), sd.getInputFormat(), sd.getOutputFormat(), sd.isCompressed(), sd.getNumBuckets(), this.converToMSerDeInfo(sd.getSerdeInfo()), sd.getBucketCols(), this.convertToMOrders(sd.getSortCols()), sd.getParameters());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addPartition(Partition part) throws InvalidObjectException, MetaException {
        boolean success = false;
        boolean commited = false;
        try {
            this.openTransaction();
            MPartition mpart = this.convertToMPart(part);
            this.pm.makePersistent((Object)mpart);
            commited = this.commitTransaction();
            success = true;
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
        return success;
    }

    @Override
    public Partition getPartition(String dbName, String tableName, List<String> part_vals) throws MetaException {
        this.openTransaction();
        Partition part = this.convertToPart(this.getMPartition(dbName, tableName, part_vals));
        this.commitTransaction();
        return part;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MPartition getMPartition(String dbName, String tableName, List<String> part_vals) throws MetaException {
        MPartition mpart = null;
        boolean commited = false;
        try {
            this.openTransaction();
            dbName = dbName.toLowerCase();
            tableName = tableName.toLowerCase();
            MTable mtbl = this.getMTable(dbName, tableName);
            if (mtbl == null) {
                commited = this.commitTransaction();
                MPartition mPartition = null;
                return mPartition;
            }
            String name = Warehouse.makePartName(this.convertToFieldSchemas(mtbl.getPartitionKeys()), part_vals);
            Query query = this.pm.newQuery(MPartition.class, "table.tableName == t1 && table.database.name == t2 && partitionName == t3");
            query.declareParameters("java.lang.String t1, java.lang.String t2, java.lang.String t3");
            query.setUnique(true);
            mpart = (MPartition)query.execute((Object)tableName.trim(), (Object)dbName.trim(), (Object)name);
            this.pm.retrieve((Object)mpart);
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
        return mpart;
    }

    private MPartition convertToMPart(Partition part) throws InvalidObjectException, MetaException {
        if (part == null) {
            return null;
        }
        MTable mt = this.getMTable(part.getDbName(), part.getTableName());
        if (mt == null) {
            throw new InvalidObjectException("Partition doesn't have a valid table or database name");
        }
        return new MPartition(Warehouse.makePartName(this.convertToFieldSchemas(mt.getPartitionKeys()), part.getValues()), mt, part.getValues(), part.getCreateTime(), part.getLastAccessTime(), this.convertToMStorageDescriptor(part.getSd()), part.getParameters());
    }

    private Partition convertToPart(MPartition mpart) throws MetaException {
        if (mpart == null) {
            return null;
        }
        return new Partition(mpart.getValues(), mpart.getTable().getDatabase().getName(), mpart.getTable().getTableName(), mpart.getCreateTime(), mpart.getLastAccessTime(), this.convertToStorageDescriptor(mpart.getSd()), mpart.getParameters());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dropPartition(String dbName, String tableName, List<String> part_vals) throws MetaException {
        boolean success = false;
        try {
            this.openTransaction();
            MPartition part = this.getMPartition(dbName, tableName, part_vals);
            if (part != null) {
                this.pm.deletePersistent((Object)part);
            }
            success = this.commitTransaction();
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
        return success;
    }

    @Override
    public List<Partition> getPartitions(String dbName, String tableName, int max) throws MetaException {
        this.openTransaction();
        List<Partition> parts = this.convertToParts(this.listMPartitions(dbName, tableName, max));
        this.commitTransaction();
        return parts;
    }

    private List<Partition> convertToParts(List<MPartition> mparts) throws MetaException {
        ArrayList<Partition> parts = new ArrayList<Partition>(mparts.size());
        for (MPartition mp : mparts) {
            parts.add(this.convertToPart(mp));
        }
        return parts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listPartitionNames(String dbName, String tableName, short max) throws MetaException {
        ArrayList<String> pns = new ArrayList<String>();
        boolean success = false;
        try {
            this.openTransaction();
            LOG.debug((Object)"Executing getPartitionNames");
            dbName = dbName.toLowerCase();
            tableName = tableName.toLowerCase();
            Query q = this.pm.newQuery("select partitionName from org.apache.hadoop.hive.metastore.model.MPartition where table.database.name == t1 && table.tableName == t2 order by partitionName asc");
            q.declareParameters("java.lang.String t1, java.lang.String t2");
            q.setResult("partitionName");
            Collection names = (Collection)q.execute((Object)dbName.trim(), (Object)tableName.trim());
            pns = new ArrayList();
            Iterator i = names.iterator();
            while (i.hasNext()) {
                pns.add((String)i.next());
            }
            success = this.commitTransaction();
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
        return pns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MPartition> listMPartitions(String dbName, String tableName, int max) {
        boolean success = false;
        List mparts = null;
        try {
            this.openTransaction();
            LOG.debug((Object)"Executing listMPartitions");
            dbName = dbName.toLowerCase();
            tableName = tableName.toLowerCase();
            Query query = this.pm.newQuery(MPartition.class, "table.tableName == t1 && table.database.name == t2");
            query.declareParameters("java.lang.String t1, java.lang.String t2");
            mparts = (List)query.execute((Object)tableName.trim(), (Object)dbName.trim());
            LOG.debug((Object)"Done executing query for listMPartitions");
            this.pm.retrieveAll((Collection)mparts);
            success = this.commitTransaction();
            LOG.debug((Object)"Done retrieving all objects for listMPartitions");
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
        return mparts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alterTable(String dbname, String name, Table newTable) throws InvalidObjectException, MetaException {
        boolean success = false;
        try {
            this.openTransaction();
            name = name.toLowerCase();
            dbname = dbname.toLowerCase();
            MTable newt = this.convertToMTable(newTable);
            if (newt == null) {
                throw new InvalidObjectException("new table is invalid");
            }
            MTable oldt = this.getMTable(dbname, name);
            if (oldt == null) {
                throw new MetaException("table " + name + " doesn't exist");
            }
            oldt.setTableName(newt.getTableName().toLowerCase());
            oldt.setParameters(newt.getParameters());
            oldt.setOwner(newt.getOwner());
            oldt.setSd(newt.getSd());
            oldt.setDatabase(newt.getDatabase());
            oldt.setRetention(newt.getRetention());
            oldt.setPartitionKeys(newt.getPartitionKeys());
            success = this.commitTransaction();
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alterPartition(String dbname, String name, Partition newPart) throws InvalidObjectException, MetaException {
        boolean success = false;
        try {
            this.openTransaction();
            name = name.toLowerCase();
            dbname = dbname.toLowerCase();
            MPartition oldp = this.getMPartition(dbname, name, newPart.getValues());
            MPartition newp = this.convertToMPart(newPart);
            if (oldp == null || newp == null) {
                throw new InvalidObjectException("partition does not exist.");
            }
            oldp.setParameters(newPart.getParameters());
            this.copyMSD(newp.getSd(), oldp.getSd());
            if (newp.getCreateTime() != oldp.getCreateTime()) {
                oldp.setCreateTime(newp.getCreateTime());
            }
            if (newp.getLastAccessTime() != oldp.getLastAccessTime()) {
                oldp.setLastAccessTime(newp.getLastAccessTime());
            }
            success = this.commitTransaction();
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
    }

    private void copyMSD(MStorageDescriptor newSd, MStorageDescriptor oldSd) {
        oldSd.setLocation(newSd.getLocation());
        oldSd.setCols(newSd.getCols());
        oldSd.setBucketCols(newSd.getBucketCols());
        oldSd.setCompressed(newSd.isCompressed());
        oldSd.setInputFormat(newSd.getInputFormat());
        oldSd.setOutputFormat(newSd.getOutputFormat());
        oldSd.setNumBuckets(newSd.getNumBuckets());
        oldSd.getSerDeInfo().setName(newSd.getSerDeInfo().getName());
        oldSd.getSerDeInfo().setSerializationLib(newSd.getSerDeInfo().getSerializationLib());
        oldSd.getSerDeInfo().setParameters(newSd.getSerDeInfo().getParameters());
    }

    private static enum TXN_STATUS {
        NO_STATE,
        OPEN,
        COMMITED,
        ROLLBACK;

    }
}

