/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazybinary;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryFactory;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryStruct;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class LazyBinarySerDe
implements SerDe {
    public static final Log LOG = LogFactory.getLog((String)LazyBinarySerDe.class.getName());
    List<String> columnNames;
    List<TypeInfo> columnTypes;
    TypeInfo rowTypeInfo;
    ObjectInspector cachedObjectInspector;
    LazyBinaryStruct cachedLazyBinaryStruct;
    ByteArrayRef byteArrayRef;
    BytesWritable serializeBytesWritable = new BytesWritable();
    ByteStream.Output serializeByteStream = new ByteStream.Output();
    boolean nullMapKey = false;

    @Override
    public void initialize(Configuration conf, Properties tbl) throws SerDeException {
        String columnNameProperty = tbl.getProperty("columns");
        String columnTypeProperty = tbl.getProperty("columns.types");
        this.columnNames = columnNameProperty.length() == 0 ? new ArrayList<String>() : Arrays.asList(columnNameProperty.split(","));
        this.columnTypes = columnTypeProperty.length() == 0 ? new ArrayList<TypeInfo>() : TypeInfoUtils.getTypeInfosFromTypeString(columnTypeProperty);
        assert (this.columnNames.size() == this.columnTypes.size());
        this.rowTypeInfo = TypeInfoFactory.getStructTypeInfo(this.columnNames, this.columnTypes);
        this.cachedObjectInspector = LazyBinaryUtils.getLazyBinaryObjectInspectorFromTypeInfo(this.rowTypeInfo);
        this.cachedLazyBinaryStruct = (LazyBinaryStruct)LazyBinaryFactory.createLazyBinaryObject(this.cachedObjectInspector);
        LOG.debug((Object)("LazyBinarySerDe initialized with: columnNames=" + this.columnNames + " columnTypes=" + this.columnTypes));
    }

    @Override
    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.cachedObjectInspector;
    }

    @Override
    public Class<? extends Writable> getSerializedClass() {
        return BytesWritable.class;
    }

    @Override
    public Object deserialize(Writable field) throws SerDeException {
        if (this.byteArrayRef == null) {
            this.byteArrayRef = new ByteArrayRef();
        }
        if (field instanceof BytesWritable) {
            BytesWritable b = (BytesWritable)field;
            if (b.getSize() == 0) {
                return null;
            }
            this.byteArrayRef.setData(b.get());
            this.cachedLazyBinaryStruct.init(this.byteArrayRef, 0, b.getSize());
        } else if (field instanceof Text) {
            Text t = (Text)field;
            if (t.getLength() == 0) {
                return null;
            }
            this.byteArrayRef.setData(t.getBytes());
            this.cachedLazyBinaryStruct.init(this.byteArrayRef, 0, t.getLength());
        } else {
            throw new SerDeException(this.getClass().toString() + ": expects either BytesWritable or Text object!");
        }
        return this.cachedLazyBinaryStruct;
    }

    @Override
    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        if (objInspector.getCategory() != ObjectInspector.Category.STRUCT) {
            throw new SerDeException(this.getClass().toString() + " can only serialize struct types, but we got: " + objInspector.getTypeName());
        }
        this.serializeByteStream.reset();
        this.serializeStruct(this.serializeByteStream, obj, (StructObjectInspector)objInspector);
        this.serializeBytesWritable.set(this.serializeByteStream.getData(), 0, this.serializeByteStream.getCount());
        return this.serializeBytesWritable;
    }

    private void serializeStruct(ByteStream.Output byteStream, Object obj, StructObjectInspector soi) {
        if (null == obj) {
            return;
        }
        List<? extends StructField> fields = soi.getAllStructFieldRefs();
        int size = fields.size();
        int lasti = 0;
        int nullByte = 0;
        for (int i = 0; i < size; ++i) {
            if (null != soi.getStructFieldData(obj, fields.get(i))) {
                nullByte = (byte)(nullByte | 1 << i % 8);
            }
            if (7 != i % 8 && i != size - 1) continue;
            this.serializeByteStream.write(nullByte);
            for (int j = lasti; j <= i; ++j) {
                this.serialize(this.serializeByteStream, soi.getStructFieldData(obj, fields.get(j)), fields.get(j).getFieldObjectInspector());
            }
            lasti = i + 1;
            nullByte = 0;
        }
    }

    private void serialize(ByteStream.Output byteStream, Object obj, ObjectInspector objInspector) {
        if (null == obj) {
            return;
        }
        switch (objInspector.getCategory()) {
            case PRIMITIVE: {
                PrimitiveObjectInspector poi = (PrimitiveObjectInspector)objInspector;
                switch (poi.getPrimitiveCategory()) {
                    case VOID: {
                        return;
                    }
                    case BOOLEAN: {
                        BooleanObjectInspector boi = (BooleanObjectInspector)poi;
                        boolean v = ((BooleanObjectInspector)poi).get(obj);
                        byteStream.write((byte)(v ? 1 : 0));
                        return;
                    }
                    case BYTE: {
                        ByteObjectInspector boi = (ByteObjectInspector)poi;
                        byte v = boi.get(obj);
                        byteStream.write(v);
                        return;
                    }
                    case SHORT: {
                        ShortObjectInspector spoi = (ShortObjectInspector)poi;
                        short v = spoi.get(obj);
                        byteStream.write((byte)(v >> 8));
                        byteStream.write((byte)v);
                        return;
                    }
                    case INT: {
                        IntObjectInspector ioi = (IntObjectInspector)poi;
                        int v = ioi.get(obj);
                        LazyBinaryUtils.writeVInt(byteStream, v);
                        return;
                    }
                    case LONG: {
                        LongObjectInspector loi = (LongObjectInspector)poi;
                        long v = loi.get(obj);
                        LazyBinaryUtils.writeVLong(byteStream, v);
                        return;
                    }
                    case FLOAT: {
                        FloatObjectInspector foi = (FloatObjectInspector)poi;
                        int v = Float.floatToIntBits(foi.get(obj));
                        byteStream.write((byte)(v >> 24));
                        byteStream.write((byte)(v >> 16));
                        byteStream.write((byte)(v >> 8));
                        byteStream.write((byte)v);
                        return;
                    }
                    case DOUBLE: {
                        DoubleObjectInspector doi = (DoubleObjectInspector)poi;
                        long v = Double.doubleToLongBits(doi.get(obj));
                        byteStream.write((byte)(v >> 56));
                        byteStream.write((byte)(v >> 48));
                        byteStream.write((byte)(v >> 40));
                        byteStream.write((byte)(v >> 32));
                        byteStream.write((byte)(v >> 24));
                        byteStream.write((byte)(v >> 16));
                        byteStream.write((byte)(v >> 8));
                        byteStream.write((byte)v);
                        return;
                    }
                    case STRING: {
                        StringObjectInspector soi = (StringObjectInspector)poi;
                        Text t = soi.getPrimitiveWritableObject(obj);
                        int length = t.getLength();
                        LazyBinaryUtils.writeVInt(byteStream, length);
                        byte[] data = t.getBytes();
                        byteStream.write(data, 0, length);
                        return;
                    }
                }
                throw new RuntimeException("Unrecognized type: " + (Object)((Object)poi.getPrimitiveCategory()));
            }
            case LIST: {
                int eid;
                ListObjectInspector loi = (ListObjectInspector)objInspector;
                ObjectInspector eoi = loi.getListElementObjectInspector();
                int byteSizeStart = byteStream.getCount();
                byteStream.write(0);
                byteStream.write(0);
                byteStream.write(0);
                byteStream.write(0);
                int listStart = byteStream.getCount();
                int size = loi.getListLength(obj);
                LazyBinaryUtils.writeVInt(byteStream, size);
                int nullByte = 0;
                for (eid = 0; eid < size; ++eid) {
                    if (null != loi.getListElement(obj, eid)) {
                        nullByte = (byte)(nullByte | 1 << eid % 8);
                    }
                    if (7 != eid % 8 && eid != size - 1) continue;
                    byteStream.write(nullByte);
                    nullByte = 0;
                }
                for (eid = 0; eid < size; ++eid) {
                    this.serialize(byteStream, loi.getListElement(obj, eid), eoi);
                }
                int listEnd = byteStream.getCount();
                int listSize = listEnd - listStart;
                byte[] bytes = byteStream.getData();
                bytes[byteSizeStart] = (byte)(listSize >> 24);
                bytes[byteSizeStart + 1] = (byte)(listSize >> 16);
                bytes[byteSizeStart + 2] = (byte)(listSize >> 8);
                bytes[byteSizeStart + 3] = (byte)listSize;
                return;
            }
            case MAP: {
                MapObjectInspector moi = (MapObjectInspector)objInspector;
                ObjectInspector koi = moi.getMapKeyObjectInspector();
                ObjectInspector voi = moi.getMapValueObjectInspector();
                Map<?, ?> map = moi.getMap(obj);
                int byteSizeStart = byteStream.getCount();
                byteStream.write(0);
                byteStream.write(0);
                byteStream.write(0);
                byteStream.write(0);
                int mapStart = byteStream.getCount();
                int size = map.size();
                LazyBinaryUtils.writeVInt(byteStream, size);
                int b = 0;
                int nullByte = 0;
                for (Map.Entry<?, ?> entry : map.entrySet()) {
                    if (null != entry.getKey()) {
                        nullByte = (byte)(nullByte | 1 << b % 8);
                    } else if (!this.nullMapKey) {
                        this.nullMapKey = true;
                        LOG.warn((Object)"Null map key encountered! Ignoring similar problems.");
                    }
                    ++b;
                    if (null != entry.getValue()) {
                        nullByte = (byte)(nullByte | 1 << b % 8);
                    }
                    if (0 != ++b % 8 && b != size * 2) continue;
                    byteStream.write(nullByte);
                    nullByte = 0;
                }
                for (Map.Entry<?, ?> entry : map.entrySet()) {
                    this.serialize(byteStream, entry.getKey(), koi);
                    this.serialize(byteStream, entry.getValue(), voi);
                }
                int mapEnd = byteStream.getCount();
                int mapSize = mapEnd - mapStart;
                byte[] bytes = byteStream.getData();
                bytes[byteSizeStart] = (byte)(mapSize >> 24);
                bytes[byteSizeStart + 1] = (byte)(mapSize >> 16);
                bytes[byteSizeStart + 2] = (byte)(mapSize >> 8);
                bytes[byteSizeStart + 3] = (byte)mapSize;
                return;
            }
            case STRUCT: {
                int byteSizeStart = byteStream.getCount();
                byteStream.write(0);
                byteStream.write(0);
                byteStream.write(0);
                byteStream.write(0);
                int structStart = byteStream.getCount();
                this.serializeStruct(byteStream, obj, (StructObjectInspector)objInspector);
                int structEnd = byteStream.getCount();
                int structSize = structEnd - structStart;
                byte[] bytes = byteStream.getData();
                bytes[byteSizeStart] = (byte)(structSize >> 24);
                bytes[byteSizeStart + 1] = (byte)(structSize >> 16);
                bytes[byteSizeStart + 2] = (byte)(structSize >> 8);
                bytes[byteSizeStart + 3] = (byte)structSize;
                return;
            }
        }
        throw new RuntimeException("Unrecognized type: " + (Object)((Object)objInspector.getCategory()));
    }
}

