/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.contrib.fileformat.base64;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.LineRecordReader;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;

public class Base64TextInputFormat
implements InputFormat<LongWritable, BytesWritable>,
JobConfigurable {
    TextInputFormat format = new TextInputFormat();
    JobConf job;

    public void configure(JobConf job) {
        this.job = job;
        this.format.configure(job);
    }

    public RecordReader<LongWritable, BytesWritable> getRecordReader(InputSplit genericSplit, JobConf job, Reporter reporter) throws IOException {
        reporter.setStatus(genericSplit.toString());
        Base64LineRecordReader reader = new Base64LineRecordReader(new LineRecordReader((Configuration)job, (FileSplit)genericSplit));
        reader.configure(job);
        return reader;
    }

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        return this.format.getSplits(job, numSplits);
    }

    public void validateInput(JobConf job) throws IOException {
        ShimLoader.getHadoopShims().inputFormatValidateInput((InputFormat)this.format, job);
    }

    static Base64 createBase64() {
        try {
            Constructor ctor = Base64.class.getConstructor(Integer.TYPE, byte[].class);
            return (Base64)ctor.newInstance(0, null);
        }
        catch (NoSuchMethodException e) {
            return new Base64();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public static class Base64LineRecordReader
    implements RecordReader<LongWritable, BytesWritable>,
    JobConfigurable {
        LineRecordReader reader;
        Text text;
        private byte[] signature;
        private Base64 base64 = Base64TextInputFormat.createBase64();

        public Base64LineRecordReader(LineRecordReader reader) {
            this.reader = reader;
            this.text = reader.createValue();
        }

        public void close() throws IOException {
            this.reader.close();
        }

        public LongWritable createKey() {
            return this.reader.createKey();
        }

        public BytesWritable createValue() {
            return new BytesWritable();
        }

        public long getPos() throws IOException {
            return this.reader.getPos();
        }

        public float getProgress() throws IOException {
            return this.reader.getProgress();
        }

        public boolean next(LongWritable key, BytesWritable value) throws IOException {
            while (this.reader.next(key, this.text)) {
                int i;
                byte[] textBytes = this.text.getBytes();
                int length = this.text.getLength();
                if (length != textBytes.length) {
                    textBytes = Arrays.copyOf(textBytes, length);
                }
                byte[] binaryData = this.base64.decode(textBytes);
                for (i = 0; i < binaryData.length && i < this.signature.length && binaryData[i] == this.signature[i]; ++i) {
                }
                if (i != this.signature.length) continue;
                value.set(binaryData, this.signature.length, binaryData.length - this.signature.length);
                return true;
            }
            return false;
        }

        public void configure(JobConf job) {
            try {
                String signatureString = job.get("base64.text.input.format.signature");
                this.signature = signatureString != null ? signatureString.getBytes("UTF-8") : new byte[0];
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }
}

