/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.contrib.fileformat.base64;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.contrib.fileformat.base64.Base64TextInputFormat;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.util.Progressable;

public class Base64TextOutputFormat<K extends WritableComparable, V extends Writable>
extends HiveIgnoreKeyTextOutputFormat<K, V> {
    public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf jc, Path finalOutPath, Class<? extends Writable> valueClass, boolean isCompressed, Properties tableProperties, Progressable progress) throws IOException {
        Base64RecordWriter writer = new Base64RecordWriter(super.getHiveRecordWriter(jc, finalOutPath, BytesWritable.class, isCompressed, tableProperties, progress));
        writer.configure(jc);
        return writer;
    }

    public static class Base64RecordWriter
    implements FileSinkOperator.RecordWriter,
    JobConfigurable {
        FileSinkOperator.RecordWriter writer;
        BytesWritable bytesWritable;
        private byte[] signature;
        private Base64 base64 = Base64TextInputFormat.createBase64();

        public Base64RecordWriter(FileSinkOperator.RecordWriter writer) {
            this.writer = writer;
            this.bytesWritable = new BytesWritable();
        }

        public void write(Writable w) throws IOException {
            int i;
            int inputLength;
            byte[] input;
            if (w instanceof Text) {
                input = ((Text)w).getBytes();
                inputLength = ((Text)w).getLength();
            } else {
                assert (w instanceof BytesWritable);
                input = ((BytesWritable)w).get();
                inputLength = ((BytesWritable)w).getSize();
            }
            byte[] wrapped = new byte[this.signature.length + inputLength];
            for (i = 0; i < this.signature.length; ++i) {
                wrapped[i] = this.signature[i];
            }
            for (i = 0; i < inputLength; ++i) {
                wrapped[i + this.signature.length] = input[i];
            }
            byte[] output = this.base64.encode(wrapped);
            this.bytesWritable.set(output, 0, output.length);
            this.writer.write((Writable)this.bytesWritable);
        }

        public void close(boolean abort) throws IOException {
            this.writer.close(abort);
        }

        public void configure(JobConf job) {
            try {
                String signatureString = job.get("base64.text.output.format.signature");
                this.signature = signatureString != null ? signatureString.getBytes("UTF-8") : new byte[0];
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }
}

