/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.LineRecordReader;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.pig.LoadFunc;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DefaultTupleFactory;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

public abstract class RegExLoader
extends LoadFunc {
    private LineRecordReader in = null;

    public abstract Pattern getPattern();

    public Tuple getNext() throws IOException {
        Pattern pattern = this.getPattern();
        Matcher matcher = pattern.matcher("");
        TupleFactory mTupleFactory = DefaultTupleFactory.getInstance();
        while (this.in.nextKeyValue()) {
            Text val = this.in.getCurrentValue();
            String line = val.toString();
            if (line.length() > 0 && line.charAt(line.length() - 1) == '\r') {
                line = line.substring(0, line.length() - 1);
            }
            matcher = matcher.reset(line);
            ArrayList<DataByteArray> list = new ArrayList<DataByteArray>();
            if (!matcher.find()) continue;
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                list.add(new DataByteArray(matcher.group(i)));
            }
            return mTupleFactory.newTuple(list);
        }
        return null;
    }

    public InputFormat getInputFormat() throws IOException {
        return new TextInputFormat();
    }

    public void prepareToRead(RecordReader reader, PigSplit split) throws IOException {
        this.in = (LineRecordReader)reader;
    }

    public void setLocation(String location, Job job) throws IOException {
        FileInputFormat.setInputPaths((Job)job, (String)location);
    }
}

