/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.shims;

import java.io.IOException;
import java.lang.reflect.Constructor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapred.lib.CombineFileInputFormat;
import org.apache.hadoop.mapred.lib.CombineFileSplit;

public class Hadoop20Shims
implements HadoopShims {
    String[] ret = new String[2];

    @Override
    public boolean usesJobShell() {
        return false;
    }

    @Override
    public boolean fileSystemDeleteOnExit(FileSystem fs, Path path) throws IOException {
        return fs.deleteOnExit(path);
    }

    @Override
    public void inputFormatValidateInput(InputFormat fmt, JobConf conf) throws IOException {
    }

    @Override
    public void setTmpFiles(String prop, String files) {
    }

    @Override
    public HadoopShims.MiniDFSShim getMiniDfs(Configuration conf, int numDataNodes, boolean format, String[] racks) throws IOException {
        return new MiniDFSShim(new MiniDFSCluster(conf, numDataNodes, format, racks));
    }

    @Override
    public int compareText(Text a, Text b) {
        return a.compareTo((BinaryComparable)b);
    }

    @Override
    public long getAccessTime(FileStatus file) {
        return file.getAccessTime();
    }

    @Override
    public HadoopShims.CombineFileInputFormatShim getCombineFileInputFormat() {
        return new CombineFileInputFormatShim(){

            public RecordReader getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
                throw new IOException("CombineFileInputFormat.getRecordReader not needed.");
            }
        };
    }

    @Override
    public String getInputFormatClassName() {
        return "org.apache.hadoop.hive.ql.io.CombineHiveInputFormat";
    }

    @Override
    public String[] getTaskJobIDs(TaskCompletionEvent t) {
        TaskID tid = t.getTaskAttemptId().getTaskID();
        this.ret[0] = tid.toString();
        this.ret[1] = tid.getJobID().toString();
        return this.ret;
    }

    public static abstract class CombineFileInputFormatShim<K, V>
    extends CombineFileInputFormat<K, V>
    implements HadoopShims.CombineFileInputFormatShim<K, V> {
        @Override
        public Path[] getInputPathsShim(JobConf conf) {
            Path[] paths;
            try {
                paths = CombineFileInputFormat.getInputPaths((JobConf)conf);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Path[] newPaths = new Path[paths.length];
            for (int pos = 0; pos < paths.length; ++pos) {
                newPaths[pos] = new Path(paths[pos].toUri().getPath());
            }
            return newPaths;
        }

        @Override
        public void createPool(JobConf conf, PathFilter ... filters) {
            super.createPool(conf, filters);
        }

        public InputSplitShim[] getSplits(JobConf job, int numSplits) throws IOException {
            long minSize = job.getLong("mapred.min.split.size", 0L);
            if (job.getLong("mapred.min.split.size.per.node", 0L) == 0L) {
                super.setMinSplitSizeNode(minSize);
            }
            if (job.getLong("mapred.min.split.size.per.rack", 0L) == 0L) {
                super.setMinSplitSizeRack(minSize);
            }
            if (job.getLong("mapred.max.split.size", 0L) == 0L) {
                super.setMaxSplitSize(minSize);
            }
            CombineFileSplit[] splits = (CombineFileSplit[])super.getSplits(job, numSplits);
            InputSplitShim[] isplits = new InputSplitShim[splits.length];
            for (int pos = 0; pos < splits.length; ++pos) {
                isplits[pos] = new InputSplitShim(splits[pos]);
            }
            return isplits;
        }

        @Override
        public InputSplitShim getInputSplitShim() throws IOException {
            return new InputSplitShim();
        }

        @Override
        public RecordReader getRecordReader(JobConf job, HadoopShims.InputSplitShim split, Reporter reporter, Class<RecordReader<K, V>> rrClass) throws IOException {
            CombineFileSplit cfSplit = (CombineFileSplit)split;
            return new CombineFileRecordReader<K, V>(job, cfSplit, reporter, rrClass);
        }
    }

    public static class CombineFileRecordReader<K, V>
    implements RecordReader<K, V> {
        static final Class[] constructorSignature = new Class[]{InputSplit.class, Configuration.class, Reporter.class, Integer.class};
        protected CombineFileSplit split;
        protected JobConf jc;
        protected Reporter reporter;
        protected Class<RecordReader<K, V>> rrClass;
        protected Constructor<RecordReader<K, V>> rrConstructor;
        protected FileSystem fs;
        protected int idx;
        protected long progress;
        protected RecordReader<K, V> curReader;

        public boolean next(K key, V value) throws IOException {
            while (this.curReader == null || !this.curReader.next(key, value)) {
                if (this.initNextRecordReader()) continue;
                return false;
            }
            return true;
        }

        public K createKey() {
            return (K)this.curReader.createKey();
        }

        public V createValue() {
            return (V)this.curReader.createValue();
        }

        public long getPos() throws IOException {
            return this.progress;
        }

        public void close() throws IOException {
            if (this.curReader != null) {
                this.curReader.close();
                this.curReader = null;
            }
        }

        public float getProgress() throws IOException {
            return Math.min(1.0f, (float)this.progress / (float)this.split.getLength());
        }

        public CombineFileRecordReader(JobConf job, CombineFileSplit split, Reporter reporter, Class<RecordReader<K, V>> rrClass) throws IOException {
            this.split = split;
            this.jc = job;
            this.rrClass = rrClass;
            this.reporter = reporter;
            this.idx = 0;
            this.curReader = null;
            this.progress = 0L;
            try {
                this.rrConstructor = rrClass.getDeclaredConstructor(constructorSignature);
                this.rrConstructor.setAccessible(true);
            }
            catch (Exception e) {
                throw new RuntimeException(rrClass.getName() + " does not have valid constructor", e);
            }
            this.initNextRecordReader();
        }

        protected boolean initNextRecordReader() throws IOException {
            if (this.curReader != null) {
                this.curReader.close();
                this.curReader = null;
                if (this.idx > 0) {
                    this.progress += this.split.getLength(this.idx - 1);
                }
            }
            if (this.idx == this.split.getNumPaths()) {
                return false;
            }
            try {
                this.curReader = this.rrConstructor.newInstance(this.split, this.jc, this.reporter, this.idx);
                this.jc.set("map.input.file", this.split.getPath(this.idx).toString());
                this.jc.setLong("map.input.start", this.split.getOffset(this.idx));
                this.jc.setLong("map.input.length", this.split.getLength(this.idx));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ++this.idx;
            return true;
        }
    }

    public static class InputSplitShim
    extends CombineFileSplit
    implements HadoopShims.InputSplitShim {
        public InputSplitShim() {
        }

        public InputSplitShim(CombineFileSplit old) throws IOException {
            super(old);
        }
    }

    public class MiniDFSShim
    implements HadoopShims.MiniDFSShim {
        private MiniDFSCluster cluster;

        public MiniDFSShim(MiniDFSCluster cluster) {
            this.cluster = cluster;
        }

        @Override
        public FileSystem getFileSystem() throws IOException {
            return this.cluster.getFileSystem();
        }

        @Override
        public void shutdown() {
            this.cluster.shutdown();
        }
    }
}

