/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples;

import java.io.IOException;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class PiEstimator
extends Configured
implements Tool {
    private static final Path TMP_DIR = new Path(PiEstimator.class.getSimpleName() + "_TMP_3_141592654");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BigDecimal estimate(int numMaps, long numPoints, JobConf jobConf) throws IOException {
        jobConf.setJobName(PiEstimator.class.getSimpleName());
        jobConf.setInputFormat(SequenceFileInputFormat.class);
        jobConf.setOutputKeyClass(BooleanWritable.class);
        jobConf.setOutputValueClass(LongWritable.class);
        jobConf.setOutputFormat(SequenceFileOutputFormat.class);
        jobConf.setMapperClass(PiMapper.class);
        jobConf.setNumMapTasks(numMaps);
        jobConf.setReducerClass(PiReducer.class);
        jobConf.setNumReduceTasks(1);
        jobConf.setSpeculativeExecution(false);
        Path inDir = new Path(TMP_DIR, "in");
        Path outDir = new Path(TMP_DIR, "out");
        FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)jobConf, (Path)outDir);
        FileSystem fs = FileSystem.get((Configuration)jobConf);
        if (fs.exists(TMP_DIR)) {
            throw new IOException("Tmp directory " + fs.makeQualified(TMP_DIR) + " already exists.  Please remove it first.");
        }
        if (!fs.mkdirs(inDir)) {
            throw new IOException("Cannot create input directory " + inDir);
        }
        try {
            for (int i = 0; i < numMaps; ++i) {
                Path file = new Path(inDir, "part" + i);
                LongWritable offset = new LongWritable((long)i * numPoints);
                LongWritable size = new LongWritable(numPoints);
                SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)jobConf, (Path)file, LongWritable.class, LongWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);
                try {
                    writer.append((Writable)offset, (Writable)size);
                }
                finally {
                    writer.close();
                }
                System.out.println("Wrote input for Map #" + i);
            }
            System.out.println("Starting Job");
            long startTime = System.currentTimeMillis();
            JobClient.runJob((JobConf)jobConf);
            double duration = (double)(System.currentTimeMillis() - startTime) / 1000.0;
            System.out.println("Job Finished in " + duration + " seconds");
            Path inFile = new Path(outDir, "reduce-out");
            LongWritable numInside = new LongWritable();
            LongWritable numOutside = new LongWritable();
            SequenceFile.Reader reader = new SequenceFile.Reader(fs, inFile, (Configuration)jobConf);
            try {
                reader.next((Writable)numInside, (Writable)numOutside);
            }
            finally {
                reader.close();
            }
            BigDecimal bigDecimal = BigDecimal.valueOf(4L).setScale(20).multiply(BigDecimal.valueOf(numInside.get())).divide(BigDecimal.valueOf(numMaps)).divide(BigDecimal.valueOf(numPoints));
            return bigDecimal;
        }
        finally {
            fs.delete(TMP_DIR, true);
        }
    }

    public int run(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Usage: " + ((Object)((Object)this)).getClass().getName() + " <nMaps> <nSamples>");
            ToolRunner.printGenericCommandUsage((PrintStream)System.err);
            return -1;
        }
        int nMaps = Integer.parseInt(args[0]);
        long nSamples = Long.parseLong(args[1]);
        System.out.println("Number of Maps  = " + nMaps);
        System.out.println("Samples per Map = " + nSamples);
        JobConf jobConf = new JobConf(this.getConf(), ((Object)((Object)this)).getClass());
        System.out.println("Estimated value of Pi is " + PiEstimator.estimate(nMaps, nSamples, jobConf));
        return 0;
    }

    public static void main(String[] argv) throws Exception {
        System.exit(ToolRunner.run(null, (Tool)new PiEstimator(), (String[])argv));
    }

    public static class PiReducer
    extends MapReduceBase
    implements Reducer<BooleanWritable, LongWritable, WritableComparable<?>, Writable> {
        private long numInside = 0L;
        private long numOutside = 0L;
        private JobConf conf;

        public void configure(JobConf job) {
            this.conf = job;
        }

        public void reduce(BooleanWritable isInside, Iterator<LongWritable> values, OutputCollector<WritableComparable<?>, Writable> output, Reporter reporter) throws IOException {
            if (isInside.get()) {
                while (values.hasNext()) {
                    this.numInside += values.next().get();
                }
            } else {
                while (values.hasNext()) {
                    this.numOutside += values.next().get();
                }
            }
        }

        public void close() throws IOException {
            Path outDir = new Path(TMP_DIR, "out");
            Path outFile = new Path(outDir, "reduce-out");
            FileSystem fileSys = FileSystem.get((Configuration)this.conf);
            SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fileSys, (Configuration)this.conf, (Path)outFile, LongWritable.class, LongWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);
            writer.append((Writable)new LongWritable(this.numInside), (Writable)new LongWritable(this.numOutside));
            writer.close();
        }
    }

    public static class PiMapper
    extends MapReduceBase
    implements Mapper<LongWritable, LongWritable, BooleanWritable, LongWritable> {
        public void map(LongWritable offset, LongWritable size, OutputCollector<BooleanWritable, LongWritable> out, Reporter reporter) throws IOException {
            HaltonSequence haltonsequence = new HaltonSequence(offset.get());
            long numInside = 0L;
            long numOutside = 0L;
            long i = 0L;
            while (i < size.get()) {
                double y;
                double[] point = haltonsequence.nextPoint();
                double x = point[0] - 0.5;
                if (x * x + (y = point[1] - 0.5) * y > 0.25) {
                    ++numOutside;
                } else {
                    ++numInside;
                }
                if (++i % 1000L != 0L) continue;
                reporter.setStatus("Generated " + i + " samples.");
            }
            out.collect((Object)new BooleanWritable(true), (Object)new LongWritable(numInside));
            out.collect((Object)new BooleanWritable(false), (Object)new LongWritable(numOutside));
        }
    }

    private static class HaltonSequence {
        static final int[] P = new int[]{2, 3};
        static final int[] K = new int[]{63, 40};
        private long index;
        private double[] x;
        private double[][] q;
        private int[][] d;

        HaltonSequence(long startindex) {
            int i;
            this.index = startindex;
            this.x = new double[K.length];
            this.q = new double[K.length][];
            this.d = new int[K.length][];
            for (i = 0; i < K.length; ++i) {
                this.q[i] = new double[K[i]];
                this.d[i] = new int[K[i]];
            }
            for (i = 0; i < K.length; ++i) {
                long k = this.index;
                this.x[i] = 0.0;
                for (int j = 0; j < K[i]; ++j) {
                    this.q[i][j] = (j == 0 ? 1.0 : this.q[i][j - 1]) / (double)P[i];
                    this.d[i][j] = (int)(k % (long)P[i]);
                    k = (k - (long)this.d[i][j]) / (long)P[i];
                    int n = i;
                    this.x[n] = this.x[n] + (double)this.d[i][j] * this.q[i][j];
                }
            }
        }

        double[] nextPoint() {
            ++this.index;
            block0: for (int i = 0; i < K.length; ++i) {
                for (int j = 0; j < K[i]; ++j) {
                    int[] nArray = this.d[i];
                    int n = j;
                    nArray[n] = nArray[n] + 1;
                    int n2 = i;
                    this.x[n2] = this.x[n2] + this.q[i][j];
                    if (this.d[i][j] < P[i]) continue block0;
                    this.d[i][j] = 0;
                    int n3 = i;
                    this.x[n3] = this.x[n3] - (j == 0 ? 1.0 : this.q[i][j - 1]);
                }
            }
            return this.x;
        }
    }
}

