/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.ExecDriver;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.plan.ConditionalResolver;
import org.apache.hadoop.hive.ql.plan.ConditionalWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;

public class ConditionalTask
extends Task<ConditionalWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<Task<? extends Serializable>> listTasks;
    private boolean resolved = false;
    private List<Task<? extends Serializable>> resTasks;
    private ConditionalResolver resolver;
    private Object resolverCtx;

    @Override
    public boolean isMapRedTask() {
        for (Task<? extends Serializable> task : this.listTasks) {
            if (!task.isMapRedTask()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasReduce() {
        for (Task<? extends Serializable> task : this.listTasks) {
            if (!task.hasReduce()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void initialize(HiveConf conf, QueryPlan queryPlan, DriverContext driverContext) {
        super.initialize(conf, queryPlan, driverContext);
    }

    @Override
    public int execute(DriverContext driverContext) {
        this.resTasks = this.resolver.getTasks(this.conf, this.resolverCtx);
        this.resolved = true;
        for (Task<? extends Serializable> tsk : this.getListTasks()) {
            if (!this.resTasks.contains(tsk)) {
                driverContext.getRunnable().remove(tsk);
                this.console.printInfo(ExecDriver.getJobEndMsg("" + Utilities.randGen.nextInt()) + ", job is filtered out (removed at runtime).");
                if (tsk.isMapRedTask()) {
                    driverContext.incCurJobNo(1);
                }
                if (tsk.getChildTasks() == null) continue;
                for (Task<Serializable> child : tsk.getChildTasks()) {
                    child.parentTasks.remove(tsk);
                    if (!DriverContext.isLaunchable(child)) continue;
                    driverContext.addToRunnable(child);
                }
                continue;
            }
            if (driverContext.getRunnable().contains(tsk)) continue;
            driverContext.addToRunnable(tsk);
        }
        return 0;
    }

    public ConditionalResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(ConditionalResolver resolver) {
        this.resolver = resolver;
    }

    public Object getResolverCtx() {
        return this.resolverCtx;
    }

    @Override
    public boolean done() {
        boolean ret = true;
        List<Task<Serializable>> parentTasks = this.getParentTasks();
        if (parentTasks != null) {
            for (Task<Serializable> par : parentTasks) {
                ret = ret && par.done();
            }
        }
        List<Task<? extends Serializable>> retTasks = this.resolved ? this.resTasks : this.getListTasks();
        if (ret && retTasks != null) {
            for (Task<? extends Serializable> tsk : retTasks) {
                ret = ret && tsk.done();
            }
        }
        return ret;
    }

    public void setResolverCtx(Object resolverCtx) {
        this.resolverCtx = resolverCtx;
    }

    public List<Task<? extends Serializable>> getListTasks() {
        return this.listTasks;
    }

    public void setListTasks(List<Task<? extends Serializable>> listTasks) {
        this.listTasks = listTasks;
    }

    @Override
    public StageType getType() {
        return StageType.CONDITIONAL;
    }

    @Override
    public String getName() {
        return "CONDITION";
    }

    @Override
    public boolean addDependentTask(Task<? extends Serializable> dependent) {
        boolean ret = false;
        if (this.getListTasks() != null) {
            for (Task<? extends Serializable> tsk : this.getListTasks()) {
                ret &= tsk.addDependentTask(dependent);
            }
        }
        return ret;
    }
}

