/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.BucketMatcher;
import org.apache.hadoop.hive.ql.exec.ExecMapper;
import org.apache.hadoop.hive.ql.exec.FetchOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.serde2.objectinspector.InspectableObject;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.ReflectionUtils;

public class ExecMapperContext {
    public static final Log l4j = ExecMapper.l4j;
    private String lastInputFile = null;
    private String currentInputFile = null;
    private boolean inputFileChecked = false;
    private Integer fileId = new Integer(-1);
    private MapredLocalWork localWork = null;
    private Map<String, FetchOperator> fetchOperators;
    private JobConf jc;

    public void processInputFileChangeForLocalWork() throws HiveException {
        if (this.localWork != null && this.inputFileChanged()) {
            this.processMapLocalWork(this.localWork.getInputFileChangeSensitive());
        }
    }

    public boolean inputFileChanged() {
        if (!this.inputFileChecked) {
            this.currentInputFile = HiveConf.getVar((Configuration)this.jc, HiveConf.ConfVars.HADOOPMAPFILENAME);
            this.inputFileChecked = true;
        }
        return this.lastInputFile == null || !this.lastInputFile.equals(this.currentInputFile);
    }

    public void resetRow() {
        this.lastInputFile = this.currentInputFile;
        this.inputFileChecked = false;
    }

    public String getLastInputFile() {
        return this.lastInputFile;
    }

    public void setLastInputFile(String lastInputFile) {
        this.lastInputFile = lastInputFile;
    }

    private void processMapLocalWork(boolean inputFileChangeSenstive) throws HiveException {
        if (this.fetchOperators != null) {
            try {
                int fetchOpNum = 0;
                for (Map.Entry<String, FetchOperator> entry : this.fetchOperators.entrySet()) {
                    int fetchOpRows;
                    block8: {
                        fetchOpRows = 0;
                        String alias = entry.getKey();
                        FetchOperator fetchOp = entry.getValue();
                        if (inputFileChangeSenstive) {
                            fetchOp.clearFetchContext();
                            this.setUpFetchOpContext(fetchOp, alias);
                        }
                        Operator<? extends Serializable> forwardOp = this.localWork.getAliasToWork().get(alias);
                        do {
                            InspectableObject row;
                            if ((row = fetchOp.getNextRow()) == null) {
                                forwardOp.close(false);
                                break block8;
                            }
                            ++fetchOpRows;
                            forwardOp.process(row.o, 0);
                        } while (!forwardOp.getDone());
                        ExecMapper.setDone(true);
                    }
                    if (!l4j.isInfoEnabled()) continue;
                    l4j.info((Object)("fetch " + fetchOpNum++ + " processed " + fetchOpRows + " used mem: " + ExecMapper.memoryMXBean.getHeapMemoryUsage().getUsed()));
                }
            }
            catch (Throwable e) {
                if (e instanceof OutOfMemoryError) {
                    throw (OutOfMemoryError)e;
                }
                throw new HiveException("Hive Runtime Error: Map local work failed", e);
            }
        }
    }

    private void setUpFetchOpContext(FetchOperator fetchOp, String alias) throws Exception {
        String currentInputFile = HiveConf.getVar((Configuration)this.jc, HiveConf.ConfVars.HADOOPMAPFILENAME);
        MapredLocalWork.BucketMapJoinContext bucketMatcherCxt = this.localWork.getBucketMapjoinContext();
        Class<? extends BucketMatcher> bucketMatcherCls = bucketMatcherCxt.getBucketMatcherClass();
        BucketMatcher bucketMatcher = (BucketMatcher)ReflectionUtils.newInstance(bucketMatcherCls, null);
        bucketMatcher.setAliasBucketFileNameMapping(bucketMatcherCxt.getAliasBucketFileNameMapping());
        List<Path> aliasFiles = bucketMatcher.getAliasBucketFiles(currentInputFile, bucketMatcherCxt.getMapJoinBigTableAlias(), alias);
        Iterator<Path> iter = aliasFiles.iterator();
        fetchOp.setupContext(iter, null);
    }

    public String getCurrentInputFile() {
        return this.currentInputFile;
    }

    public void setCurrentInputFile(String currentInputFile) {
        this.currentInputFile = currentInputFile;
    }

    public JobConf getJc() {
        return this.jc;
    }

    public void setJc(JobConf jc) {
        this.jc = jc;
    }

    public MapredLocalWork getLocalWork() {
        return this.localWork;
    }

    public void setLocalWork(MapredLocalWork localWork) {
        this.localWork = localWork;
    }

    public Integer getFileId() {
        return this.fileId;
    }

    public void setFileId(Integer fileId) {
        this.fileId = fileId;
    }

    public Map<String, FetchOperator> getFetchOperators() {
        return this.fetchOperators;
    }

    public void setFetchOperators(Map<String, FetchOperator> fetchOperators) {
        this.fetchOperators = fetchOperators;
    }
}

