/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.AbstractMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.LateralViewJoinOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.ScriptOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.parse.ErrorMsg;
import org.apache.hadoop.hive.ql.parse.GenMapRedWalker;
import org.apache.hadoop.hive.ql.parse.OpParseContext;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.QBJoinTree;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.JoinCondDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;

public class MapJoinProcessor
implements Transform {
    private static final Log LOG = LogFactory.getLog((String)MapJoinProcessor.class.getName());
    private ParseContext pGraphContext = null;

    private Operator<? extends Serializable> putOpInsertMap(Operator<? extends Serializable> op, RowResolver rr) {
        OpParseContext ctx = new OpParseContext(rr);
        this.pGraphContext.getOpParseCtx().put(op, ctx);
        return op;
    }

    private MapJoinOperator convertMapJoin(ParseContext pctx, JoinOperator op, QBJoinTree joinTree, int mapJoinPos) throws SemanticException {
        boolean noCheckOuterJoin;
        JoinDesc desc = (JoinDesc)op.getConf();
        JoinCondDesc[] condns = desc.getConds();
        HiveConf hiveConf = this.pGraphContext.getConf();
        boolean bl = noCheckOuterJoin = HiveConf.getBoolVar(hiveConf, HiveConf.ConfVars.HIVEOPTSORTMERGEBUCKETMAPJOIN) && HiveConf.getBoolVar(hiveConf, HiveConf.ConfVars.HIVEOPTBUCKETMAPJOIN);
        if (!noCheckOuterJoin) {
            MapJoinProcessor.checkMapJoin(mapJoinPos, condns);
        }
        RowResolver oldOutputRS = pctx.getOpParseCtx().get(op).getRR();
        RowResolver outputRS = new RowResolver();
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        HashMap<Byte, List<ExprNodeDesc>> keyExprMap = new HashMap<Byte, List<ExprNodeDesc>>();
        HashMap<Byte, List<ExprNodeDesc>> valueExprMap = new HashMap<Byte, List<ExprNodeDesc>>();
        QBJoinTree leftSrc = joinTree.getJoinSrc();
        List<Operator<Serializable>> parentOps = op.getParentOperators();
        ArrayList<Operator<? extends Serializable>> newParentOps = new ArrayList<Operator<? extends Serializable>>();
        ArrayList<Operator<Serializable>> oldReduceSinkParentOps = new ArrayList<Operator<Serializable>>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        if (leftSrc != null) {
            Operator<Serializable> parentOp = parentOps.get(0);
            assert (parentOp.getParentOperators().size() == 1);
            Operator<Serializable> grandParentOp = parentOp.getParentOperators().get(0);
            oldReduceSinkParentOps.add(parentOp);
            grandParentOp.removeChild(parentOp);
            newParentOps.add(grandParentOp);
        }
        int pos = 0;
        for (String string : joinTree.getBaseSrc()) {
            if (string != null) {
                Operator<Serializable> parentOp = parentOps.get(pos);
                assert (parentOp.getParentOperators().size() == 1);
                Operator<Serializable> grandParentOp = parentOp.getParentOperators().get(0);
                grandParentOp.removeChild(parentOp);
                oldReduceSinkParentOps.add(parentOp);
                newParentOps.add(grandParentOp);
            }
            ++pos;
        }
        for (pos = 0; pos < newParentOps.size(); ++pos) {
            ReduceSinkOperator oldPar = (ReduceSinkOperator)oldReduceSinkParentOps.get(pos);
            ReduceSinkDesc rsconf = (ReduceSinkDesc)oldPar.getConf();
            Byte tag = (byte)rsconf.getTag();
            ArrayList<ExprNodeDesc> arrayList = rsconf.getKeyCols();
            keyExprMap.put(tag, arrayList);
        }
        for (pos = 0; pos < newParentOps.size(); ++pos) {
            RowResolver inputRS = this.pGraphContext.getOpParseCtx().get(newParentOps.get(pos)).getRR();
            ArrayList<ExprNodeColumnDesc> values = new ArrayList<ExprNodeColumnDesc>();
            for (String string : inputRS.getTableNames()) {
                HashMap<String, ColumnInfo> rrMap = inputRS.getFieldMap(string);
                for (String field : rrMap.keySet()) {
                    ColumnInfo valueInfo = inputRS.get(string, field);
                    ColumnInfo oldValueInfo = oldOutputRS.get(string, field);
                    if (oldValueInfo == null) continue;
                    String string2 = oldValueInfo.getInternalName();
                    if (outputRS.get(string, field) != null) continue;
                    outputColumnNames.add(string2);
                    ExprNodeColumnDesc colDesc = new ExprNodeColumnDesc(valueInfo.getType(), valueInfo.getInternalName(), valueInfo.getTabAlias(), valueInfo.getIsPartitionCol());
                    values.add(colDesc);
                    outputRS.put(string, field, new ColumnInfo(string2, valueInfo.getType(), valueInfo.getTabAlias(), valueInfo.getIsPartitionCol()));
                    colExprMap.put(string2, colDesc);
                }
            }
            valueExprMap.put(new Byte((byte)pos), values);
        }
        JoinCondDesc[] joinCondns = ((JoinDesc)op.getConf()).getConds();
        Operator[] newPar = new Operator[newParentOps.size()];
        pos = 0;
        for (Operator operator : newParentOps) {
            newPar[pos++] = operator;
        }
        List keyCols = (List)keyExprMap.get(new Byte(0));
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < keyCols.size(); ++i) {
            stringBuilder.append("+");
        }
        TableDesc keyTableDesc = PlanUtils.getMapJoinKeyTableDesc(PlanUtils.getFieldSchemasFromColumnList(keyCols, "mapjoinkey"));
        ArrayList<TableDesc> valueTableDescs = new ArrayList<TableDesc>();
        for (pos = 0; pos < newParentOps.size(); ++pos) {
            List valueCols = (List)valueExprMap.get(new Byte((byte)pos));
            StringBuilder stringBuilder2 = new StringBuilder();
            for (int i = 0; i < valueCols.size(); ++i) {
                stringBuilder2.append("+");
            }
            TableDesc valueTableDesc = PlanUtils.getMapJoinValueTableDesc(PlanUtils.getFieldSchemasFromColumnList(valueCols, "mapjoinvalue"));
            valueTableDescs.add(valueTableDesc);
        }
        MapJoinOperator mapJoinOp = (MapJoinOperator)this.putOpInsertMap(OperatorFactory.getAndMakeChild(new MapJoinDesc(keyExprMap, keyTableDesc, valueExprMap, valueTableDescs, outputColumnNames, mapJoinPos, joinCondns), new RowSchema(outputRS.getColumnInfos()), newPar), outputRS);
        ((MapJoinDesc)mapJoinOp.getConf()).setReversedExprs(((JoinDesc)op.getConf()).getReversedExprs());
        mapJoinOp.setColumnExprMap(colExprMap);
        List<Operator<? extends Serializable>> childOps = op.getChildOperators();
        for (Operator<Serializable> operator : childOps) {
            operator.replaceParent(op, mapJoinOp);
        }
        mapJoinOp.setChildOperators(childOps);
        mapJoinOp.setParentOperators(newParentOps);
        op.setChildOperators(null);
        op.setParentOperators(null);
        this.genSelectPlan(pctx, mapJoinOp);
        return mapJoinOp;
    }

    public static void checkMapJoin(int mapJoinPos, JoinCondDesc[] condns) throws SemanticException {
        for (JoinCondDesc condn : condns) {
            if (condn.getType() == 3) {
                throw new SemanticException(ErrorMsg.NO_OUTER_MAPJOIN.getMsg());
            }
            if (condn.getType() == 1 && condn.getLeft() != mapJoinPos) {
                throw new SemanticException(ErrorMsg.NO_OUTER_MAPJOIN.getMsg());
            }
            if (condn.getType() != 2 || condn.getRight() == mapJoinPos) continue;
            throw new SemanticException(ErrorMsg.NO_OUTER_MAPJOIN.getMsg());
        }
    }

    private void genSelectPlan(ParseContext pctx, MapJoinOperator input) throws SemanticException {
        List<Operator<? extends Serializable>> childOps = input.getChildOperators();
        input.setChildOperators(null);
        RowResolver inputRR = pctx.getOpParseCtx().get(input).getRR();
        ArrayList<ExprNodeDesc> exprs = new ArrayList<ExprNodeDesc>();
        ArrayList<String> outputs = new ArrayList<String>();
        List<String> outputCols = ((MapJoinDesc)input.getConf()).getOutputColumnNames();
        RowResolver outputRS = new RowResolver();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        for (int i = 0; i < outputCols.size(); ++i) {
            String internalName = outputCols.get(i);
            String[] nm = inputRR.reverseLookup(internalName);
            ColumnInfo valueInfo = inputRR.get(nm[0], nm[1]);
            ExprNodeColumnDesc colDesc = new ExprNodeColumnDesc(valueInfo.getType(), valueInfo.getInternalName(), nm[0], valueInfo.getIsPartitionCol());
            exprs.add(colDesc);
            outputs.add(internalName);
            outputRS.put(nm[0], nm[1], new ColumnInfo(internalName, valueInfo.getType(), nm[0], valueInfo.getIsPartitionCol()));
            colExprMap.put(internalName, colDesc);
        }
        SelectDesc select = new SelectDesc(exprs, outputs, false);
        SelectOperator sel = (SelectOperator)this.putOpInsertMap(OperatorFactory.getAndMakeChild(select, new RowSchema(inputRR.getColumnInfos()), input), inputRR);
        sel.setColumnExprMap(colExprMap);
        sel.setChildOperators(childOps);
        for (Operator<? extends Serializable> ch : childOps) {
            ch.replaceParent(input, sel);
        }
    }

    private int mapSideJoin(JoinOperator op, QBJoinTree joinTree) throws SemanticException {
        int mapJoinPos = -1;
        if (joinTree.isMapSideJoin()) {
            int pos = 0;
            if (joinTree.getJoinSrc() != null) {
                mapJoinPos = pos;
            }
            for (String src : joinTree.getBaseSrc()) {
                if (src != null && !joinTree.getMapAliases().contains(src)) {
                    if (mapJoinPos >= 0) {
                        return -1;
                    }
                    mapJoinPos = pos;
                }
                ++pos;
            }
            if (mapJoinPos == -1) {
                throw new SemanticException(ErrorMsg.INVALID_MAPJOIN_HINT.getMsg(this.pGraphContext.getQB().getParseInfo().getHints()));
            }
        }
        return mapJoinPos;
    }

    @Override
    public ParseContext transform(ParseContext pactx) throws SemanticException {
        this.pGraphContext = pactx;
        ArrayList<MapJoinOperator> listMapJoinOps = new ArrayList<MapJoinOperator>();
        if (this.pGraphContext.getJoinContext() != null) {
            HashMap<JoinOperator, QBJoinTree> joinMap = new HashMap<JoinOperator, QBJoinTree>();
            Map<MapJoinOperator, QBJoinTree> mapJoinMap = this.pGraphContext.getMapJoinContext();
            if (mapJoinMap == null) {
                mapJoinMap = new HashMap<MapJoinOperator, QBJoinTree>();
                this.pGraphContext.setMapJoinContext(mapJoinMap);
            }
            Set<Map.Entry<JoinOperator, QBJoinTree>> joinCtx = this.pGraphContext.getJoinContext().entrySet();
            for (Map.Entry<JoinOperator, QBJoinTree> joinEntry : joinCtx) {
                QBJoinTree qbJoin;
                JoinOperator joinOp = joinEntry.getKey();
                int mapJoinPos = this.mapSideJoin(joinOp, qbJoin = joinEntry.getValue());
                if (mapJoinPos >= 0) {
                    MapJoinOperator mapJoinOp = this.convertMapJoin(pactx, joinOp, qbJoin, mapJoinPos);
                    listMapJoinOps.add(mapJoinOp);
                    mapJoinMap.put(mapJoinOp, qbJoin);
                    continue;
                }
                joinMap.put(joinOp, qbJoin);
            }
            this.pGraphContext.setJoinContext(joinMap);
        }
        ArrayList<AbstractMapJoinOperator<? extends MapJoinDesc>> listMapJoinOpsNoRed = new ArrayList<AbstractMapJoinOperator<? extends MapJoinDesc>>();
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp(new String("R0"), "MAPJOIN%"), MapJoinProcessor.getCurrentMapJoin());
        opRules.put(new RuleRegExp(new String("R1"), "MAPJOIN%.*FS%"), MapJoinProcessor.getMapJoinFS());
        opRules.put(new RuleRegExp(new String("R2"), "MAPJOIN%.*RS%"), MapJoinProcessor.getMapJoinDefault());
        opRules.put(new RuleRegExp(new String("R4"), "MAPJOIN%.*UNION%"), MapJoinProcessor.getMapJoinDefault());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(MapJoinProcessor.getDefault(), opRules, new MapJoinWalkerCtx(listMapJoinOpsNoRed, this.pGraphContext));
        GenMapRedWalker ogw = new GenMapRedWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(listMapJoinOps);
        ogw.startWalking(topNodes, null);
        this.pGraphContext.setListMapJoinOpsNoReducer(listMapJoinOpsNoRed);
        return this.pGraphContext;
    }

    private static void addNoReducerMapJoinToCtx(MapJoinWalkerCtx ctx, AbstractMapJoinOperator<? extends MapJoinDesc> mapJoin) {
        if (ctx.getListRejectedMapJoins() != null && ctx.getListRejectedMapJoins().contains(mapJoin)) {
            return;
        }
        List<AbstractMapJoinOperator<? extends MapJoinDesc>> listMapJoinsNoRed = ctx.getListMapJoinsNoRed();
        if (listMapJoinsNoRed == null) {
            listMapJoinsNoRed = new ArrayList<AbstractMapJoinOperator<? extends MapJoinDesc>>();
        }
        if (!listMapJoinsNoRed.contains(mapJoin)) {
            listMapJoinsNoRed.add(mapJoin);
        }
        ctx.setListMapJoins(listMapJoinsNoRed);
    }

    private static void addRejectMapJoinToCtx(MapJoinWalkerCtx ctx, AbstractMapJoinOperator<? extends MapJoinDesc> mapjoin) {
        if (mapjoin == null) {
            return;
        }
        List<AbstractMapJoinOperator<? extends MapJoinDesc>> listRejectedMapJoins = ctx.getListRejectedMapJoins();
        if (listRejectedMapJoins == null) {
            listRejectedMapJoins = new ArrayList<AbstractMapJoinOperator<? extends MapJoinDesc>>();
        }
        if (!listRejectedMapJoins.contains(mapjoin)) {
            listRejectedMapJoins.add(mapjoin);
        }
        if (ctx.getListMapJoinsNoRed() != null && ctx.getListMapJoinsNoRed().contains(mapjoin)) {
            ctx.getListMapJoinsNoRed().remove(mapjoin);
        }
        ctx.setListRejectedMapJoins(listRejectedMapJoins);
    }

    private static int findGrandparentBranch(Operator<? extends Serializable> currOp, Operator<? extends Serializable> grandParent) {
        int pos = -1;
        for (int i = 0; i < currOp.getParentOperators().size(); ++i) {
            LinkedList<Operator<Serializable>> parentOpList = new LinkedList<Operator<Serializable>>();
            parentOpList.add(currOp.getParentOperators().get(i));
            boolean found = false;
            while (!parentOpList.isEmpty()) {
                Operator p = (Operator)parentOpList.remove(0);
                if (p == grandParent) {
                    found = true;
                    break;
                }
                if (p.getParentOperators() == null) continue;
                parentOpList.addAll(p.getParentOperators());
            }
            if (!found) continue;
            pos = i;
            break;
        }
        return pos;
    }

    public static NodeProcessor getMapJoinFS() {
        return new MapJoinFS();
    }

    public static NodeProcessor getMapJoinDefault() {
        return new MapJoinDefault();
    }

    public static NodeProcessor getDefault() {
        return new Default();
    }

    public static NodeProcessor getCurrentMapJoin() {
        return new CurrentMapJoin();
    }

    public static class MapJoinWalkerCtx
    implements NodeProcessorCtx {
        private ParseContext pGraphContext;
        private List<AbstractMapJoinOperator<? extends MapJoinDesc>> listMapJoinsNoRed;
        private List<AbstractMapJoinOperator<? extends MapJoinDesc>> listRejectedMapJoins;
        private AbstractMapJoinOperator<? extends MapJoinDesc> currMapJoinOp;

        public MapJoinWalkerCtx(List<AbstractMapJoinOperator<? extends MapJoinDesc>> listMapJoinsNoRed, ParseContext pGraphContext) {
            this.listMapJoinsNoRed = listMapJoinsNoRed;
            this.currMapJoinOp = null;
            this.listRejectedMapJoins = new ArrayList<AbstractMapJoinOperator<? extends MapJoinDesc>>();
            this.pGraphContext = pGraphContext;
        }

        public List<AbstractMapJoinOperator<? extends MapJoinDesc>> getListMapJoinsNoRed() {
            return this.listMapJoinsNoRed;
        }

        public void setListMapJoins(List<AbstractMapJoinOperator<? extends MapJoinDesc>> listMapJoinsNoRed) {
            this.listMapJoinsNoRed = listMapJoinsNoRed;
        }

        public AbstractMapJoinOperator<? extends MapJoinDesc> getCurrMapJoinOp() {
            return this.currMapJoinOp;
        }

        public void setCurrMapJoinOp(AbstractMapJoinOperator<? extends MapJoinDesc> currMapJoinOp) {
            this.currMapJoinOp = currMapJoinOp;
        }

        public List<AbstractMapJoinOperator<? extends MapJoinDesc>> getListRejectedMapJoins() {
            return this.listRejectedMapJoins;
        }

        public void setListRejectedMapJoins(List<AbstractMapJoinOperator<? extends MapJoinDesc>> listRejectedMapJoins) {
            this.listRejectedMapJoins = listRejectedMapJoins;
        }

        public ParseContext getpGraphContext() {
            return this.pGraphContext;
        }

        public void setpGraphContext(ParseContext pGraphContext) {
            this.pGraphContext = pGraphContext;
        }
    }

    public static class Default
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            return null;
        }
    }

    public static class MapJoinDefault
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            MapJoinWalkerCtx ctx = (MapJoinWalkerCtx)procCtx;
            AbstractMapJoinOperator<? extends MapJoinDesc> mapJoin = ctx.getCurrMapJoinOp();
            MapJoinProcessor.addRejectMapJoinToCtx(ctx, mapJoin);
            return null;
        }
    }

    public static class MapJoinFS
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            MapJoinWalkerCtx ctx = (MapJoinWalkerCtx)procCtx;
            AbstractMapJoinOperator<? extends MapJoinDesc> mapJoin = ctx.getCurrMapJoinOp();
            List<AbstractMapJoinOperator<? extends MapJoinDesc>> listRejectedMapJoins = ctx.getListRejectedMapJoins();
            if (listRejectedMapJoins != null && listRejectedMapJoins.contains(mapJoin)) {
                return null;
            }
            MapJoinProcessor.addNoReducerMapJoinToCtx(ctx, mapJoin);
            return null;
        }
    }

    public static class CurrentMapJoin
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            MapJoinWalkerCtx ctx = (MapJoinWalkerCtx)procCtx;
            MapJoinOperator mapJoin = (MapJoinOperator)nd;
            if (ctx.getListRejectedMapJoins() != null && !ctx.getListRejectedMapJoins().contains(mapJoin)) {
                Boolean bigBranch = this.findGrandChildSubqueryMapjoin(ctx, mapJoin);
                if (bigBranch == null) {
                    ctx.setCurrMapJoinOp(mapJoin);
                    return null;
                }
                if (bigBranch.booleanValue()) {
                    MapJoinProcessor.addNoReducerMapJoinToCtx(ctx, mapJoin);
                } else {
                    MapJoinProcessor.addRejectMapJoinToCtx(ctx, mapJoin);
                }
            } else {
                ctx.setCurrMapJoinOp(mapJoin);
            }
            return null;
        }

        private Boolean findGrandChildSubqueryMapjoin(MapJoinWalkerCtx ctx, MapJoinOperator mapJoin) {
            Operator parent = mapJoin;
            while (parent.getChildOperators() != null && parent.getChildOperators().size() == 1) {
                Operator<Serializable> ch = parent.getChildOperators().get(0);
                if (ch instanceof MapJoinOperator) {
                    if (!this.nonSubqueryMapJoin(ctx.getpGraphContext(), (MapJoinOperator)ch, mapJoin) && ch.getParentOperators().indexOf(parent) == ((MapJoinDesc)((MapJoinOperator)ch).getConf()).getPosBigTable()) {
                        return true;
                    }
                    return false;
                }
                if (ch instanceof JoinOperator || ch instanceof UnionOperator || ch instanceof ReduceSinkOperator || ch instanceof LateralViewJoinOperator || ch instanceof GroupByOperator || ch instanceof ScriptOperator) {
                    return null;
                }
                parent = ch;
            }
            return null;
        }

        private boolean nonSubqueryMapJoin(ParseContext pGraphContext, MapJoinOperator mapJoin, MapJoinOperator parentMapJoin) {
            QBJoinTree joinTree = pGraphContext.getMapJoinContext().get(mapJoin);
            QBJoinTree parentJoinTree = pGraphContext.getMapJoinContext().get(parentMapJoin);
            return joinTree.getJoinSrc() != null && joinTree.getJoinSrc().equals(parentJoinTree);
        }
    }
}

