/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.TableSample;

public class QBParseInfo {
    private final boolean isSubQ;
    private final String alias;
    private ASTNode joinExpr;
    private ASTNode hints;
    private final HashMap<String, ASTNode> aliasToSrc = new HashMap();
    private final HashMap<String, ASTNode> nameToDest = new HashMap();
    private final HashMap<String, TableSample> nameToSample = new HashMap();
    private final Map<String, ASTNode> destToSelExpr = new LinkedHashMap<String, ASTNode>();
    private final HashMap<String, ASTNode> destToWhereExpr = new HashMap();
    private final HashMap<String, ASTNode> destToGroupby = new HashMap();
    private final HashMap<String, ASTNode> destToClusterby = new HashMap();
    private final HashMap<String, ASTNode> destToDistributeby = new HashMap();
    private final HashMap<String, ASTNode> destToSortby = new HashMap();
    private final HashMap<String, ArrayList<ASTNode>> aliasToLateralViews;
    private final HashMap<String, ASTNode> destToOrderby = new HashMap();
    private final HashMap<String, Integer> destToLimit = new HashMap();
    private int outerQueryLimit;
    private final LinkedHashMap<String, LinkedHashMap<String, ASTNode>> destToAggregationExprs = new LinkedHashMap();
    private final HashMap<String, ASTNode> destToDistinctFuncExpr = new HashMap();
    private static final Log LOG = LogFactory.getLog((String)QBParseInfo.class.getName());

    public QBParseInfo(String alias, boolean isSubQ) {
        this.alias = alias;
        this.isSubQ = isSubQ;
        this.outerQueryLimit = -1;
        this.aliasToLateralViews = new HashMap();
    }

    public void setAggregationExprsForClause(String clause, LinkedHashMap<String, ASTNode> aggregationTrees) {
        this.destToAggregationExprs.put(clause, aggregationTrees);
    }

    public HashMap<String, ASTNode> getAggregationExprsForClause(String clause) {
        return this.destToAggregationExprs.get(clause);
    }

    public void setDistinctFuncExprForClause(String clause, ASTNode ast) {
        this.destToDistinctFuncExpr.put(clause, ast);
    }

    public ASTNode getDistinctFuncExprForClause(String clause) {
        return this.destToDistinctFuncExpr.get(clause);
    }

    public void setSelExprForClause(String clause, ASTNode ast) {
        this.destToSelExpr.put(clause, ast);
    }

    public void setWhrExprForClause(String clause, ASTNode ast) {
        this.destToWhereExpr.put(clause, ast);
    }

    public void setGroupByExprForClause(String clause, ASTNode ast) {
        this.destToGroupby.put(clause, ast);
    }

    public void setDestForClause(String clause, ASTNode ast) {
        this.nameToDest.put(clause, ast);
    }

    public void setClusterByExprForClause(String clause, ASTNode ast) {
        this.destToClusterby.put(clause, ast);
    }

    public void setDistributeByExprForClause(String clause, ASTNode ast) {
        this.destToDistributeby.put(clause, ast);
    }

    public void setSortByExprForClause(String clause, ASTNode ast) {
        this.destToSortby.put(clause, ast);
    }

    public void setOrderByExprForClause(String clause, ASTNode ast) {
        this.destToOrderby.put(clause, ast);
    }

    public void setSrcForAlias(String alias, ASTNode ast) {
        this.aliasToSrc.put(alias.toLowerCase(), ast);
    }

    public Set<String> getClauseNames() {
        return this.destToSelExpr.keySet();
    }

    public Set<String> getClauseNamesForDest() {
        return this.nameToDest.keySet();
    }

    public ASTNode getDestForClause(String clause) {
        return this.nameToDest.get(clause);
    }

    public ASTNode getWhrForClause(String clause) {
        return this.destToWhereExpr.get(clause);
    }

    public HashMap<String, ASTNode> getDestToWhereExpr() {
        return this.destToWhereExpr;
    }

    public ASTNode getGroupByForClause(String clause) {
        return this.destToGroupby.get(clause);
    }

    public HashMap<String, ASTNode> getDestToGroupBy() {
        return this.destToGroupby;
    }

    public ASTNode getSelForClause(String clause) {
        return this.destToSelExpr.get(clause);
    }

    public ASTNode getClusterByForClause(String clause) {
        return this.destToClusterby.get(clause);
    }

    public HashMap<String, ASTNode> getDestToClusterBy() {
        return this.destToClusterby;
    }

    public ASTNode getDistributeByForClause(String clause) {
        return this.destToDistributeby.get(clause);
    }

    public HashMap<String, ASTNode> getDestToDistributeBy() {
        return this.destToDistributeby;
    }

    public ASTNode getSortByForClause(String clause) {
        return this.destToSortby.get(clause);
    }

    public ASTNode getOrderByForClause(String clause) {
        return this.destToOrderby.get(clause);
    }

    public HashMap<String, ASTNode> getDestToSortBy() {
        return this.destToSortby;
    }

    public HashMap<String, ASTNode> getDestToOrderBy() {
        return this.destToOrderby;
    }

    public ASTNode getSrcForAlias(String alias) {
        return this.aliasToSrc.get(alias.toLowerCase());
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean getIsSubQ() {
        return this.isSubQ;
    }

    public ASTNode getJoinExpr() {
        return this.joinExpr;
    }

    public void setJoinExpr(ASTNode joinExpr) {
        this.joinExpr = joinExpr;
    }

    public TableSample getTabSample(String alias) {
        return this.nameToSample.get(alias.toLowerCase());
    }

    public void setTabSample(String alias, TableSample tableSample) {
        this.nameToSample.put(alias.toLowerCase(), tableSample);
    }

    public void setDestLimit(String dest, Integer limit) {
        this.destToLimit.put(dest, limit);
    }

    public Integer getDestLimit(String dest) {
        return this.destToLimit.get(dest);
    }

    public int getOuterQueryLimit() {
        return this.outerQueryLimit;
    }

    public void setOuterQueryLimit(int outerQueryLimit) {
        this.outerQueryLimit = outerQueryLimit;
    }

    public boolean isSelectStarQuery() {
        if (!(!this.isSubQ && this.joinExpr == null && this.nameToSample.isEmpty() && this.destToGroupby.isEmpty() && this.destToClusterby.isEmpty() && this.aliasToLateralViews.isEmpty())) {
            return false;
        }
        Iterator<Map.Entry<String, LinkedHashMap<String, ASTNode>>> aggrIter = this.destToAggregationExprs.entrySet().iterator();
        while (aggrIter.hasNext()) {
            HashMap h = aggrIter.next().getValue();
            if (h == null || h.isEmpty()) continue;
            return false;
        }
        if (!this.destToDistinctFuncExpr.isEmpty()) {
            Iterator<Map.Entry<String, ASTNode>> distn = this.destToDistinctFuncExpr.entrySet().iterator();
            while (distn.hasNext()) {
                ASTNode ct = distn.next().getValue();
                if (ct == null) continue;
                return false;
            }
        }
        for (Map.Entry<String, ASTNode> entry : this.nameToDest.entrySet()) {
            ASTNode v = entry.getValue();
            if (((ASTNode)v.getChild(0)).getToken().getType() == 129) continue;
            return false;
        }
        for (Map.Entry<String, ASTNode> entry : this.destToSelExpr.entrySet()) {
            ASTNode selExprList = entry.getValue();
            for (int i = 0; i < selExprList.getChildCount(); ++i) {
                ASTNode selExpr = (ASTNode)selExprList.getChild(i);
                ASTNode sel = (ASTNode)selExpr.getChild(0);
                if (sel.getToken().getType() == 18) continue;
                return false;
            }
        }
        return true;
    }

    public void setHints(ASTNode hint) {
        this.hints = hint;
    }

    public ASTNode getHints() {
        return this.hints;
    }

    public Map<String, ArrayList<ASTNode>> getAliasToLateralViews() {
        return this.aliasToLateralViews;
    }

    public List<ASTNode> getLateralViewsForAlias(String alias) {
        return this.aliasToLateralViews.get(alias.toLowerCase());
    }

    public void addLateralViewForAlias(String alias, ASTNode lateralView) {
        String lowerAlias = alias.toLowerCase();
        ArrayList<ASTNode> lateralViews = this.aliasToLateralViews.get(lowerAlias);
        if (lateralViews == null) {
            lateralViews = new ArrayList();
            this.aliasToLateralViews.put(alias, lateralViews);
        }
        lateralViews.add(lateralView);
    }
}

