/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;

@Explain(displayName="Fetch Operator")
public class FetchWork
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String tblDir;
    private TableDesc tblDesc;
    private ArrayList<String> partDir;
    private ArrayList<PartitionDesc> partDesc;
    private int limit;
    private String serializationNullFormat = "NULL";

    public FetchWork() {
    }

    public FetchWork(String tblDir, TableDesc tblDesc) {
        this(tblDir, tblDesc, -1);
    }

    public FetchWork(String tblDir, TableDesc tblDesc, int limit) {
        this.tblDir = tblDir;
        this.tblDesc = tblDesc;
        this.limit = limit;
    }

    public FetchWork(List<String> partDir, List<PartitionDesc> partDesc) {
        this(partDir, partDesc, -1);
    }

    public FetchWork(List<String> partDir, List<PartitionDesc> partDesc, int limit) {
        this.partDir = new ArrayList<String>(partDir);
        this.partDesc = new ArrayList<PartitionDesc>(partDesc);
        this.limit = limit;
    }

    public String getSerializationNullFormat() {
        return this.serializationNullFormat;
    }

    public void setSerializationNullFormat(String format) {
        this.serializationNullFormat = format;
    }

    public String getTblDir() {
        return this.tblDir;
    }

    public Path getTblDirPath() {
        return new Path(this.tblDir);
    }

    public void setTblDir(String tblDir) {
        this.tblDir = tblDir;
    }

    public TableDesc getTblDesc() {
        return this.tblDesc;
    }

    public void setTblDesc(TableDesc tblDesc) {
        this.tblDesc = tblDesc;
    }

    public ArrayList<String> getPartDir() {
        return this.partDir;
    }

    public List<Path> getPartDirPath() {
        return FetchWork.convertStringToPathArray(this.partDir);
    }

    public static List<String> convertPathToStringArray(List<Path> paths) {
        if (paths == null) {
            return null;
        }
        ArrayList<String> pathsStr = new ArrayList<String>();
        for (Path path : paths) {
            pathsStr.add(path.toString());
        }
        return pathsStr;
    }

    public static List<Path> convertStringToPathArray(List<String> paths) {
        if (paths == null) {
            return null;
        }
        ArrayList<Path> pathsStr = new ArrayList<Path>();
        for (String path : paths) {
            pathsStr.add(new Path(path));
        }
        return pathsStr;
    }

    public void setPartDir(ArrayList<String> partDir) {
        this.partDir = partDir;
    }

    public ArrayList<PartitionDesc> getPartDesc() {
        return this.partDesc;
    }

    public void setPartDesc(ArrayList<PartitionDesc> partDesc) {
        this.partDesc = partDesc;
    }

    @Explain(displayName="limit")
    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public String toString() {
        if (this.tblDir != null) {
            return new String("table = " + this.tblDir);
        }
        if (this.partDir == null) {
            return "null fetchwork";
        }
        String ret = new String("partition = ");
        for (String part : this.partDir) {
            ret = ret.concat(part);
        }
        return ret;
    }
}

