/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.objectinspector;

import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.serde2.objectinspector.ColumnarStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ReflectionStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ThriftStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.io.Text;

public final class ObjectInspectorFactory {
    private static HashMap<Type, ObjectInspector> objectInspectorCache = new HashMap();
    static HashMap<ObjectInspector, StandardListObjectInspector> cachedStandardListObjectInspector = new HashMap();
    static HashMap<List<ObjectInspector>, StandardMapObjectInspector> cachedStandardMapObjectInspector = new HashMap();
    static HashMap<ArrayList<List<?>>, StandardStructObjectInspector> cachedStandardStructObjectInspector = new HashMap();
    static HashMap<List<StructObjectInspector>, UnionStructObjectInspector> cachedUnionStructObjectInspector = new HashMap();
    static HashMap<ArrayList<Object>, ColumnarStructObjectInspector> cachedColumnarStructObjectInspector = new HashMap();

    public static ObjectInspector getReflectionObjectInspector(Type t, ObjectInspectorOptions options) {
        ObjectInspector oi = objectInspectorCache.get(t);
        if (oi == null) {
            oi = ObjectInspectorFactory.getReflectionObjectInspectorNoCache(t, options);
            objectInspectorCache.put(t, oi);
        }
        if (options.equals((Object)ObjectInspectorOptions.JAVA) && oi.getClass().equals(ThriftStructObjectInspector.class) || options.equals((Object)ObjectInspectorOptions.THRIFT) && oi.getClass().equals(ReflectionStructObjectInspector.class)) {
            throw new RuntimeException("Cannot call getObjectInspectorByReflection with both JAVA and THRIFT !");
        }
        return oi;
    }

    private static ObjectInspector getReflectionObjectInspectorNoCache(Type t, ObjectInspectorOptions options) {
        ReflectionStructObjectInspector oi;
        if (t instanceof GenericArrayType) {
            GenericArrayType at = (GenericArrayType)t;
            return ObjectInspectorFactory.getStandardListObjectInspector(ObjectInspectorFactory.getReflectionObjectInspector(at.getGenericComponentType(), options));
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            if (List.class.isAssignableFrom((Class)pt.getRawType())) {
                return ObjectInspectorFactory.getStandardListObjectInspector(ObjectInspectorFactory.getReflectionObjectInspector(pt.getActualTypeArguments()[0], options));
            }
            if (Map.class.isAssignableFrom((Class)pt.getRawType())) {
                return ObjectInspectorFactory.getStandardMapObjectInspector(ObjectInspectorFactory.getReflectionObjectInspector(pt.getActualTypeArguments()[0], options), ObjectInspectorFactory.getReflectionObjectInspector(pt.getActualTypeArguments()[1], options));
            }
            t = pt.getRawType();
        }
        if (!(t instanceof Class)) {
            throw new RuntimeException(ObjectInspectorFactory.class.getName() + " internal error:" + t);
        }
        Class c = (Class)t;
        if (PrimitiveObjectInspectorUtils.isPrimitiveJavaType(c)) {
            return PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector(PrimitiveObjectInspectorUtils.getTypeEntryFromPrimitiveJavaType(c).primitiveCategory);
        }
        if (PrimitiveObjectInspectorUtils.isPrimitiveJavaClass(c)) {
            return PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector(PrimitiveObjectInspectorUtils.getTypeEntryFromPrimitiveJavaClass(c).primitiveCategory);
        }
        if (PrimitiveObjectInspectorUtils.isPrimitiveWritableClass(c)) {
            return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(PrimitiveObjectInspectorUtils.getTypeEntryFromPrimitiveWritableClass(c).primitiveCategory);
        }
        assert (!List.class.isAssignableFrom(c));
        assert (!Map.class.isAssignableFrom(c));
        switch (options) {
            case JAVA: {
                oi = new ReflectionStructObjectInspector();
                break;
            }
            case THRIFT: {
                oi = new ThriftStructObjectInspector();
                break;
            }
            default: {
                throw new RuntimeException(ObjectInspectorFactory.class.getName() + ": internal error.");
            }
        }
        objectInspectorCache.put(t, oi);
        Field[] fields = ObjectInspectorUtils.getDeclaredNonStaticFields(c);
        ArrayList<ObjectInspector> structFieldObjectInspectors = new ArrayList<ObjectInspector>(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            if (oi.shouldIgnoreField(fields[i].getName())) continue;
            structFieldObjectInspectors.add(ObjectInspectorFactory.getReflectionObjectInspector(fields[i].getGenericType(), options));
        }
        oi.init(c, structFieldObjectInspectors);
        return oi;
    }

    public static StandardListObjectInspector getStandardListObjectInspector(ObjectInspector listElementObjectInspector) {
        StandardListObjectInspector result = cachedStandardListObjectInspector.get(listElementObjectInspector);
        if (result == null) {
            result = new StandardListObjectInspector(listElementObjectInspector);
            cachedStandardListObjectInspector.put(listElementObjectInspector, result);
        }
        return result;
    }

    public static StandardMapObjectInspector getStandardMapObjectInspector(ObjectInspector mapKeyObjectInspector, ObjectInspector mapValueObjectInspector) {
        ArrayList<ObjectInspector> signature = new ArrayList<ObjectInspector>(2);
        signature.add(mapKeyObjectInspector);
        signature.add(mapValueObjectInspector);
        StandardMapObjectInspector result = cachedStandardMapObjectInspector.get(signature);
        if (result == null) {
            result = new StandardMapObjectInspector(mapKeyObjectInspector, mapValueObjectInspector);
            cachedStandardMapObjectInspector.put(signature, result);
        }
        return result;
    }

    public static StandardStructObjectInspector getStandardStructObjectInspector(List<String> structFieldNames, List<ObjectInspector> structFieldObjectInspectors) {
        ArrayList<List<Object>> signature = new ArrayList<List<Object>>();
        signature.add(structFieldNames);
        signature.add(structFieldObjectInspectors);
        StandardStructObjectInspector result = cachedStandardStructObjectInspector.get(signature);
        if (result == null) {
            result = new StandardStructObjectInspector(structFieldNames, structFieldObjectInspectors);
            cachedStandardStructObjectInspector.put(signature, result);
        }
        return result;
    }

    public static UnionStructObjectInspector getUnionStructObjectInspector(List<StructObjectInspector> structObjectInspectors) {
        UnionStructObjectInspector result = cachedUnionStructObjectInspector.get(structObjectInspectors);
        if (result == null) {
            result = new UnionStructObjectInspector(structObjectInspectors);
            cachedUnionStructObjectInspector.put(structObjectInspectors, result);
        }
        return result;
    }

    public static ColumnarStructObjectInspector getColumnarStructObjectInspector(List<String> structFieldNames, List<ObjectInspector> structFieldObjectInspectors, Text nullSequence) {
        ArrayList<Object> signature = new ArrayList<Object>();
        signature.add(structFieldNames);
        signature.add(structFieldObjectInspectors);
        signature.add(nullSequence.toString());
        ColumnarStructObjectInspector result = cachedColumnarStructObjectInspector.get(signature);
        if (result == null) {
            result = new ColumnarStructObjectInspector(structFieldNames, structFieldObjectInspectors, nullSequence);
            cachedColumnarStructObjectInspector.put(signature, result);
        }
        return result;
    }

    private ObjectInspectorFactory() {
    }

    public static enum ObjectInspectorOptions {
        JAVA,
        THRIFT;

    }
}

