/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.aspectj.apache.bcel.classfile.Utility;
import org.aspectj.apache.bcel.generic.Instruction;
import org.aspectj.apache.bcel.generic.InstructionTargeter;

public class InstructionHandle
implements Serializable {
    InstructionHandle next;
    InstructionHandle prev;
    Instruction instruction;
    protected int i_position = -1;
    private HashSet targeters;

    public final InstructionHandle getNext() {
        return this.next;
    }

    public final InstructionHandle getPrev() {
        return this.prev;
    }

    public final Instruction getInstruction() {
        return this.instruction;
    }

    public void setInstruction(Instruction i) {
        if (this.instruction != null) {
            this.instruction.dispose();
        }
        this.instruction = i;
    }

    protected InstructionHandle(Instruction i) {
        this.setInstruction(i);
    }

    static final InstructionHandle getInstructionHandle(Instruction i) {
        return new InstructionHandle(i);
    }

    protected int updatePosition(int offset, int max_offset) {
        this.i_position += offset;
        return 0;
    }

    public int getPosition() {
        return this.i_position;
    }

    void setPosition(int pos) {
        this.i_position = pos;
    }

    void dispose() {
        this.prev = null;
        this.next = null;
        this.instruction.dispose();
        this.instruction = null;
        this.i_position = -1;
        this.removeAllTargeters();
    }

    public void removeAllTargeters() {
        if (this.targeters != null) {
            this.targeters.clear();
        }
    }

    public void removeTargeter(InstructionTargeter t) {
        this.targeters.remove(t);
    }

    public void addTargeter(InstructionTargeter t) {
        if (this.targeters == null) {
            this.targeters = new HashSet();
        }
        this.targeters.add(t);
    }

    public boolean hasTargeters() {
        return this.targeters != null && this.targeters.size() > 0;
    }

    public InstructionTargeter[] getTargetersArray() {
        if (!this.hasTargeters()) {
            return null;
        }
        InstructionTargeter[] t = new InstructionTargeter[this.targeters.size()];
        ((AbstractCollection)this.targeters).toArray(t);
        return t;
    }

    public Set getTargeters() {
        if (this.targeters == null || this.targeters.size() == 0) {
            return Collections.EMPTY_SET;
        }
        return this.targeters;
    }

    public String toString(boolean verbose) {
        return String.valueOf(Utility.format(this.i_position, 4, false, ' ')) + ": " + this.instruction.toString(verbose);
    }

    public String toString() {
        return this.toString(true);
    }
}

