/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic;

import java.util.ArrayList;
import java.util.List;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.Modifiers;
import org.aspectj.apache.bcel.classfile.Utility;
import org.aspectj.apache.bcel.classfile.annotation.AnnotationGen;
import org.aspectj.apache.bcel.generic.Type;

public abstract class FieldGenOrMethodGen
extends Modifiers
implements Cloneable {
    protected String name;
    protected Type type;
    protected ConstantPool cp;
    private ArrayList attributeList = new ArrayList();
    private ArrayList annotationList = new ArrayList();

    protected FieldGenOrMethodGen() {
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ConstantPool getConstantPool() {
        return this.cp;
    }

    public void setConstantPool(ConstantPool cp) {
        this.cp = cp;
    }

    public void addAttribute(Attribute a) {
        this.attributeList.add(a);
    }

    public void removeAttribute(Attribute a) {
        this.attributeList.remove(a);
    }

    public void removeAttributes() {
        this.attributeList.clear();
    }

    public void addAnnotation(AnnotationGen ag) {
        this.annotationList.add(ag);
    }

    public void removeAnnotation(AnnotationGen ag) {
        this.annotationList.remove(ag);
    }

    public void removeAnnotations() {
        this.annotationList.clear();
    }

    public List getAttributes() {
        return this.attributeList;
    }

    public Attribute[] getAttributesImmutable() {
        Attribute[] attributes = new Attribute[this.attributeList.size()];
        this.attributeList.toArray(attributes);
        return attributes;
    }

    protected void addAnnotationsAsAttribute(ConstantPool cp) {
        Attribute[] attrs = Utility.getAnnotationAttributes(cp, this.annotationList);
        if (attrs != null) {
            int i = 0;
            while (i < attrs.length) {
                this.addAttribute(attrs[i]);
                ++i;
            }
        }
    }

    public AnnotationGen[] getAnnotations() {
        AnnotationGen[] annotations = new AnnotationGen[this.annotationList.size()];
        this.annotationList.toArray(annotations);
        return annotations;
    }

    public abstract String getSignature();

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println(e);
            return null;
        }
    }
}

