/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.storage.allloader;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.pig.FuncSpec;
import org.apache.pig.impl.logicalLayer.FrontendException;

public class LoadFuncHelper {
    public static final String FILE_EXTENSION_LOADERS = "file.extension.loaders";
    private static Map<MagicNumber, String> magicNumberExtensionMap = LoadFuncHelper.buildMagicNumberExtensionMap();
    Configuration conf;
    FileSystem fileSystem;
    Map<String, String> loadFunctionExtensionTagMap;
    Map<String, Set<String>> extensionTagsMap;

    public LoadFuncHelper(Configuration conf) throws IOException {
        this.conf = conf;
        this.fileSystem = FileSystem.get((Configuration)conf);
        this.loadFunctionExtensionTagMap = new HashMap<String, String>();
        this.extensionTagsMap = new HashMap<String, Set<String>>();
        String fileExtensionLoaders = conf.get(FILE_EXTENSION_LOADERS);
        if (fileExtensionLoaders != null) {
            String[] loaderExtensionPairs;
            for (String loaderExtensionPairStr : loaderExtensionPairs = fileExtensionLoaders.split("\\),")) {
                String[] loaderExtensionPair = loaderExtensionPairStr.split(":");
                if (loaderExtensionPair.length == 2) {
                    this.loadFunctionExtensionTagMap.put(loaderExtensionPair[0].trim() + ":", loaderExtensionPair[1].trim());
                    continue;
                }
                if (loaderExtensionPair.length == 3 || loaderExtensionPair.length == 4) {
                    String ext = loaderExtensionPair[0].trim();
                    String tag = loaderExtensionPair[1].trim();
                    String key = ext + ":" + tag;
                    String loadFunc = loaderExtensionPair[2].trim();
                    if (loaderExtensionPair.length == 4) {
                        key = key + ":" + loadFunc;
                        loadFunc = loaderExtensionPair[3].trim();
                    }
                    this.loadFunctionExtensionTagMap.put(key, loadFunc);
                    Set<String> tags = this.extensionTagsMap.get(ext);
                    if (tags == null) {
                        tags = new TreeSet<String>();
                        this.extensionTagsMap.put(ext, tags);
                    }
                    tags.add(tag);
                    continue;
                }
                throw new FrontendException("Bad formatted file.extension.loaders string, format is <extension>:<loader>,<extenion><loader>");
            }
        }
    }

    private static Map<MagicNumber, String> buildMagicNumberExtensionMap() {
        HashMap<MagicNumber, String> magicNumberExtensionMap = new HashMap<MagicNumber, String>();
        magicNumberExtensionMap.put(new MagicNumber(new byte[]{83, 69, 81}), "seq");
        magicNumberExtensionMap.put(new MagicNumber(new byte[]{-119, 76, 90}), "lzo");
        magicNumberExtensionMap.put(new MagicNumber(new byte[]{31, -117, 8}), "gz");
        magicNumberExtensionMap.put(new MagicNumber(new byte[]{66, 90, 104}), "bz2");
        return magicNumberExtensionMap;
    }

    public Path determineFirstFile(String location) throws IOException {
        Path path = new Path(location);
        FileStatus status = this.fileSystem.getFileStatus(path);
        if (status.isDir() && (path = LoadFuncHelper.getFirstFile(this.fileSystem, path)) == null) {
            throw new FrontendException(path + " has no files");
        }
        return path;
    }

    public FuncSpec determineFunction(String location) throws IOException {
        return this.determineFunction(location, this.determineFirstFile(location));
    }

    public FuncSpec determineFunction(String location, Path path) throws IOException {
        String fileName = path.getName();
        FuncSpec funcSpec = this.getLoadPerExtension(fileName, path);
        if (funcSpec == null) {
            funcSpec = this.getFuncSpecFromContent(path);
        }
        return funcSpec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FuncSpec getFuncSpecFromContent(Path path) throws IOException {
        FSDataInputStream dataIn = null;
        byte[] magic = new byte[3];
        int read = -1;
        try {
            dataIn = this.fileSystem.open(path, 3);
            read = dataIn.read(magic);
        }
        finally {
            dataIn.close();
        }
        FuncSpec funcSpec = null;
        String extensionMapping = magicNumberExtensionMap.get(new MagicNumber(magic));
        if (read < magic.length || extensionMapping == null) {
            funcSpec = new FuncSpec("PigStorage()");
        } else {
            String applicableTag = this.getApplicableTag(extensionMapping, path);
            String loadFuncDefinition = null;
            if (extensionMapping.equals("seq")) {
                loadFuncDefinition = this.loadFunctionExtensionTagMap.get(extensionMapping + ":" + applicableTag + ":" + this.getSequenceFileKeyClass(path));
            }
            if (loadFuncDefinition == null) {
                loadFuncDefinition = this.loadFunctionExtensionTagMap.get(extensionMapping + ":" + applicableTag);
            }
            if (loadFuncDefinition == null) {
                throw new RuntimeException("Cannot find loader for " + path + " extension mapping " + extensionMapping);
            }
            funcSpec = new FuncSpec(loadFuncDefinition);
        }
        return funcSpec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSequenceFileKeyClass(Path path) throws IOException {
        String keyClassName = null;
        SequenceFile.Reader reader = new SequenceFile.Reader(this.fileSystem, path, this.conf);
        try {
            keyClassName = reader.getKeyClassName();
            int index = keyClassName.indexOf("$");
            if (index > 0) {
                keyClassName = keyClassName.substring(0, index);
            }
        }
        finally {
            reader.close();
        }
        return keyClassName;
    }

    private FuncSpec getLoadPerExtension(String fileName, Path path) {
        String extension = null;
        String applicableTag = null;
        String loadFuncDefinition = null;
        FuncSpec funcSpec = null;
        while (fileName != null && (extension = LoadFuncHelper.getExtension(fileName)) != null && (applicableTag = this.getApplicableTag(extension, path)) != null) {
            loadFuncDefinition = this.loadFunctionExtensionTagMap.get(extension + ":" + applicableTag);
            if (loadFuncDefinition != null) {
                funcSpec = new FuncSpec(loadFuncDefinition);
                break;
            }
            fileName = LoadFuncHelper.cutExtension(fileName);
        }
        return funcSpec;
    }

    private String getApplicableTag(String extension, Path path) {
        Set<String> tags = this.extensionTagsMap.get(extension);
        String applicableTag = null;
        if (tags != null) {
            String fullPathName = path.toUri().toString();
            for (String tag : tags) {
                if (!fullPathName.contains(tag)) continue;
                applicableTag = tag;
                break;
            }
        } else {
            applicableTag = "";
        }
        return applicableTag;
    }

    private static String cutExtension(String fileName) {
        String name = null;
        int index = fileName.lastIndexOf(46);
        if (index > 0 && index < fileName.length()) {
            name = fileName.substring(0, index);
        }
        return name;
    }

    private static String getExtension(String fileName) {
        String extension = null;
        int index = fileName.lastIndexOf(46);
        int pos = index + 1;
        if (index > 0 && pos < fileName.length()) {
            extension = fileName.substring(pos, fileName.length());
        }
        return extension;
    }

    private static Path getFirstFile(FileSystem fileSystem, Path path) throws IOException {
        Path currentPath = path;
        Path file = null;
        Object[] paths = fileSystem.listStatus(currentPath);
        Arrays.sort(paths);
        for (Object subPathStatus : paths) {
            currentPath = subPathStatus.getPath();
            if (currentPath.getName().startsWith(".") || currentPath.getName().startsWith("_")) continue;
            if (subPathStatus.isDir()) {
                file = LoadFuncHelper.getFirstFile(fileSystem, currentPath);
                continue;
            }
            file = currentPath;
            break;
        }
        return file;
    }

    static class MagicNumber {
        byte[] magic;

        public MagicNumber(byte[] magic) {
            this.magic = magic;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.magic);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MagicNumber other = (MagicNumber)obj;
            return Arrays.equals(this.magic, other.magic);
        }
    }
}

