/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.description;
import org.apache.hadoop.io.Text;

@description(name="unhex", value="_FUNC_(str) - Converts hexadecimal argument to string", extended="Performs the inverse operation of HEX(str). That is, it interprets\neach pair of hexadecimal digits in the argument as a number and\nconverts it to the character represented by the number. The\nresulting characters are returned as a binary string.\n\nExample:\n> SELECT UNHEX('4D7953514C') from src limit 1;\n'MySQL'\n> SELECT UNHEX(HEX('string')) from src limit 1;\n'string'\n> SELECT HEX(UNHEX('1267')) from src limit 1;\n'1267'\n\nThe characters in the argument string must be legal hexadecimal\ndigits: '0' .. '9', 'A' .. 'F', 'a' .. 'f'. If UNHEX() encounters\nany nonhexadecimal digits in the argument, it returns NULL. Also,\nif there are an odd number of characters a leading 0 is appended.")
public class UDFUnhex
extends UDF {
    public Text evaluate(Text s) {
        if (s == null) {
            return null;
        }
        String str = s.getLength() % 2 == 1 ? "0" + s.toString() : s.toString();
        byte[] result = new byte[str.length() / 2];
        for (int i = 0; i < str.length(); i += 2) {
            try {
                result[i / 2] = (byte)Integer.parseInt(str.substring(i, i + 2), 16);
                continue;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return new Text(result);
    }
}

