/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.transport;

import java.io.ByteArrayInputStream;
import org.apache.thrift.TByteArrayOutputStream;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;

public class TFramedTransport
extends TTransport {
    private TTransport transport_ = null;
    private final TByteArrayOutputStream writeBuffer_ = new TByteArrayOutputStream(1024);
    private ByteArrayInputStream readBuffer_ = null;

    public TFramedTransport(TTransport transport) {
        this.transport_ = transport;
    }

    public void open() throws TTransportException {
        this.transport_.open();
    }

    public boolean isOpen() {
        return this.transport_.isOpen();
    }

    public void close() {
        this.transport_.close();
    }

    public int read(byte[] buf, int off, int len) throws TTransportException {
        int got;
        if (this.readBuffer_ != null && (got = this.readBuffer_.read(buf, off, len)) > 0) {
            return got;
        }
        this.readFrame();
        return this.readBuffer_.read(buf, off, len);
    }

    private void readFrame() throws TTransportException {
        byte[] i32rd = new byte[4];
        this.transport_.readAll(i32rd, 0, 4);
        int size = (i32rd[0] & 0xFF) << 24 | (i32rd[1] & 0xFF) << 16 | (i32rd[2] & 0xFF) << 8 | i32rd[3] & 0xFF;
        if (size < 0) {
            throw new TTransportException("Read a negative frame size (" + size + ")!");
        }
        byte[] buff = new byte[size];
        this.transport_.readAll(buff, 0, size);
        this.readBuffer_ = new ByteArrayInputStream(buff);
    }

    public void write(byte[] buf, int off, int len) throws TTransportException {
        this.writeBuffer_.write(buf, off, len);
    }

    public void flush() throws TTransportException {
        byte[] buf = this.writeBuffer_.get();
        int len = this.writeBuffer_.len();
        this.writeBuffer_.reset();
        byte[] i32out = new byte[]{(byte)(0xFF & len >> 24), (byte)(0xFF & len >> 16), (byte)(0xFF & len >> 8), (byte)(0xFF & len)};
        this.transport_.write(i32out, 0, 4);
        this.transport_.write(buf, 0, len);
        this.transport_.flush();
    }

    public static class Factory
    extends TTransportFactory {
        public TTransport getTransport(TTransport base) {
            return new TFramedTransport(base);
        }
    }
}

