/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import java.io.IOException;
import java.net.URI;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HiveSequenceFileOutputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.MetadataTypedColumnsetSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.util.StringUtils;
import org.apache.thrift.TException;

public class Hive {
    private static final Log LOG = LogFactory.getLog((String)"hive.ql.metadata.Hive");
    private HiveConf conf = null;
    private IMetaStoreClient metaStoreClient;
    private static ThreadLocal<Hive> hiveDB = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return null;
        }

        @Override
        public synchronized void remove() {
            if (this.get() != null) {
                ((Hive)this.get()).close();
            }
            super.remove();
        }
    };

    public static Hive get(HiveConf c) throws HiveException {
        boolean needsRefresh = false;
        Hive db = hiveDB.get();
        if (db != null) {
            for (HiveConf.ConfVars oneVar : HiveConf.metaVars) {
                String newVar;
                String oldVar = db.getConf().getVar(oneVar);
                if (oldVar.compareToIgnoreCase(newVar = c.getVar(oneVar)) == 0) continue;
                needsRefresh = true;
                break;
            }
        }
        return Hive.get(c, needsRefresh);
    }

    public static Hive get(HiveConf c, boolean needsRefresh) throws HiveException {
        Hive db = hiveDB.get();
        if (db == null || needsRefresh) {
            Hive.closeCurrent();
            c.set("fs.scheme.class", "dfs");
            db = new Hive(c);
            hiveDB.set(db);
        }
        return db;
    }

    public static Hive get() throws HiveException {
        Hive db = hiveDB.get();
        if (db == null) {
            db = new Hive(new HiveConf(Hive.class));
            hiveDB.set(db);
        }
        return db;
    }

    public static void closeCurrent() {
        hiveDB.remove();
    }

    private Hive(HiveConf c) throws HiveException {
        this.conf = c;
    }

    private void close() {
        LOG.info((Object)"Closing current thread's connection to Hive Metastore.");
        if (this.metaStoreClient != null) {
            this.metaStoreClient.close();
        }
    }

    public void createTable(String tableName, List<String> columns, List<String> partCols, Class<? extends InputFormat> fileInputFormat, Class<?> fileOutputFormat) throws HiveException {
        this.createTable(tableName, columns, partCols, fileInputFormat, fileOutputFormat, -1, null);
    }

    public void createTable(String tableName, List<String> columns, List<String> partCols, Class<? extends InputFormat> fileInputFormat, Class<?> fileOutputFormat, int bucketCount, List<String> bucketCols) throws HiveException {
        if (columns == null) {
            throw new HiveException("columns not specified for table " + tableName);
        }
        Table tbl = new Table(tableName);
        tbl.setInputFormatClass(fileInputFormat.getName());
        tbl.setOutputFormatClass(fileOutputFormat.getName());
        for (String col : columns) {
            FieldSchema field = new FieldSchema(col, "string", "default");
            tbl.getCols().add(field);
        }
        if (partCols != null) {
            for (String partCol : partCols) {
                FieldSchema part = new FieldSchema();
                part.setName(partCol);
                part.setType("string");
                tbl.getPartCols().add(part);
            }
        }
        tbl.setSerializationLib(LazySimpleSerDe.class.getName());
        tbl.setNumBuckets(bucketCount);
        tbl.setBucketCols(bucketCols);
        this.createTable(tbl);
    }

    public void alterTable(String tblName, Table newTbl) throws InvalidOperationException, HiveException {
        try {
            this.getMSC().alter_table("default", tblName, newTbl.getTTable());
        }
        catch (MetaException e) {
            throw new HiveException("Unable to alter table.", e);
        }
        catch (TException e) {
            throw new HiveException("Unable to alter table.", e);
        }
    }

    public void alterPartition(String tblName, Partition newPart) throws InvalidOperationException, HiveException {
        try {
            this.getMSC().alter_partition("default", tblName, newPart.getTPartition());
        }
        catch (MetaException e) {
            throw new HiveException("Unable to alter partition.", e);
        }
        catch (TException e) {
            throw new HiveException("Unable to alter partition.", e);
        }
    }

    public void createTable(Table tbl) throws HiveException {
        this.createTable(tbl, false);
    }

    public void createTable(Table tbl, boolean ifNotExists) throws HiveException {
        try {
            tbl.initSerDe();
            if (tbl.getCols().size() == 0) {
                tbl.setFields(MetaStoreUtils.getFieldsFromDeserializer((String)tbl.getName(), (Deserializer)tbl.getDeserializer()));
            }
            tbl.checkValidity();
            this.getMSC().createTable(tbl.getTTable());
        }
        catch (AlreadyExistsException e) {
            if (!ifNotExists) {
                throw new HiveException(e);
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void dropTable(String dbName, String tableName) throws HiveException {
        this.dropTable(dbName, tableName, true, true);
    }

    public void dropTable(String dbName, String tableName, boolean deleteData, boolean ignoreUnknownTab) throws HiveException {
        try {
            this.getMSC().dropTable(dbName, tableName, deleteData, ignoreUnknownTab);
        }
        catch (NoSuchObjectException e) {
            if (!ignoreUnknownTab) {
                throw new HiveException(e);
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public HiveConf getConf() {
        return this.conf;
    }

    public Table getTable(String dbName, String tableName) throws HiveException {
        return this.getTable(dbName, tableName, true);
    }

    public Table getTable(String dbName, String tableName, boolean throwException) throws HiveException {
        char[] b;
        if (tableName == null || tableName.equals("")) {
            throw new HiveException("empty table creation??");
        }
        Table table = new Table();
        org.apache.hadoop.hive.metastore.api.Table tTable = null;
        try {
            tTable = this.getMSC().getTable(dbName, tableName);
        }
        catch (NoSuchObjectException e) {
            if (throwException) {
                LOG.error((Object)StringUtils.stringifyException((Throwable)e));
                throw new InvalidTableException("Table not found ", tableName);
            }
            return null;
        }
        catch (Exception e) {
            throw new HiveException("Unable to fetch table " + tableName, e);
        }
        assert (tTable != null);
        try {
            if (tTable.getSd().getSerdeInfo().getSerializationLib().equals(MetadataTypedColumnsetSerDe.class.getName()) && tTable.getSd().getColsSize() > 0 && ((FieldSchema)tTable.getSd().getCols().get(0)).getType().indexOf(60) == -1) {
                tTable.getSd().getSerdeInfo().setSerializationLib(LazySimpleSerDe.class.getName());
            }
            Properties p = MetaStoreUtils.getSchema((org.apache.hadoop.hive.metastore.api.Table)tTable);
            table.setSchema(p);
            table.setTTable(tTable);
            table.setInputFormatClass(Class.forName(table.getSchema().getProperty("file.inputformat", SequenceFileInputFormat.class.getName()), true, JavaUtils.getClassLoader()));
            table.setOutputFormatClass(Class.forName(table.getSchema().getProperty("file.outputformat", HiveSequenceFileOutputFormat.class.getName()), true, JavaUtils.getClassLoader()));
            table.setDeserializer(MetaStoreUtils.getDeserializer((Configuration)this.getConf(), (Properties)p));
            table.setDataLocation(new URI(tTable.getSd().getLocation()));
        }
        catch (Exception e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        String sf = table.getSerdeParam("serialization.format");
        if (sf != null && (b = sf.toCharArray()).length == 1 && b[0] < '\n') {
            table.setSerdeParam("serialization.format", Integer.toString(b[0]));
        }
        table.checkValidity();
        return table;
    }

    public List<String> getAllTables() throws HiveException {
        return this.getTablesByPattern(".*");
    }

    public List<String> getTablesByPattern(String tablePattern) throws HiveException {
        return this.getTablesForDb("default", tablePattern);
    }

    public List<String> getTablesForDb(String database, String tablePattern) throws HiveException {
        try {
            return this.getMSC().getTables(database, tablePattern);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    protected boolean createDatabase(String name, String locationUri) throws AlreadyExistsException, MetaException, TException {
        return this.getMSC().createDatabase(name, locationUri);
    }

    protected boolean dropDatabase(String name) throws MetaException, TException {
        return this.getMSC().dropDatabase(name);
    }

    public void loadPartition(Path loadPath, String tableName, AbstractMap<String, String> partSpec, boolean replace, Path tmpDirPath) throws HiveException {
        Table tbl = this.getTable("default", tableName);
        try {
            Path partPath;
            FileSystem fs;
            Partition part = this.getPartition(tbl, partSpec, false);
            if (part == null) {
                fs = FileSystem.get((URI)tbl.getDataLocation(), (Configuration)this.getConf());
                partPath = new Path(tbl.getDataLocation().getPath(), Warehouse.makePartName(partSpec));
            } else {
                partPath = part.getPath()[0];
                fs = partPath.getFileSystem((Configuration)this.getConf());
            }
            if (replace) {
                Hive.replaceFiles(loadPath, partPath, fs, tmpDirPath);
            } else {
                Hive.copyFiles(loadPath, partPath, fs);
            }
            if (part == null) {
                part = this.getPartition(tbl, partSpec, true);
            }
        }
        catch (IOException e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        catch (MetaException e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public void loadTable(Path loadPath, String tableName, boolean replace, Path tmpDirPath) throws HiveException {
        Table tbl = this.getTable("default", tableName);
        if (replace) {
            tbl.replaceFiles(loadPath, tmpDirPath);
        } else {
            tbl.copyFiles(loadPath);
        }
    }

    public Partition createPartition(Table tbl, Map<String, String> partSpec) throws HiveException {
        return this.createPartition(tbl, partSpec, null);
    }

    public Partition createPartition(Table tbl, Map<String, String> partSpec, Path location) throws HiveException {
        org.apache.hadoop.hive.metastore.api.Partition partition = null;
        for (FieldSchema field : tbl.getPartCols()) {
            String val = partSpec.get(field.getName());
            if (val != null && val.length() != 0) continue;
            throw new HiveException("add partition: Value for key " + field.getName() + " is null or empty");
        }
        try {
            Partition tmpPart = new Partition(tbl, partSpec, location);
            partition = this.getMSC().add_partition(tmpPart.getTPartition());
        }
        catch (Exception e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        return new Partition(tbl, partition);
    }

    public Partition getPartition(Table tbl, Map<String, String> partSpec, boolean forceCreate) throws HiveException {
        if (!tbl.isValidSpec(partSpec)) {
            throw new HiveException("Invalid partition: " + partSpec);
        }
        ArrayList<String> pvals = new ArrayList<String>();
        for (FieldSchema field : tbl.getPartCols()) {
            String val = partSpec.get(field.getName());
            if (val == null || val.length() == 0) {
                throw new HiveException("get partition: Value for key " + field.getName() + " is null or empty");
            }
            pvals.add(val);
        }
        org.apache.hadoop.hive.metastore.api.Partition tpart = null;
        try {
            tpart = this.getMSC().getPartition(tbl.getDbName(), tbl.getName(), pvals);
            if (tpart == null && forceCreate) {
                LOG.debug((Object)("creating partition for table " + tbl.getName() + " with partition spec : " + partSpec));
                tpart = this.getMSC().appendPartition(tbl.getDbName(), tbl.getName(), pvals);
            }
            if (tpart == null) {
                return null;
            }
        }
        catch (Exception e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        return new Partition(tbl, tpart);
    }

    public boolean dropPartition(String db_name, String tbl_name, List<String> part_vals, boolean deleteData) throws HiveException {
        try {
            return this.getMSC().dropPartition(db_name, tbl_name, part_vals, deleteData);
        }
        catch (NoSuchObjectException e) {
            throw new HiveException("Partition or table doesn't exist.", e);
        }
        catch (Exception e) {
            throw new HiveException("Unknow error. Please check logs.", e);
        }
    }

    public List<String> getPartitionNames(String dbName, String tblName, short max) throws HiveException {
        List names = null;
        try {
            names = this.getMSC().listPartitionNames(dbName, tblName, max);
        }
        catch (Exception e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        return names;
    }

    public List<Partition> getPartitions(Table tbl) throws HiveException {
        if (tbl.isPartitioned()) {
            List tParts;
            try {
                tParts = this.getMSC().listPartitions(tbl.getDbName(), tbl.getName(), (short)-1);
            }
            catch (Exception e) {
                LOG.error((Object)StringUtils.stringifyException((Throwable)e));
                throw new HiveException(e);
            }
            ArrayList<Partition> parts = new ArrayList<Partition>(tParts.size());
            for (org.apache.hadoop.hive.metastore.api.Partition tpart : tParts) {
                parts.add(new Partition(tbl, tpart));
            }
            return parts;
        }
        org.apache.hadoop.hive.metastore.api.Partition tPart = new org.apache.hadoop.hive.metastore.api.Partition();
        tPart.setSd(tbl.getTTable().getSd());
        Partition part = new Partition(tbl, tPart);
        ArrayList<Partition> parts = new ArrayList<Partition>(1);
        parts.add(part);
        return parts;
    }

    private static void checkPaths(FileSystem fs, FileStatus[] srcs, Path destf, boolean replace) throws HiveException {
        try {
            for (int i = 0; i < srcs.length; ++i) {
                FileStatus[] items = fs.listStatus(srcs[i].getPath());
                for (int j = 0; j < items.length; ++j) {
                    if (Utilities.isTempPath(items[j])) {
                        fs.delete(items[j].getPath(), true);
                        continue;
                    }
                    if (items[j].isDir()) {
                        throw new HiveException("checkPaths: " + srcs[i].toString() + " has nested directory" + items[j].toString());
                    }
                    Path tmpDest = new Path(destf, items[j].getPath().getName());
                    if (replace || !fs.exists(tmpDest)) continue;
                    throw new HiveException("checkPaths: " + tmpDest + " already exists");
                }
            }
        }
        catch (IOException e) {
            throw new HiveException("checkPaths: filesystem error in check phase", e);
        }
    }

    protected static void copyFiles(Path srcf, Path destf, FileSystem fs) throws HiveException {
        FileStatus[] srcs;
        try {
            if (!fs.exists(destf)) {
                fs.mkdirs(destf);
            }
        }
        catch (IOException e) {
            throw new HiveException("copyFiles: error while checking/creating destination directory!!!", e);
        }
        try {
            srcs = fs.globStatus(srcf);
        }
        catch (IOException e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            throw new HiveException("addFiles: filesystem error in check phase", e);
        }
        if (srcs == null) {
            LOG.info((Object)("No sources specified to move: " + srcf));
            return;
        }
        Hive.checkPaths(fs, srcs, destf, false);
        try {
            for (int i = 0; i < srcs.length; ++i) {
                FileStatus[] items = fs.listStatus(srcs[i].getPath());
                for (int j = 0; j < items.length; ++j) {
                    Path target;
                    Path source = items[j].getPath();
                    if (fs.rename(source, target = new Path(destf, items[j].getPath().getName()))) continue;
                    throw new IOException("Cannot move " + source + " to " + target);
                }
            }
        }
        catch (IOException e) {
            throw new HiveException("copyFiles: error while moving files!!!", e);
        }
    }

    protected static void replaceFiles(Path srcf, Path destf, FileSystem fs, Path tmppath) throws HiveException {
        FileStatus[] srcs;
        try {
            srcs = fs.globStatus(srcf);
        }
        catch (IOException e) {
            throw new HiveException("addFiles: filesystem error in check phase", e);
        }
        if (srcs == null) {
            LOG.info((Object)("No sources specified to move: " + srcf));
            return;
        }
        Hive.checkPaths(fs, srcs, destf, true);
        try {
            fs.mkdirs(tmppath);
            for (int i = 0; i < srcs.length; ++i) {
                FileStatus[] items = fs.listStatus(srcs[i].getPath());
                for (int j = 0; j < items.length; ++j) {
                    if (fs.rename(items[j].getPath(), new Path(tmppath, items[j].getPath().getName()))) continue;
                    throw new HiveException("Error moving: " + items[j].getPath() + " into: " + tmppath);
                }
            }
            boolean b = fs.delete(destf, true);
            LOG.debug((Object)("Deleting:" + destf.toString() + ",Status:" + b));
            if (!fs.mkdirs(destf.getParent())) {
                throw new HiveException("Unable to create destination directory: " + destf.getParent().toString());
            }
            b = fs.rename(tmppath, destf);
            if (!b) {
                throw new HiveException("Unable to move results to destination directory: " + destf.getParent().toString());
            }
            LOG.debug((Object)("Renaming:" + tmppath.toString() + ",Status:" + b));
        }
        catch (IOException e) {
            throw new HiveException("replaceFiles: error while moving files!!!", e);
        }
        finally {
            try {
                fs.delete(tmppath, true);
            }
            catch (IOException e) {
                LOG.warn((Object)("Unable delete path " + tmppath), (Throwable)e);
            }
        }
    }

    private IMetaStoreClient createMetaStoreClient() throws MetaException {
        return new HiveMetaStoreClient(this.conf);
    }

    private IMetaStoreClient getMSC() throws MetaException {
        if (this.metaStoreClient == null) {
            this.metaStoreClient = this.createMetaStoreClient();
        }
        return this.metaStoreClient;
    }

    public static List<FieldSchema> getFieldsFromDeserializer(String name, Deserializer serde) throws HiveException {
        try {
            return MetaStoreUtils.getFieldsFromDeserializer((String)name, (Deserializer)serde);
        }
        catch (SerDeException e) {
            throw new HiveException("Error in getting fields from serde. " + e.getMessage(), e);
        }
        catch (MetaException e) {
            throw new HiveException("Error in getting fields from serde." + e.getMessage(), e);
        }
    }
}

