/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.plan.api.Graph;
import org.apache.hadoop.hive.ql.plan.api.Operator;
import org.apache.hadoop.hive.ql.plan.api.TaskType;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;

public class Task
implements TBase,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("Task");
    private static final TField TASK_ID_FIELD_DESC = new TField("taskId", 11, 1);
    private static final TField TASK_TYPE_FIELD_DESC = new TField("taskType", 8, 2);
    private static final TField TASK_ATTRIBUTES_FIELD_DESC = new TField("taskAttributes", 13, 3);
    private static final TField TASK_COUNTERS_FIELD_DESC = new TField("taskCounters", 13, 4);
    private static final TField OPERATOR_GRAPH_FIELD_DESC = new TField("operatorGraph", 12, 5);
    private static final TField OPERATOR_LIST_FIELD_DESC = new TField("operatorList", 15, 6);
    private static final TField DONE_FIELD_DESC = new TField("done", 2, 7);
    private static final TField STARTED_FIELD_DESC = new TField("started", 2, 8);
    private String taskId;
    public static final int TASKID = 1;
    private int taskType;
    public static final int TASKTYPE = 2;
    private Map<String, String> taskAttributes;
    public static final int TASKATTRIBUTES = 3;
    private Map<String, Long> taskCounters;
    public static final int TASKCOUNTERS = 4;
    private Graph operatorGraph;
    public static final int OPERATORGRAPH = 5;
    private List<Operator> operatorList;
    public static final int OPERATORLIST = 6;
    private boolean done;
    public static final int DONE = 7;
    private boolean started;
    public static final int STARTED = 8;
    private final Isset __isset = new Isset();
    public static final Map<Integer, FieldMetaData> metaDataMap = Collections.unmodifiableMap(new HashMap<Integer, FieldMetaData>(){
        {
            this.put(1, new FieldMetaData("taskId", 3, new FieldValueMetaData(11)));
            this.put(2, new FieldMetaData("taskType", 3, new FieldValueMetaData(8)));
            this.put(3, new FieldMetaData("taskAttributes", 3, new MapMetaData(13, new FieldValueMetaData(11), new FieldValueMetaData(11))));
            this.put(4, new FieldMetaData("taskCounters", 3, new MapMetaData(13, new FieldValueMetaData(11), new FieldValueMetaData(10))));
            this.put(5, new FieldMetaData("operatorGraph", 2, new StructMetaData(12, Graph.class)));
            this.put(6, new FieldMetaData("operatorList", 2, new ListMetaData(15, new StructMetaData(12, Operator.class))));
            this.put(7, new FieldMetaData("done", 3, new FieldValueMetaData(2)));
            this.put(8, new FieldMetaData("started", 3, new FieldValueMetaData(2)));
        }
    });

    public Task() {
    }

    public Task(String taskId, int taskType, Map<String, String> taskAttributes, Map<String, Long> taskCounters, Graph operatorGraph, List<Operator> operatorList, boolean done, boolean started) {
        this();
        this.taskId = taskId;
        this.taskType = taskType;
        this.__isset.taskType = true;
        this.taskAttributes = taskAttributes;
        this.taskCounters = taskCounters;
        this.operatorGraph = operatorGraph;
        this.operatorList = operatorList;
        this.done = done;
        this.__isset.done = true;
        this.started = started;
        this.__isset.started = true;
    }

    public Task(Task other) {
        Object other_element_value;
        String other_element_key;
        if (other.isSetTaskId()) {
            this.taskId = other.taskId;
        }
        this.__isset.taskType = other.__isset.taskType;
        this.taskType = other.taskType;
        if (other.isSetTaskAttributes()) {
            HashMap<String, String> __this__taskAttributes = new HashMap<String, String>();
            for (Map.Entry<String, Object> entry : other.taskAttributes.entrySet()) {
                other_element_key = entry.getKey();
                other_element_value = (String)entry.getValue();
                String __this__taskAttributes_copy_key = other_element_key;
                String __this__taskAttributes_copy_value = other_element_value;
                __this__taskAttributes.put(__this__taskAttributes_copy_key, __this__taskAttributes_copy_value);
            }
            this.taskAttributes = __this__taskAttributes;
        }
        if (other.isSetTaskCounters()) {
            HashMap<String, Long> __this__taskCounters = new HashMap<String, Long>();
            for (Map.Entry<String, Object> entry : other.taskCounters.entrySet()) {
                other_element_key = entry.getKey();
                other_element_value = (Long)entry.getValue();
                String __this__taskCounters_copy_key = other_element_key;
                Object __this__taskCounters_copy_value = other_element_value;
                __this__taskCounters.put(__this__taskCounters_copy_key, (Long)__this__taskCounters_copy_value);
            }
            this.taskCounters = __this__taskCounters;
        }
        if (other.isSetOperatorGraph()) {
            this.operatorGraph = new Graph(other.operatorGraph);
        }
        if (other.isSetOperatorList()) {
            ArrayList<Operator> __this__operatorList = new ArrayList<Operator>();
            for (Operator operator : other.operatorList) {
                __this__operatorList.add(new Operator(operator));
            }
            this.operatorList = __this__operatorList;
        }
        this.__isset.done = other.__isset.done;
        this.done = other.done;
        this.__isset.started = other.__isset.started;
        this.started = other.started;
    }

    public Task clone() {
        return new Task(this);
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void unsetTaskId() {
        this.taskId = null;
    }

    public boolean isSetTaskId() {
        return this.taskId != null;
    }

    public int getTaskType() {
        return this.taskType;
    }

    public void setTaskType(int taskType) {
        this.taskType = taskType;
        this.__isset.taskType = true;
    }

    public void unsetTaskType() {
        this.__isset.taskType = false;
    }

    public boolean isSetTaskType() {
        return this.__isset.taskType;
    }

    public int getTaskAttributesSize() {
        return this.taskAttributes == null ? 0 : this.taskAttributes.size();
    }

    public void putToTaskAttributes(String key, String val) {
        if (this.taskAttributes == null) {
            this.taskAttributes = new HashMap<String, String>();
        }
        this.taskAttributes.put(key, val);
    }

    public Map<String, String> getTaskAttributes() {
        return this.taskAttributes;
    }

    public void setTaskAttributes(Map<String, String> taskAttributes) {
        this.taskAttributes = taskAttributes;
    }

    public void unsetTaskAttributes() {
        this.taskAttributes = null;
    }

    public boolean isSetTaskAttributes() {
        return this.taskAttributes != null;
    }

    public int getTaskCountersSize() {
        return this.taskCounters == null ? 0 : this.taskCounters.size();
    }

    public void putToTaskCounters(String key, long val) {
        if (this.taskCounters == null) {
            this.taskCounters = new HashMap<String, Long>();
        }
        this.taskCounters.put(key, val);
    }

    public Map<String, Long> getTaskCounters() {
        return this.taskCounters;
    }

    public void setTaskCounters(Map<String, Long> taskCounters) {
        this.taskCounters = taskCounters;
    }

    public void unsetTaskCounters() {
        this.taskCounters = null;
    }

    public boolean isSetTaskCounters() {
        return this.taskCounters != null;
    }

    public Graph getOperatorGraph() {
        return this.operatorGraph;
    }

    public void setOperatorGraph(Graph operatorGraph) {
        this.operatorGraph = operatorGraph;
    }

    public void unsetOperatorGraph() {
        this.operatorGraph = null;
    }

    public boolean isSetOperatorGraph() {
        return this.operatorGraph != null;
    }

    public int getOperatorListSize() {
        return this.operatorList == null ? 0 : this.operatorList.size();
    }

    public Iterator<Operator> getOperatorListIterator() {
        return this.operatorList == null ? null : this.operatorList.iterator();
    }

    public void addToOperatorList(Operator elem) {
        if (this.operatorList == null) {
            this.operatorList = new ArrayList<Operator>();
        }
        this.operatorList.add(elem);
    }

    public List<Operator> getOperatorList() {
        return this.operatorList;
    }

    public void setOperatorList(List<Operator> operatorList) {
        this.operatorList = operatorList;
    }

    public void unsetOperatorList() {
        this.operatorList = null;
    }

    public boolean isSetOperatorList() {
        return this.operatorList != null;
    }

    public boolean isDone() {
        return this.done;
    }

    public void setDone(boolean done) {
        this.done = done;
        this.__isset.done = true;
    }

    public void unsetDone() {
        this.__isset.done = false;
    }

    public boolean isSetDone() {
        return this.__isset.done;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setStarted(boolean started) {
        this.started = started;
        this.__isset.started = true;
    }

    public void unsetStarted() {
        this.__isset.started = false;
    }

    public boolean isSetStarted() {
        return this.__isset.started;
    }

    @Override
    public void setFieldValue(int fieldID, Object value) {
        switch (fieldID) {
            case 1: {
                if (value == null) {
                    this.unsetTaskId();
                    break;
                }
                this.setTaskId((String)value);
                break;
            }
            case 2: {
                if (value == null) {
                    this.unsetTaskType();
                    break;
                }
                this.setTaskType((Integer)value);
                break;
            }
            case 3: {
                if (value == null) {
                    this.unsetTaskAttributes();
                    break;
                }
                this.setTaskAttributes((Map)value);
                break;
            }
            case 4: {
                if (value == null) {
                    this.unsetTaskCounters();
                    break;
                }
                this.setTaskCounters((Map)value);
                break;
            }
            case 5: {
                if (value == null) {
                    this.unsetOperatorGraph();
                    break;
                }
                this.setOperatorGraph((Graph)value);
                break;
            }
            case 6: {
                if (value == null) {
                    this.unsetOperatorList();
                    break;
                }
                this.setOperatorList((List)value);
                break;
            }
            case 7: {
                if (value == null) {
                    this.unsetDone();
                    break;
                }
                this.setDone((Boolean)value);
                break;
            }
            case 8: {
                if (value == null) {
                    this.unsetStarted();
                    break;
                }
                this.setStarted((Boolean)value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    @Override
    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getTaskId();
            }
            case 2: {
                return this.getTaskType();
            }
            case 3: {
                return this.getTaskAttributes();
            }
            case 4: {
                return this.getTaskCounters();
            }
            case 5: {
                return this.getOperatorGraph();
            }
            case 6: {
                return this.getOperatorList();
            }
            case 7: {
                return new Boolean(this.isDone());
            }
            case 8: {
                return new Boolean(this.isStarted());
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    @Override
    public boolean isSet(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.isSetTaskId();
            }
            case 2: {
                return this.isSetTaskType();
            }
            case 3: {
                return this.isSetTaskAttributes();
            }
            case 4: {
                return this.isSetTaskCounters();
            }
            case 5: {
                return this.isSetOperatorGraph();
            }
            case 6: {
                return this.isSetOperatorList();
            }
            case 7: {
                return this.isSetDone();
            }
            case 8: {
                return this.isSetStarted();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof Task) {
            return this.equals((Task)that);
        }
        return false;
    }

    public boolean equals(Task that) {
        if (that == null) {
            return false;
        }
        boolean this_present_taskId = this.isSetTaskId();
        boolean that_present_taskId = that.isSetTaskId();
        if (this_present_taskId || that_present_taskId) {
            if (!this_present_taskId || !that_present_taskId) {
                return false;
            }
            if (!this.taskId.equals(that.taskId)) {
                return false;
            }
        }
        boolean this_present_taskType = true;
        boolean that_present_taskType = true;
        if (this_present_taskType || that_present_taskType) {
            if (!this_present_taskType || !that_present_taskType) {
                return false;
            }
            if (this.taskType != that.taskType) {
                return false;
            }
        }
        boolean this_present_taskAttributes = this.isSetTaskAttributes();
        boolean that_present_taskAttributes = that.isSetTaskAttributes();
        if (this_present_taskAttributes || that_present_taskAttributes) {
            if (!this_present_taskAttributes || !that_present_taskAttributes) {
                return false;
            }
            if (!((Object)this.taskAttributes).equals(that.taskAttributes)) {
                return false;
            }
        }
        boolean this_present_taskCounters = this.isSetTaskCounters();
        boolean that_present_taskCounters = that.isSetTaskCounters();
        if (this_present_taskCounters || that_present_taskCounters) {
            if (!this_present_taskCounters || !that_present_taskCounters) {
                return false;
            }
            if (!((Object)this.taskCounters).equals(that.taskCounters)) {
                return false;
            }
        }
        boolean this_present_operatorGraph = this.isSetOperatorGraph();
        boolean that_present_operatorGraph = that.isSetOperatorGraph();
        if (this_present_operatorGraph || that_present_operatorGraph) {
            if (!this_present_operatorGraph || !that_present_operatorGraph) {
                return false;
            }
            if (!this.operatorGraph.equals(that.operatorGraph)) {
                return false;
            }
        }
        boolean this_present_operatorList = this.isSetOperatorList();
        boolean that_present_operatorList = that.isSetOperatorList();
        if (this_present_operatorList || that_present_operatorList) {
            if (!this_present_operatorList || !that_present_operatorList) {
                return false;
            }
            if (!((Object)this.operatorList).equals(that.operatorList)) {
                return false;
            }
        }
        boolean this_present_done = true;
        boolean that_present_done = true;
        if (this_present_done || that_present_done) {
            if (!this_present_done || !that_present_done) {
                return false;
            }
            if (this.done != that.done) {
                return false;
            }
        }
        boolean this_present_started = true;
        boolean that_present_started = true;
        if (this_present_started || that_present_started) {
            if (!this_present_started || !that_present_started) {
                return false;
            }
            if (this.started != that.started) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin();
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 11) {
                        this.taskId = iprot.readString();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 2: {
                    if (field.type == 8) {
                        this.taskType = iprot.readI32();
                        this.__isset.taskType = true;
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 3: {
                    if (field.type == 13) {
                        TMap _map22 = iprot.readMapBegin();
                        this.taskAttributes = new HashMap<String, String>(2 * _map22.size);
                        for (int _i23 = 0; _i23 < _map22.size; ++_i23) {
                            String _key24 = iprot.readString();
                            String _val25 = iprot.readString();
                            this.taskAttributes.put(_key24, _val25);
                        }
                        iprot.readMapEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 4: {
                    if (field.type == 13) {
                        TMap _map26 = iprot.readMapBegin();
                        this.taskCounters = new HashMap<String, Long>(2 * _map26.size);
                        for (int _i27 = 0; _i27 < _map26.size; ++_i27) {
                            String _key28 = iprot.readString();
                            long _val29 = iprot.readI64();
                            this.taskCounters.put(_key28, _val29);
                        }
                        iprot.readMapEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 5: {
                    if (field.type == 12) {
                        this.operatorGraph = new Graph();
                        this.operatorGraph.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 6: {
                    if (field.type == 15) {
                        TList _list30 = iprot.readListBegin();
                        this.operatorList = new ArrayList<Operator>(_list30.size);
                        for (int _i31 = 0; _i31 < _list30.size; ++_i31) {
                            Operator _elem32 = new Operator();
                            _elem32.read(iprot);
                            this.operatorList.add(_elem32);
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 7: {
                    if (field.type == 2) {
                        this.done = iprot.readBool();
                        this.__isset.done = true;
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 8: {
                    if (field.type == 2) {
                        this.started = iprot.readBool();
                        this.__isset.started = true;
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.taskId != null) {
            oprot.writeFieldBegin(TASK_ID_FIELD_DESC);
            oprot.writeString(this.taskId);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(TASK_TYPE_FIELD_DESC);
        oprot.writeI32(this.taskType);
        oprot.writeFieldEnd();
        if (this.taskAttributes != null) {
            oprot.writeFieldBegin(TASK_ATTRIBUTES_FIELD_DESC);
            oprot.writeMapBegin(new TMap(11, 11, this.taskAttributes.size()));
            for (Map.Entry<String, Object> entry : this.taskAttributes.entrySet()) {
                oprot.writeString(entry.getKey());
                oprot.writeString((String)entry.getValue());
            }
            oprot.writeMapEnd();
            oprot.writeFieldEnd();
        }
        if (this.taskCounters != null) {
            oprot.writeFieldBegin(TASK_COUNTERS_FIELD_DESC);
            oprot.writeMapBegin(new TMap(11, 10, this.taskCounters.size()));
            for (Map.Entry<String, Object> entry : this.taskCounters.entrySet()) {
                oprot.writeString(entry.getKey());
                oprot.writeI64((Long)entry.getValue());
            }
            oprot.writeMapEnd();
            oprot.writeFieldEnd();
        }
        if (this.operatorGraph != null && this.isSetOperatorGraph()) {
            oprot.writeFieldBegin(OPERATOR_GRAPH_FIELD_DESC);
            this.operatorGraph.write(oprot);
            oprot.writeFieldEnd();
        }
        if (this.operatorList != null && this.isSetOperatorList()) {
            oprot.writeFieldBegin(OPERATOR_LIST_FIELD_DESC);
            oprot.writeListBegin(new TList(12, this.operatorList.size()));
            for (Operator operator : this.operatorList) {
                operator.write(oprot);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(DONE_FIELD_DESC);
        oprot.writeBool(this.done);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(STARTED_FIELD_DESC);
        oprot.writeBool(this.started);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Task(");
        boolean first = true;
        sb.append("taskId:");
        if (this.taskId == null) {
            sb.append("null");
        } else {
            sb.append(this.taskId);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("taskType:");
        String taskType_name = TaskType.VALUES_TO_NAMES.get(this.taskType);
        if (taskType_name != null) {
            sb.append(taskType_name);
            sb.append(" (");
        }
        sb.append(this.taskType);
        if (taskType_name != null) {
            sb.append(")");
        }
        if (!(first = false)) {
            sb.append(", ");
        }
        sb.append("taskAttributes:");
        if (this.taskAttributes == null) {
            sb.append("null");
        } else {
            sb.append(this.taskAttributes);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("taskCounters:");
        if (this.taskCounters == null) {
            sb.append("null");
        } else {
            sb.append(this.taskCounters);
        }
        first = false;
        if (this.isSetOperatorGraph()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("operatorGraph:");
            if (this.operatorGraph == null) {
                sb.append("null");
            } else {
                sb.append(this.operatorGraph);
            }
            first = false;
        }
        if (this.isSetOperatorList()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("operatorList:");
            if (this.operatorList == null) {
                sb.append("null");
            } else {
                sb.append(this.operatorList);
            }
            first = false;
        }
        if (!first) {
            sb.append(", ");
        }
        sb.append("done:");
        sb.append(this.done);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("started:");
        sb.append(this.started);
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.isSetTaskType() && !TaskType.VALID_VALUES.contains(this.taskType)) {
            throw new TProtocolException("The field 'taskType' has been assigned the invalid value " + this.taskType);
        }
    }

    static {
        FieldMetaData.addStructMetaDataMap(Task.class, metaDataMap);
    }

    private static final class Isset
    implements Serializable {
        public boolean taskType = false;
        public boolean done = false;
        public boolean started = false;

        private Isset() {
        }
    }
}

