/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.exec.description;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.io.IntWritable;

@description(name="index", value="_FUNC_(a, n) - Returns the n-th element of a ")
public class GenericUDFIndex
extends GenericUDF {
    private MapObjectInspector mapOI;
    private boolean mapKeyPreferWritable;
    private ListObjectInspector listOI;
    private PrimitiveObjectInspector indexOI;
    private ObjectInspector returnOI;
    private IntWritable result = new IntWritable(-1);

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("The function INDEX accepts exactly 2 arguments.");
        }
        if (arguments[0] instanceof MapObjectInspector) {
            this.mapOI = (MapObjectInspector)arguments[0];
            this.listOI = null;
        } else if (arguments[0] instanceof ListObjectInspector) {
            this.listOI = (ListObjectInspector)arguments[0];
            this.mapOI = null;
        } else {
            throw new UDFArgumentTypeException(0, "\"" + ObjectInspector.Category.MAP.toString().toLowerCase() + "\" or \"" + ObjectInspector.Category.LIST.toString().toLowerCase() + "\" is expected at function INDEX, but \"" + arguments[0].getTypeName() + "\" is found");
        }
        if (!(arguments[1] instanceof PrimitiveObjectInspector)) {
            throw new UDFArgumentTypeException(1, "Primitive Type is expected but " + arguments[1].getTypeName() + "\" is found");
        }
        this.indexOI = (PrimitiveObjectInspector)arguments[1];
        if (this.mapOI != null) {
            this.returnOI = this.mapOI.getMapValueObjectInspector();
            ObjectInspector keyOI = this.mapOI.getMapKeyObjectInspector();
            this.mapKeyPreferWritable = ((PrimitiveObjectInspector)keyOI).preferWritable();
        } else {
            this.returnOI = this.listOI.getListElementObjectInspector();
        }
        return this.returnOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        assert (arguments.length == 2);
        Object main = arguments[0].get();
        Object index = arguments[1].get();
        if (this.mapOI != null) {
            Object indexObject = this.mapKeyPreferWritable ? this.indexOI.getPrimitiveWritableObject(index) : this.indexOI.getPrimitiveJavaObject(index);
            return this.mapOI.getMapValueElement(main, indexObject);
        }
        assert (this.listOI != null);
        int intIndex = 0;
        try {
            intIndex = PrimitiveObjectInspectorUtils.getInt(index, this.indexOI);
        }
        catch (NullPointerException e) {
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
        return this.listOI.getListElement(main, intIndex);
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length == 2);
        return children[0] + "[" + children[1] + "]";
    }
}

