/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.contrib.util.typedbytes;

import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.contrib.util.typedbytes.Type;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.record.Buffer;

public class TypedBytesOutput {
    private DataOutput out;
    private static ThreadLocal tbOut = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new TypedBytesOutput();
        }
    };

    private TypedBytesOutput() {
    }

    private void setDataOutput(DataOutput out) {
        this.out = out;
    }

    public static TypedBytesOutput get(DataOutput out) {
        TypedBytesOutput bout = (TypedBytesOutput)tbOut.get();
        bout.setDataOutput(out);
        return bout;
    }

    public TypedBytesOutput(DataOutput out) {
        this.out = out;
    }

    public void write(Object obj) throws IOException {
        if (obj instanceof Buffer) {
            this.writeBytes(((Buffer)obj).get());
        } else if (obj instanceof Byte) {
            this.writeByte((Byte)obj);
        } else if (obj instanceof Boolean) {
            this.writeBool((Boolean)obj);
        } else if (obj instanceof Integer) {
            this.writeInt((Integer)obj);
        } else if (obj instanceof Long) {
            this.writeLong((Long)obj);
        } else if (obj instanceof Float) {
            this.writeFloat(((Float)obj).floatValue());
        } else if (obj instanceof Double) {
            this.writeDouble((Double)obj);
        } else if (obj instanceof String) {
            this.writeString((String)obj);
        } else if (obj instanceof ArrayList) {
            this.writeVector((ArrayList)obj);
        } else if (obj instanceof List) {
            this.writeList((List)obj);
        } else if (obj instanceof Map) {
            this.writeMap((Map)obj);
        } else {
            throw new RuntimeException("cannot write objects of this type");
        }
    }

    public void writeRaw(byte[] bytes) throws IOException {
        this.out.write(bytes);
    }

    public void writeRaw(byte[] bytes, int offset, int length) throws IOException {
        this.out.write(bytes, offset, length);
    }

    public void writeBytes(byte[] bytes, int code) throws IOException {
        this.out.write(code);
        this.out.writeInt(bytes.length);
        this.out.write(bytes);
    }

    public void writeBytes(byte[] bytes) throws IOException {
        this.writeBytes(bytes, Type.BYTES.code);
    }

    public void writeByte(byte b) throws IOException {
        this.out.write(Type.BYTE.code);
        this.out.write(b);
    }

    public void writeBool(boolean b) throws IOException {
        this.out.write(Type.BOOL.code);
        this.out.writeBoolean(b);
    }

    public void writeInt(int i) throws IOException {
        this.out.write(Type.INT.code);
        this.out.writeInt(i);
    }

    public void writeLong(long l) throws IOException {
        this.out.write(Type.LONG.code);
        this.out.writeLong(l);
    }

    public void writeFloat(float f) throws IOException {
        this.out.write(Type.FLOAT.code);
        this.out.writeFloat(f);
    }

    public void writeDouble(double d) throws IOException {
        this.out.write(Type.DOUBLE.code);
        this.out.writeDouble(d);
    }

    public void writeShort(short s) throws IOException {
        this.out.write(Type.SHORT.code);
        this.out.writeShort(s);
    }

    public void writeString(String s) throws IOException {
        this.out.write(Type.STRING.code);
        WritableUtils.writeString((DataOutput)this.out, (String)s);
    }

    public void writeVector(ArrayList vector) throws IOException {
        this.writeVectorHeader(vector.size());
        for (Object obj : vector) {
            this.write(obj);
        }
    }

    public void writeVectorHeader(int length) throws IOException {
        this.out.write(Type.VECTOR.code);
        this.out.writeInt(length);
    }

    public void writeList(List list) throws IOException {
        this.writeListHeader();
        for (Object obj : list) {
            this.write(obj);
        }
        this.writeListFooter();
    }

    public void writeListHeader() throws IOException {
        this.out.write(Type.LIST.code);
    }

    public void writeListFooter() throws IOException {
        this.out.write(Type.MARKER.code);
    }

    public void writeMap(Map map) throws IOException {
        this.writeMapHeader(map.size());
        Set entries = map.entrySet();
        for (Map.Entry entry : entries) {
            this.write(entry.getKey());
            this.write(entry.getValue());
        }
    }

    public void writeMapHeader(int length) throws IOException {
        this.out.write(Type.MAP.code);
        this.out.writeInt(length);
    }

    public void writeEndOfRecord() throws IOException {
        this.out.write(Type.ENDOFRECORD.code);
    }
}

