/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.fieldmanager;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.StatementClassMapping;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.mapping.EmbeddedPCMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.SerialisedPCMapping;
import org.datanucleus.store.mapped.mapping.SerialisedReferenceMapping;
import org.datanucleus.store.query.ResultObjectFactory;

public class ResultSetGetter
extends AbstractFieldManager {
    private final StateManager sm;
    private final ObjectManager om;
    private final Object resultSet;
    private final StatementClassMapping resultMappings;

    public ResultSetGetter(StateManager sm, Object results, StatementClassMapping resultMappings) {
        this.sm = sm;
        this.om = sm.getObjectManager();
        this.resultSet = results;
        this.resultMappings = resultMappings;
    }

    public boolean fetchBooleanField(int fieldNumber) {
        StatementMappingIndex mapIdx = this.resultMappings.getMappingForMemberPosition(fieldNumber);
        return mapIdx.getMapping().getBoolean(this.om, this.resultSet, mapIdx.getColumnPositions());
    }

    public char fetchCharField(int fieldNumber) {
        StatementMappingIndex mapIdx = this.resultMappings.getMappingForMemberPosition(fieldNumber);
        return mapIdx.getMapping().getChar(this.om, this.resultSet, mapIdx.getColumnPositions());
    }

    public byte fetchByteField(int fieldNumber) {
        StatementMappingIndex mapIdx = this.resultMappings.getMappingForMemberPosition(fieldNumber);
        return mapIdx.getMapping().getByte(this.om, this.resultSet, mapIdx.getColumnPositions());
    }

    public short fetchShortField(int fieldNumber) {
        StatementMappingIndex mapIdx = this.resultMappings.getMappingForMemberPosition(fieldNumber);
        return mapIdx.getMapping().getShort(this.om, this.resultSet, mapIdx.getColumnPositions());
    }

    public int fetchIntField(int fieldNumber) {
        StatementMappingIndex mapIdx = this.resultMappings.getMappingForMemberPosition(fieldNumber);
        return mapIdx.getMapping().getInt(this.om, this.resultSet, mapIdx.getColumnPositions());
    }

    public long fetchLongField(int fieldNumber) {
        StatementMappingIndex mapIdx = this.resultMappings.getMappingForMemberPosition(fieldNumber);
        return mapIdx.getMapping().getLong(this.om, this.resultSet, mapIdx.getColumnPositions());
    }

    public float fetchFloatField(int fieldNumber) {
        StatementMappingIndex mapIdx = this.resultMappings.getMappingForMemberPosition(fieldNumber);
        return mapIdx.getMapping().getFloat(this.om, this.resultSet, mapIdx.getColumnPositions());
    }

    public double fetchDoubleField(int fieldNumber) {
        StatementMappingIndex mapIdx = this.resultMappings.getMappingForMemberPosition(fieldNumber);
        return mapIdx.getMapping().getDouble(this.om, this.resultSet, mapIdx.getColumnPositions());
    }

    public String fetchStringField(int fieldNumber) {
        StatementMappingIndex mapIdx = this.resultMappings.getMappingForMemberPosition(fieldNumber);
        return mapIdx.getMapping().getString(this.om, this.resultSet, mapIdx.getColumnPositions());
    }

    public Object fetchObjectField(int fieldNumber) {
        Object value;
        StatementMappingIndex mapIdx = this.resultMappings.getMappingForMemberPosition(fieldNumber);
        JavaTypeMapping mapping = mapIdx.getMapping();
        if (mapping instanceof EmbeddedPCMapping || mapping instanceof SerialisedPCMapping || mapping instanceof SerialisedReferenceMapping) {
            value = mapping.getObject(this.om, this.resultSet, mapIdx.getColumnPositions(), this.sm, fieldNumber);
        } else {
            AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            int relationType = mmd.getRelationType(this.om.getClassLoaderResolver());
            if (relationType == 2 || relationType == 1 || relationType == 6) {
                StatementClassMapping relationMappings = this.resultMappings.getMappingDefinitionForMemberPosition(fieldNumber);
                if (relationMappings != null) {
                    ClassLoaderResolver clr = this.om.getClassLoaderResolver();
                    AbstractClassMetaData relatedCmd = this.om.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
                    ResultObjectFactory relationROF = ((MappedStoreManager)this.om.getStoreManager()).newResultObjectFactory(null, relatedCmd, relationMappings, false, false, this.om.getFetchPlan(), mmd.getType());
                    value = relationROF.getObject(this.om, this.resultSet);
                } else {
                    value = mapping.getObject(this.om, this.resultSet, mapIdx.getColumnPositions());
                }
            } else {
                value = mapping.getObject(this.om, this.resultSet, mapIdx.getColumnPositions());
            }
        }
        return this.sm.wrapSCOField(fieldNumber, value, false, false, false);
    }
}

