/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.jdbc;

import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Map;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.SQLWarningFactory;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.BrokeredCallableStatement;
import org.apache.derby.iapi.jdbc.BrokeredConnectionControl;
import org.apache.derby.iapi.jdbc.BrokeredPreparedStatement;
import org.apache.derby.iapi.jdbc.BrokeredStatement;
import org.apache.derby.iapi.jdbc.BrokeredStatementControl;
import org.apache.derby.iapi.jdbc.EngineConnection;
import org.apache.derby.impl.jdbc.Util;

public abstract class BrokeredConnection
implements EngineConnection {
    int stateHoldability = 1;
    final BrokeredConnectionControl control;
    private boolean isClosed;
    private String connString;
    private int stateIsolationLevel;
    private boolean stateReadOnly;
    private boolean stateAutoCommit;

    public BrokeredConnection(BrokeredConnectionControl brokeredConnectionControl) {
        this.control = brokeredConnectionControl;
    }

    public final void setAutoCommit(boolean bl) throws SQLException {
        try {
            this.control.checkAutoCommit(bl);
            this.getRealConnection().setAutoCommit(bl);
            this.stateAutoCommit = bl;
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public final boolean getAutoCommit() throws SQLException {
        try {
            return this.getRealConnection().getAutoCommit();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public final Statement createStatement() throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().createStatement());
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public final PreparedStatement prepareStatement(String string) throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().prepareStatement(string), string, null);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public final CallableStatement prepareCall(String string) throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().prepareCall(string), string);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public final String nativeSQL(String string) throws SQLException {
        try {
            return this.getRealConnection().nativeSQL(string);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public final void commit() throws SQLException {
        try {
            this.control.checkCommit();
            this.getRealConnection().commit();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public final void rollback() throws SQLException {
        try {
            this.control.checkRollback();
            this.getRealConnection().rollback();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public final void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        try {
            if (!this.control.closingConnection()) {
                this.isClosed = true;
                return;
            }
            this.isClosed = true;
            this.getRealConnection().close();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public final boolean isClosed() throws SQLException {
        if (this.isClosed) {
            return true;
        }
        try {
            boolean bl = this.getRealConnection().isClosed();
            if (bl) {
                this.control.closingConnection();
                this.isClosed = true;
            }
            return bl;
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public final SQLWarning getWarnings() throws SQLException {
        try {
            return this.getRealConnection().getWarnings();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public final void clearWarnings() throws SQLException {
        try {
            this.getRealConnection().clearWarnings();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public final DatabaseMetaData getMetaData() throws SQLException {
        try {
            return this.getRealConnection().getMetaData();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public final void setReadOnly(boolean bl) throws SQLException {
        try {
            this.getRealConnection().setReadOnly(bl);
            this.stateReadOnly = bl;
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public final boolean isReadOnly() throws SQLException {
        try {
            return this.getRealConnection().isReadOnly();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public final void setCatalog(String string) throws SQLException {
        try {
            this.getRealConnection().setCatalog(string);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public final String getCatalog() throws SQLException {
        try {
            return this.getRealConnection().getCatalog();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public final void setTransactionIsolation(int n) throws SQLException {
        try {
            this.getRealConnection().setTransactionIsolation(n);
            this.stateIsolationLevel = n;
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public final int getTransactionIsolation() throws SQLException {
        try {
            return this.getRealConnection().getTransactionIsolation();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public final Statement createStatement(int n, int n2) throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().createStatement(n, n2));
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public final PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().prepareStatement(string, n, n2), string, null);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public final CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().prepareCall(string, n, n2), string);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public Map getTypeMap() throws SQLException {
        try {
            return this.getRealConnection().getTypeMap();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public final void setTypeMap(Map map) throws SQLException {
        try {
            this.getRealConnection().setTypeMap(map);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    final EngineConnection getRealConnection() throws SQLException {
        if (this.isClosed) {
            throw Util.noCurrentConnection();
        }
        return this.control.getRealConnection();
    }

    final void notifyException(SQLException sQLException) {
        if (!this.isClosed) {
            this.control.notifyException(sQLException);
        }
    }

    public void syncState() throws SQLException {
        EngineConnection engineConnection = this.getRealConnection();
        this.stateIsolationLevel = engineConnection.getTransactionIsolation();
        this.stateReadOnly = engineConnection.isReadOnly();
        this.stateAutoCommit = engineConnection.getAutoCommit();
        this.stateHoldability = engineConnection.getHoldability();
    }

    public void getIsolationUptoDate() throws SQLException {
        if (this.control.isIsolationLevelSetUsingSQLorJDBC()) {
            this.stateIsolationLevel = this.getRealConnection().getTransactionIsolation();
            this.control.resetIsolationLevelFlag();
        }
    }

    public void setState(boolean bl) throws SQLException {
        Class[] classArray = new Class[]{Integer.TYPE};
        Object[] objectArray = new Object[]{new Integer(this.stateHoldability)};
        EngineConnection engineConnection = this.getRealConnection();
        if (bl) {
            engineConnection.setTransactionIsolation(this.stateIsolationLevel);
            engineConnection.setReadOnly(this.stateReadOnly);
            engineConnection.setAutoCommit(this.stateAutoCommit);
            try {
                Method method = engineConnection.getClass().getMethod("setHoldability", classArray);
                method.invoke((Object)engineConnection, objectArray);
            }
            catch (Exception exception) {
                throw PublicAPI.wrapStandardException(StandardException.plainWrapException(exception));
            }
        }
    }

    public BrokeredStatement newBrokeredStatement(BrokeredStatementControl brokeredStatementControl) throws SQLException {
        return new BrokeredStatement(brokeredStatementControl);
    }

    public abstract BrokeredPreparedStatement newBrokeredStatement(BrokeredStatementControl var1, String var2, Object var3) throws SQLException;

    public abstract BrokeredCallableStatement newBrokeredStatement(BrokeredStatementControl var1, String var2) throws SQLException;

    public final void setDrdaID(String string) {
        try {
            this.getRealConnection().setDrdaID(string);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public final void setPrepareIsolation(int n) throws SQLException {
        this.getRealConnection().setPrepareIsolation(n);
    }

    public final int getPrepareIsolation() throws SQLException {
        return this.getRealConnection().getPrepareIsolation();
    }

    public final void addWarning(SQLWarning sQLWarning) throws SQLException {
        this.getRealConnection().addWarning(sQLWarning);
    }

    protected final void checkIfClosed() throws SQLException {
        if (this.isClosed()) {
            throw Util.noCurrentConnection();
        }
    }

    public String toString() {
        if (this.connString == null) {
            String string;
            try {
                string = this.getRealConnection().toString();
            }
            catch (SQLException sQLException) {
                string = "<none>";
            }
            this.connString = this.getClass().getName() + "@" + this.hashCode() + ", Wrapped Connection = " + string;
        }
        return this.connString;
    }

    public final PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        try {
            n3 = this.statementHoldabilityCheck(n3);
            return this.control.wrapStatement(this.getRealConnection().prepareStatement(string, n, n2, n3), string, null);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public final int getHoldability() throws SQLException {
        try {
            return this.getRealConnection().getHoldability();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    final int statementHoldabilityCheck(int n) throws SQLException {
        int n2 = this.control.checkHoldCursors(n, true);
        if (n2 != n) {
            SQLWarning sQLWarning = SQLWarningFactory.newSQLWarning("01J07");
            this.addWarning(sQLWarning);
        }
        return n2;
    }

    public void clearLOBMapping() throws SQLException {
        this.getRealConnection().clearLOBMapping();
    }

    public Object getLOBMapping(int n) throws SQLException {
        return this.getRealConnection().getLOBMapping(n);
    }

    public String getCurrentSchemaName() throws SQLException {
        try {
            return this.getRealConnection().getCurrentSchemaName();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public void resetFromPool() throws SQLException {
        this.getRealConnection().resetFromPool();
    }
}

