/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.RCFile;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.util.ReflectionUtils;

public class RCFileRecordReader<K extends LongWritable, V extends BytesRefArrayWritable>
implements RecordReader<LongWritable, BytesRefArrayWritable> {
    private RCFile.Reader in;
    private long start;
    private long end;
    private boolean more = true;
    protected Configuration conf;

    public RCFileRecordReader(Configuration conf, FileSplit split) throws IOException {
        Path path = split.getPath();
        FileSystem fs = path.getFileSystem(conf);
        this.in = new RCFile.Reader(fs, path, conf);
        this.end = split.getStart() + split.getLength();
        this.conf = conf;
        if (split.getStart() > this.in.getPosition()) {
            this.in.sync(split.getStart());
        }
        this.start = this.in.getPosition();
        this.more = this.start < this.end;
    }

    public Class<?> getKeyClass() {
        return LongWritable.class;
    }

    public Class<?> getValueClass() {
        return BytesRefArrayWritable.class;
    }

    public LongWritable createKey() {
        return (LongWritable)ReflectionUtils.newInstance(this.getKeyClass(), (Configuration)this.conf);
    }

    public BytesRefArrayWritable createValue() {
        return (BytesRefArrayWritable)ReflectionUtils.newInstance(this.getValueClass(), (Configuration)this.conf);
    }

    public boolean next(LongWritable key, BytesRefArrayWritable value) throws IOException {
        this.more = this.next(key);
        if (this.more) {
            this.in.getCurrentRow(value);
        }
        return this.more;
    }

    protected boolean next(LongWritable key) throws IOException {
        if (!this.more) {
            return false;
        }
        this.more = this.in.next(key);
        if (!this.more) {
            return false;
        }
        long lastSeenSyncPos = this.in.lastSeenSyncPos();
        if (lastSeenSyncPos >= this.end) {
            this.more = false;
            return this.more;
        }
        return this.more;
    }

    public float getProgress() throws IOException {
        if (this.end == this.start) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.in.getPosition() - this.start) / (float)(this.end - this.start));
    }

    public long getPos() throws IOException {
        return this.in.getPosition();
    }

    protected void seek(long pos) throws IOException {
        this.in.seek(pos);
    }

    public void close() throws IOException {
        this.in.close();
    }
}

