/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.InputFormatChecker;
import org.apache.hadoop.io.SequenceFile;

public class SequenceFileInputFormatChecker
implements InputFormatChecker {
    @Override
    public boolean validateInput(FileSystem fs, HiveConf conf, ArrayList<FileStatus> files) throws IOException {
        if (files.size() <= 0) {
            return false;
        }
        for (int fileId = 0; fileId < files.size(); ++fileId) {
            try {
                SequenceFile.Reader reader = new SequenceFile.Reader(fs, files.get(fileId).getPath(), (Configuration)conf);
                reader.close();
                continue;
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }
}

