/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.io.HiveSequenceFileOutputFormat;
import org.apache.hadoop.hive.ql.metadata.Dimension;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Sample;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TMemoryBuffer;

public class Partition {
    private static final Log LOG = LogFactory.getLog((String)"hive.ql.metadata.Partition");
    private Table table;
    private org.apache.hadoop.hive.metastore.api.Partition tPartition;
    private Deserializer deserializer;
    private Properties schema;
    private Class<? extends InputFormat> inputFormatClass;
    private Class<? extends HiveOutputFormat> outputFormatClass;
    private LinkedHashMap<String, String> spec;
    private Path partPath;
    private URI partURI;
    private static Pattern bpattern = Pattern.compile("part-([0-9][0-9][0-9][0-9][0-9])");
    private String partName;

    public org.apache.hadoop.hive.metastore.api.Partition getTPartition() {
        return this.tPartition;
    }

    public List<String> getValues() {
        return this.tPartition.getValues();
    }

    public Partition(Table tbl, org.apache.hadoop.hive.metastore.api.Partition tp) throws HiveException {
        this.initialize(tbl, tp);
    }

    public Partition(Table tbl, Map<String, String> partSpec, Path location) throws HiveException {
        ArrayList<String> pvals = new ArrayList<String>();
        for (FieldSchema field : tbl.getPartCols()) {
            String val = partSpec.get(field.getName());
            if (val == null) {
                throw new HiveException("partition spec is invalid. field.getName() does not exist in input.");
            }
            pvals.add(val);
        }
        org.apache.hadoop.hive.metastore.api.Partition tpart = new org.apache.hadoop.hive.metastore.api.Partition();
        tpart.setDbName(tbl.getDbName());
        tpart.setTableName(tbl.getName());
        tpart.setValues(pvals);
        StorageDescriptor sd = new StorageDescriptor();
        try {
            TMemoryBuffer buffer = new TMemoryBuffer(1024);
            TBinaryProtocol prot = new TBinaryProtocol(buffer);
            tbl.getTTable().getSd().write((TProtocol)prot);
            sd.read((TProtocol)prot);
        }
        catch (TException e) {
            LOG.error((Object)"Could not create a copy of StorageDescription");
            throw new HiveException("Could not create a copy of StorageDescription");
        }
        tpart.setSd(sd);
        if (location != null) {
            tpart.getSd().setLocation(location.toString());
        } else {
            tpart.getSd().setLocation(null);
        }
        this.initialize(tbl, tpart);
    }

    private void initialize(Table tbl, org.apache.hadoop.hive.metastore.api.Partition tp) throws HiveException {
        this.table = tbl;
        this.tPartition = tp;
        this.partName = "";
        if (tbl.isPartitioned()) {
            try {
                this.partName = Warehouse.makePartName(tbl.getPartCols(), (List)tp.getValues());
                if (tp.getSd().getLocation() == null) {
                    this.partPath = new Path(tbl.getDataLocation().toString(), this.partName);
                    tp.getSd().setLocation(this.partPath.toString());
                }
                this.partPath = new Path(tp.getSd().getLocation());
            }
            catch (MetaException e) {
                throw new HiveException("Invalid partition for table " + tbl.getName(), e);
            }
        } else {
            this.partPath = this.table.getPath();
        }
        this.spec = tbl.createSpec(tp);
        this.partURI = this.partPath.toUri();
    }

    public String getName() {
        return this.partName;
    }

    public Table getTable() {
        return this.table;
    }

    public Path[] getPath() {
        Path[] ret = new Path[]{this.partPath};
        return ret;
    }

    public Path getPartitionPath() {
        return this.partPath;
    }

    public final URI getDataLocation() {
        return this.partURI;
    }

    public final Deserializer getDeserializer() {
        if (this.deserializer == null) {
            try {
                this.initSerDe();
            }
            catch (HiveException e) {
                LOG.error((Object)"Error in initializing serde.", (Throwable)e);
            }
        }
        return this.deserializer;
    }

    public void setSchema(Properties schema) {
        this.schema = schema;
    }

    public Properties getSchema() {
        if (this.schema == null) {
            this.schema = MetaStoreUtils.getSchema((org.apache.hadoop.hive.metastore.api.Partition)this.getTPartition(), (org.apache.hadoop.hive.metastore.api.Table)this.getTable().getTTable());
        }
        return this.schema;
    }

    protected void initSerDe() throws HiveException {
        if (this.deserializer == null) {
            try {
                this.deserializer = MetaStoreUtils.getDeserializer((Configuration)Hive.get().getConf(), (org.apache.hadoop.hive.metastore.api.Partition)this.getTPartition(), (org.apache.hadoop.hive.metastore.api.Table)this.getTable().getTTable());
            }
            catch (MetaException e) {
                throw new HiveException(e);
            }
        }
    }

    public void setInputFormatClass(Class<? extends InputFormat> inputFormatClass) {
        this.inputFormatClass = inputFormatClass;
        this.tPartition.getSd().setInputFormat(inputFormatClass.getName());
    }

    public void setOutputFormatClass(Class<?> class1) {
        this.outputFormatClass = HiveFileFormatUtils.getOutputFormatSubstitute(class1);
        this.tPartition.getSd().setOutputFormat(class1.getName());
    }

    public final Class<? extends InputFormat> getInputFormatClass() throws HiveException {
        if (this.inputFormatClass == null) {
            String clsName = this.getSchema().getProperty("file.inputformat", SequenceFileInputFormat.class.getName());
            try {
                this.setInputFormatClass(Class.forName(clsName, true, JavaUtils.getClassLoader()));
            }
            catch (ClassNotFoundException e) {
                throw new HiveException("Class not found: " + clsName, e);
            }
        }
        return this.inputFormatClass;
    }

    public final Class<? extends HiveOutputFormat> getOutputFormatClass() throws HiveException {
        if (this.outputFormatClass == null) {
            String clsName = this.getSchema().getProperty("file.outputformat", HiveSequenceFileOutputFormat.class.getName());
            try {
                this.setOutputFormatClass(Class.forName(clsName, true, JavaUtils.getClassLoader()));
            }
            catch (ClassNotFoundException e) {
                throw new HiveException("Class not found: " + clsName, e);
            }
        }
        return this.outputFormatClass;
    }

    public int getBucketCount() {
        return this.table.getNumBuckets();
    }

    public List<String> getBucketCols() {
        return this.tPartition.getSd().getBucketCols();
    }

    public Path getBucketPath(int bucketNum) {
        try {
            FileSystem fs = FileSystem.get((URI)this.table.getDataLocation(), (Configuration)Hive.get().getConf());
            String pathPattern = this.partPath.toString();
            if (this.getBucketCount() > 0) {
                pathPattern = pathPattern + "/*";
            }
            LOG.info((Object)("Path pattern = " + pathPattern));
            Object[] srcs = fs.globStatus(new Path(pathPattern));
            Arrays.sort(srcs);
            for (Object src : srcs) {
                LOG.info((Object)("Got file: " + src.getPath()));
            }
            if (srcs.length == 0) {
                return null;
            }
            return srcs[bucketNum].getPath();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get bucket path for bucket " + bucketNum, e);
        }
    }

    public static int getBucketNum(Path p) {
        Matcher m = bpattern.matcher(p.getName());
        if (m.find()) {
            String bnum_str = m.group(1);
            try {
                return Integer.parseInt(bnum_str);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Unexpected error parsing: " + p.getName() + "," + bnum_str);
            }
        }
        return 0;
    }

    public Path[] getPath(Sample s) throws HiveException {
        if (s == null) {
            return this.getPath();
        }
        int bcount = this.getBucketCount();
        if (bcount == 0) {
            return this.getPath();
        }
        Dimension d = s.getSampleDimension();
        if (!d.getDimensionId().equals(this.table.getBucketingDimensionId())) {
            return this.getPath();
        }
        int scount = s.getSampleFraction();
        ArrayList<Path> ret = new ArrayList<Path>();
        if (bcount == scount) {
            ret.add(this.getBucketPath(s.getSampleNum() - 1));
        } else if (bcount < scount) {
            if (scount / bcount * bcount != scount) {
                throw new HiveException("Sample Count" + scount + " is not a multiple of bucket count " + bcount + " for table " + this.table.getName());
            }
            ret.add(this.getBucketPath((s.getSampleNum() - 1) % bcount));
        } else if (bcount > scount) {
            if (bcount / scount * scount != bcount) {
                throw new HiveException("Sample Count" + scount + " is not a divisor of bucket count " + bcount + " for table " + this.table.getName());
            }
            for (int i = 0; i < bcount / scount; ++i) {
                ret.add(this.getBucketPath(i * scount + (s.getSampleNum() - 1)));
            }
        }
        return ret.toArray(new Path[ret.size()]);
    }

    public LinkedHashMap<String, String> getSpec() {
        return this.spec;
    }

    public String toString() {
        String pn = "Invalid Partition";
        try {
            pn = Warehouse.makePartName(this.spec);
        }
        catch (MetaException metaException) {
            // empty catch block
        }
        return this.table.toString() + "(" + pn + ")";
    }

    public void setProperty(String name, String value) {
        this.getTPartition().putToParameters(name, value);
    }

    public String getProperty(String name) {
        Map params = this.getTPartition().getParameters();
        if (params == null) {
            return null;
        }
        return (String)params.get(name);
    }
}

