/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.plan.explain;
import org.apache.hadoop.hive.ql.plan.exprNodeDesc;
import org.apache.hadoop.hive.ql.plan.joinCond;

@explain(displayName="Join Operator")
public class joinDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int INNER_JOIN = 0;
    public static final int LEFT_OUTER_JOIN = 1;
    public static final int RIGHT_OUTER_JOIN = 2;
    public static final int FULL_OUTER_JOIN = 3;
    public static final int UNIQUE_JOIN = 4;
    public static final int LEFT_SEMI_JOIN = 5;
    private Map<Byte, List<exprNodeDesc>> exprs;
    protected ArrayList<String> outputColumnNames;
    private transient Map<String, Byte> reversedExprs;
    protected boolean noOuterJoin;
    protected joinCond[] conds;
    protected Byte[] tagOrder;

    public joinDesc() {
    }

    public joinDesc(Map<Byte, List<exprNodeDesc>> exprs, ArrayList<String> outputColumnNames, boolean noOuterJoin, joinCond[] conds) {
        this.exprs = exprs;
        this.outputColumnNames = outputColumnNames;
        this.noOuterJoin = noOuterJoin;
        this.conds = conds;
        this.tagOrder = new Byte[exprs.size()];
        for (int i = 0; i < this.tagOrder.length; ++i) {
            this.tagOrder[i] = (byte)i;
        }
    }

    public joinDesc(Map<Byte, List<exprNodeDesc>> exprs, ArrayList<String> outputColumnNames) {
        this(exprs, outputColumnNames, true, null);
    }

    public joinDesc(Map<Byte, List<exprNodeDesc>> exprs, ArrayList<String> outputColumnNames, joinCond[] conds) {
        this(exprs, outputColumnNames, false, conds);
    }

    public Map<Byte, List<exprNodeDesc>> getExprs() {
        return this.exprs;
    }

    public Map<String, Byte> getReversedExprs() {
        return this.reversedExprs;
    }

    public void setReversedExprs(Map<String, Byte> reversed_Exprs) {
        this.reversedExprs = reversed_Exprs;
    }

    @explain(displayName="condition expressions")
    public Map<Byte, String> getExprsStringMap() {
        if (this.getExprs() == null) {
            return null;
        }
        LinkedHashMap<Byte, String> ret = new LinkedHashMap<Byte, String>();
        for (Map.Entry<Byte, List<exprNodeDesc>> ent : this.getExprs().entrySet()) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            if (ent.getValue() != null) {
                for (exprNodeDesc expr : ent.getValue()) {
                    if (!first) {
                        sb.append(" ");
                    }
                    first = false;
                    sb.append("{");
                    sb.append(expr.getExprString());
                    sb.append("}");
                }
            }
            ret.put(ent.getKey(), sb.toString());
        }
        return ret;
    }

    public void setExprs(Map<Byte, List<exprNodeDesc>> exprs) {
        this.exprs = exprs;
    }

    @explain(displayName="outputColumnNames")
    public ArrayList<String> getOutputColumnNames() {
        return this.outputColumnNames;
    }

    public void setOutputColumnNames(ArrayList<String> outputColumnNames) {
        this.outputColumnNames = outputColumnNames;
    }

    public boolean getNoOuterJoin() {
        return this.noOuterJoin;
    }

    public void setNoOuterJoin(boolean noOuterJoin) {
        this.noOuterJoin = noOuterJoin;
    }

    @explain(displayName="condition map")
    public List<joinCond> getCondsList() {
        if (this.conds == null) {
            return null;
        }
        ArrayList<joinCond> l = new ArrayList<joinCond>();
        for (joinCond cond : this.conds) {
            l.add(cond);
        }
        return l;
    }

    public joinCond[] getConds() {
        return this.conds;
    }

    public void setConds(joinCond[] conds) {
        this.conds = conds;
    }

    public Byte[] getTagOrder() {
        return this.tagOrder;
    }

    public void setTagOrder(Byte[] tagOrder) {
        this.tagOrder = tagOrder;
    }
}

