/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.plan.explain;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.mapred.InputFormat;

public class tableDesc
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private Class<? extends Deserializer> deserializerClass;
    private Class<? extends InputFormat> inputFileFormatClass;
    private Class<? extends HiveOutputFormat> outputFileFormatClass;
    private Properties properties;
    private String serdeClassName;

    public tableDesc() {
    }

    public tableDesc(Class<? extends Deserializer> serdeClass, Class<? extends InputFormat> inputFileFormatClass, Class<?> class1, Properties properties) {
        this.deserializerClass = serdeClass;
        this.inputFileFormatClass = inputFileFormatClass;
        this.outputFileFormatClass = HiveFileFormatUtils.getOutputFormatSubstitute(class1);
        this.properties = properties;
        this.serdeClassName = properties.getProperty("serialization.lib");
    }

    public Class<? extends Deserializer> getDeserializerClass() {
        return this.deserializerClass;
    }

    public void setDeserializerClass(Class<? extends Deserializer> serdeClass) {
        this.deserializerClass = serdeClass;
    }

    public Class<? extends InputFormat> getInputFileFormatClass() {
        return this.inputFileFormatClass;
    }

    public Deserializer getDeserializer() throws Exception {
        Deserializer de = this.deserializerClass.newInstance();
        de.initialize(null, this.properties);
        return de;
    }

    public void setInputFileFormatClass(Class<? extends InputFormat> inputFileFormatClass) {
        this.inputFileFormatClass = inputFileFormatClass;
    }

    public Class<? extends HiveOutputFormat> getOutputFileFormatClass() {
        return this.outputFileFormatClass;
    }

    public void setOutputFileFormatClass(Class<?> outputFileFormatClass) {
        this.outputFileFormatClass = HiveFileFormatUtils.getOutputFormatSubstitute(outputFileFormatClass);
    }

    @explain(displayName="properties", normalExplain=false)
    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @explain(displayName="serde")
    public String getSerdeClassName() {
        return this.serdeClassName;
    }

    public void setSerdeClassName(String serdeClassName) {
        this.serdeClassName = serdeClassName;
    }

    @explain(displayName="name")
    public String getTableName() {
        return this.properties.getProperty("name");
    }

    @explain(displayName="input format")
    public String getInputFileFormatClassName() {
        return this.getInputFileFormatClass().getName();
    }

    @explain(displayName="output format")
    public String getOutputFileFormatClassName() {
        return this.getOutputFileFormatClass().getName();
    }

    public Object clone() {
        tableDesc ret = new tableDesc();
        ret.setSerdeClassName(this.serdeClassName);
        ret.setDeserializerClass(this.deserializerClass);
        ret.setInputFileFormatClass(this.inputFileFormatClass);
        ret.setOutputFileFormatClass(this.outputFileFormatClass);
        Properties newProp = new Properties();
        Enumeration<Object> keysProp = this.properties.keys();
        while (keysProp.hasMoreElements()) {
            Object key = keysProp.nextElement();
            newProp.put(key, this.properties.get(key));
        }
        ret.setProperties(newProp);
        return ret;
    }
}

