/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;

public class Partition
implements TBase<Partition, _Fields>,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("Partition");
    private static final TField VALUES_FIELD_DESC = new TField("values", 15, 1);
    private static final TField DB_NAME_FIELD_DESC = new TField("dbName", 11, 2);
    private static final TField TABLE_NAME_FIELD_DESC = new TField("tableName", 11, 3);
    private static final TField CREATE_TIME_FIELD_DESC = new TField("createTime", 8, 4);
    private static final TField LAST_ACCESS_TIME_FIELD_DESC = new TField("lastAccessTime", 8, 5);
    private static final TField SD_FIELD_DESC = new TField("sd", 12, 6);
    private static final TField PARAMETERS_FIELD_DESC = new TField("parameters", 13, 7);
    private List<String> values;
    private String dbName;
    private String tableName;
    private int createTime;
    private int lastAccessTime;
    private StorageDescriptor sd;
    private Map<String, String> parameters;
    private static final int __CREATETIME_ISSET_ID = 0;
    private static final int __LASTACCESSTIME_ISSET_ID = 1;
    private BitSet __isset_bit_vector = new BitSet(2);
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public Partition() {
    }

    public Partition(List<String> values, String dbName, String tableName, int createTime, int lastAccessTime, StorageDescriptor sd, Map<String, String> parameters) {
        this();
        this.values = values;
        this.dbName = dbName;
        this.tableName = tableName;
        this.createTime = createTime;
        this.setCreateTimeIsSet(true);
        this.lastAccessTime = lastAccessTime;
        this.setLastAccessTimeIsSet(true);
        this.sd = sd;
        this.parameters = parameters;
    }

    public Partition(Partition other) {
        this.__isset_bit_vector.clear();
        this.__isset_bit_vector.or(other.__isset_bit_vector);
        if (other.isSetValues()) {
            ArrayList<String> __this__values = new ArrayList<String>();
            for (String string : other.values) {
                __this__values.add(string);
            }
            this.values = __this__values;
        }
        if (other.isSetDbName()) {
            this.dbName = other.dbName;
        }
        if (other.isSetTableName()) {
            this.tableName = other.tableName;
        }
        this.createTime = other.createTime;
        this.lastAccessTime = other.lastAccessTime;
        if (other.isSetSd()) {
            this.sd = new StorageDescriptor(other.sd);
        }
        if (other.isSetParameters()) {
            HashMap<String, String> __this__parameters = new HashMap<String, String>();
            for (Map.Entry entry : other.parameters.entrySet()) {
                String other_element_key = (String)entry.getKey();
                String other_element_value = (String)entry.getValue();
                String __this__parameters_copy_key = other_element_key;
                String __this__parameters_copy_value = other_element_value;
                __this__parameters.put(__this__parameters_copy_key, __this__parameters_copy_value);
            }
            this.parameters = __this__parameters;
        }
    }

    public Partition deepCopy() {
        return new Partition(this);
    }

    public void clear() {
        this.values = null;
        this.dbName = null;
        this.tableName = null;
        this.setCreateTimeIsSet(false);
        this.createTime = 0;
        this.setLastAccessTimeIsSet(false);
        this.lastAccessTime = 0;
        this.sd = null;
        this.parameters = null;
    }

    public int getValuesSize() {
        return this.values == null ? 0 : this.values.size();
    }

    public Iterator<String> getValuesIterator() {
        return this.values == null ? null : this.values.iterator();
    }

    public void addToValues(String elem) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        this.values.add(elem);
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    public void unsetValues() {
        this.values = null;
    }

    public boolean isSetValues() {
        return this.values != null;
    }

    public void setValuesIsSet(boolean value) {
        if (!value) {
            this.values = null;
        }
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void unsetDbName() {
        this.dbName = null;
    }

    public boolean isSetDbName() {
        return this.dbName != null;
    }

    public void setDbNameIsSet(boolean value) {
        if (!value) {
            this.dbName = null;
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void unsetTableName() {
        this.tableName = null;
    }

    public boolean isSetTableName() {
        return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
        if (!value) {
            this.tableName = null;
        }
    }

    public int getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(int createTime) {
        this.createTime = createTime;
        this.setCreateTimeIsSet(true);
    }

    public void unsetCreateTime() {
        this.__isset_bit_vector.clear(0);
    }

    public boolean isSetCreateTime() {
        return this.__isset_bit_vector.get(0);
    }

    public void setCreateTimeIsSet(boolean value) {
        this.__isset_bit_vector.set(0, value);
    }

    public int getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(int lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
        this.setLastAccessTimeIsSet(true);
    }

    public void unsetLastAccessTime() {
        this.__isset_bit_vector.clear(1);
    }

    public boolean isSetLastAccessTime() {
        return this.__isset_bit_vector.get(1);
    }

    public void setLastAccessTimeIsSet(boolean value) {
        this.__isset_bit_vector.set(1, value);
    }

    public StorageDescriptor getSd() {
        return this.sd;
    }

    public void setSd(StorageDescriptor sd) {
        this.sd = sd;
    }

    public void unsetSd() {
        this.sd = null;
    }

    public boolean isSetSd() {
        return this.sd != null;
    }

    public void setSdIsSet(boolean value) {
        if (!value) {
            this.sd = null;
        }
    }

    public int getParametersSize() {
        return this.parameters == null ? 0 : this.parameters.size();
    }

    public void putToParameters(String key, String val) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        this.parameters.put(key, val);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void unsetParameters() {
        this.parameters = null;
    }

    public boolean isSetParameters() {
        return this.parameters != null;
    }

    public void setParametersIsSet(boolean value) {
        if (!value) {
            this.parameters = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case VALUES: {
                if (value == null) {
                    this.unsetValues();
                    break;
                }
                this.setValues((List)value);
                break;
            }
            case DB_NAME: {
                if (value == null) {
                    this.unsetDbName();
                    break;
                }
                this.setDbName((String)value);
                break;
            }
            case TABLE_NAME: {
                if (value == null) {
                    this.unsetTableName();
                    break;
                }
                this.setTableName((String)value);
                break;
            }
            case CREATE_TIME: {
                if (value == null) {
                    this.unsetCreateTime();
                    break;
                }
                this.setCreateTime((Integer)value);
                break;
            }
            case LAST_ACCESS_TIME: {
                if (value == null) {
                    this.unsetLastAccessTime();
                    break;
                }
                this.setLastAccessTime((Integer)value);
                break;
            }
            case SD: {
                if (value == null) {
                    this.unsetSd();
                    break;
                }
                this.setSd((StorageDescriptor)value);
                break;
            }
            case PARAMETERS: {
                if (value == null) {
                    this.unsetParameters();
                    break;
                }
                this.setParameters((Map)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case VALUES: {
                return this.getValues();
            }
            case DB_NAME: {
                return this.getDbName();
            }
            case TABLE_NAME: {
                return this.getTableName();
            }
            case CREATE_TIME: {
                return new Integer(this.getCreateTime());
            }
            case LAST_ACCESS_TIME: {
                return new Integer(this.getLastAccessTime());
            }
            case SD: {
                return this.getSd();
            }
            case PARAMETERS: {
                return this.getParameters();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case VALUES: {
                return this.isSetValues();
            }
            case DB_NAME: {
                return this.isSetDbName();
            }
            case TABLE_NAME: {
                return this.isSetTableName();
            }
            case CREATE_TIME: {
                return this.isSetCreateTime();
            }
            case LAST_ACCESS_TIME: {
                return this.isSetLastAccessTime();
            }
            case SD: {
                return this.isSetSd();
            }
            case PARAMETERS: {
                return this.isSetParameters();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof Partition) {
            return this.equals((Partition)that);
        }
        return false;
    }

    public boolean equals(Partition that) {
        if (that == null) {
            return false;
        }
        boolean this_present_values = this.isSetValues();
        boolean that_present_values = that.isSetValues();
        if (this_present_values || that_present_values) {
            if (!this_present_values || !that_present_values) {
                return false;
            }
            if (!((Object)this.values).equals(that.values)) {
                return false;
            }
        }
        boolean this_present_dbName = this.isSetDbName();
        boolean that_present_dbName = that.isSetDbName();
        if (this_present_dbName || that_present_dbName) {
            if (!this_present_dbName || !that_present_dbName) {
                return false;
            }
            if (!this.dbName.equals(that.dbName)) {
                return false;
            }
        }
        boolean this_present_tableName = this.isSetTableName();
        boolean that_present_tableName = that.isSetTableName();
        if (this_present_tableName || that_present_tableName) {
            if (!this_present_tableName || !that_present_tableName) {
                return false;
            }
            if (!this.tableName.equals(that.tableName)) {
                return false;
            }
        }
        boolean this_present_createTime = true;
        boolean that_present_createTime = true;
        if (this_present_createTime || that_present_createTime) {
            if (!this_present_createTime || !that_present_createTime) {
                return false;
            }
            if (this.createTime != that.createTime) {
                return false;
            }
        }
        boolean this_present_lastAccessTime = true;
        boolean that_present_lastAccessTime = true;
        if (this_present_lastAccessTime || that_present_lastAccessTime) {
            if (!this_present_lastAccessTime || !that_present_lastAccessTime) {
                return false;
            }
            if (this.lastAccessTime != that.lastAccessTime) {
                return false;
            }
        }
        boolean this_present_sd = this.isSetSd();
        boolean that_present_sd = that.isSetSd();
        if (this_present_sd || that_present_sd) {
            if (!this_present_sd || !that_present_sd) {
                return false;
            }
            if (!this.sd.equals(that.sd)) {
                return false;
            }
        }
        boolean this_present_parameters = this.isSetParameters();
        boolean that_present_parameters = that.isSetParameters();
        if (this_present_parameters || that_present_parameters) {
            if (!this_present_parameters || !that_present_parameters) {
                return false;
            }
            if (!((Object)this.parameters).equals(that.parameters)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    public int compareTo(Partition other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        Partition typedOther = other;
        lastComparison = Boolean.valueOf(this.isSetValues()).compareTo(typedOther.isSetValues());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetValues() && (lastComparison = TBaseHelper.compareTo(this.values, typedOther.values)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDbName()).compareTo(typedOther.isSetDbName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDbName() && (lastComparison = TBaseHelper.compareTo((String)this.dbName, (String)typedOther.dbName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTableName()).compareTo(typedOther.isSetTableName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTableName() && (lastComparison = TBaseHelper.compareTo((String)this.tableName, (String)typedOther.tableName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetCreateTime()).compareTo(typedOther.isSetCreateTime());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCreateTime() && (lastComparison = TBaseHelper.compareTo((int)this.createTime, (int)typedOther.createTime)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetLastAccessTime()).compareTo(typedOther.isSetLastAccessTime());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetLastAccessTime() && (lastComparison = TBaseHelper.compareTo((int)this.lastAccessTime, (int)typedOther.lastAccessTime)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSd()).compareTo(typedOther.isSetSd());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSd() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.sd), (Comparable)((Object)typedOther.sd))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetParameters()).compareTo(typedOther.isSetParameters());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetParameters() && (lastComparison = TBaseHelper.compareTo(this.parameters, typedOther.parameters)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin();
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 15) {
                        TList _list35 = iprot.readListBegin();
                        this.values = new ArrayList<String>(_list35.size);
                        for (int _i36 = 0; _i36 < _list35.size; ++_i36) {
                            String _elem37 = iprot.readString();
                            this.values.add(_elem37);
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 2: {
                    if (field.type == 11) {
                        this.dbName = iprot.readString();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 3: {
                    if (field.type == 11) {
                        this.tableName = iprot.readString();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 4: {
                    if (field.type == 8) {
                        this.createTime = iprot.readI32();
                        this.setCreateTimeIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 5: {
                    if (field.type == 8) {
                        this.lastAccessTime = iprot.readI32();
                        this.setLastAccessTimeIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 6: {
                    if (field.type == 12) {
                        this.sd = new StorageDescriptor();
                        this.sd.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 7: {
                    if (field.type == 13) {
                        TMap _map38 = iprot.readMapBegin();
                        this.parameters = new HashMap<String, String>(2 * _map38.size);
                        for (int _i39 = 0; _i39 < _map38.size; ++_i39) {
                            String _key40 = iprot.readString();
                            String _val41 = iprot.readString();
                            this.parameters.put(_key40, _val41);
                        }
                        iprot.readMapEnd();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.values != null) {
            oprot.writeFieldBegin(VALUES_FIELD_DESC);
            oprot.writeListBegin(new TList(11, this.values.size()));
            for (String string : this.values) {
                oprot.writeString(string);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        if (this.dbName != null) {
            oprot.writeFieldBegin(DB_NAME_FIELD_DESC);
            oprot.writeString(this.dbName);
            oprot.writeFieldEnd();
        }
        if (this.tableName != null) {
            oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
            oprot.writeString(this.tableName);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(CREATE_TIME_FIELD_DESC);
        oprot.writeI32(this.createTime);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(LAST_ACCESS_TIME_FIELD_DESC);
        oprot.writeI32(this.lastAccessTime);
        oprot.writeFieldEnd();
        if (this.sd != null) {
            oprot.writeFieldBegin(SD_FIELD_DESC);
            this.sd.write(oprot);
            oprot.writeFieldEnd();
        }
        if (this.parameters != null) {
            oprot.writeFieldBegin(PARAMETERS_FIELD_DESC);
            oprot.writeMapBegin(new TMap(11, 11, this.parameters.size()));
            for (Map.Entry entry : this.parameters.entrySet()) {
                oprot.writeString((String)entry.getKey());
                oprot.writeString((String)entry.getValue());
            }
            oprot.writeMapEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Partition(");
        boolean first = true;
        sb.append("values:");
        if (this.values == null) {
            sb.append("null");
        } else {
            sb.append(this.values);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("dbName:");
        if (this.dbName == null) {
            sb.append("null");
        } else {
            sb.append(this.dbName);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("tableName:");
        if (this.tableName == null) {
            sb.append("null");
        } else {
            sb.append(this.tableName);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("createTime:");
        sb.append(this.createTime);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("lastAccessTime:");
        sb.append(this.lastAccessTime);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("sd:");
        if (this.sd == null) {
            sb.append("null");
        } else {
            sb.append(this.sd);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("parameters:");
        if (this.parameters == null) {
            sb.append("null");
        } else {
            sb.append(this.parameters);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.VALUES, new FieldMetaData("values", 3, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(11))));
        tmpMap.put(_Fields.DB_NAME, new FieldMetaData("dbName", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.TABLE_NAME, new FieldMetaData("tableName", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.CREATE_TIME, new FieldMetaData("createTime", 3, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.LAST_ACCESS_TIME, new FieldMetaData("lastAccessTime", 3, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.SD, new FieldMetaData("sd", 3, (FieldValueMetaData)new StructMetaData(12, StorageDescriptor.class)));
        tmpMap.put(_Fields.PARAMETERS, new FieldMetaData("parameters", 3, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11), new FieldValueMetaData(11))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(Partition.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        VALUES(1, "values"),
        DB_NAME(2, "dbName"),
        TABLE_NAME(3, "tableName"),
        CREATE_TIME(4, "createTime"),
        LAST_ACCESS_TIME(5, "lastAccessTime"),
        SD(6, "sd"),
        PARAMETERS(7, "parameters");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return VALUES;
                }
                case 2: {
                    return DB_NAME;
                }
                case 3: {
                    return TABLE_NAME;
                }
                case 4: {
                    return CREATE_TIME;
                }
                case 5: {
                    return LAST_ACCESS_TIME;
                }
                case 6: {
                    return SD;
                }
                case 7: {
                    return PARAMETERS;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

