/*
 * Decompiled with CFR 0.152.
 */
package py4j.commands;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.logging.Logger;
import py4j.Gateway;
import py4j.Protocol;
import py4j.Py4JException;
import py4j.ReturnObject;
import py4j.commands.AbstractCommand;
import py4j.reflection.ReflectionEngine;

public class FieldCommand
extends AbstractCommand {
    private final Logger logger = Logger.getLogger(FieldCommand.class.getName());
    public static final String FIELD_COMMAND_NAME = "f";
    public static final String FIELD_GET_SUB_COMMAND_NAME = "g";
    public static final String FIELD_SET_SUB_COMMAND_NAME = "s";
    private ReflectionEngine reflectionEngine;

    public FieldCommand() {
        this.commandName = FIELD_COMMAND_NAME;
    }

    @Override
    public void execute(String commandName, BufferedReader reader, BufferedWriter writer) throws Py4JException, IOException {
        String returnCommand = null;
        String subCommand = reader.readLine();
        returnCommand = subCommand.equals(FIELD_GET_SUB_COMMAND_NAME) ? this.getField(reader) : this.setField(reader);
        this.logger.finest("Returning command: " + returnCommand);
        writer.write(returnCommand);
        writer.flush();
    }

    private String getField(BufferedReader reader) throws IOException {
        String targetObjectId = reader.readLine();
        String fieldName = reader.readLine();
        reader.readLine();
        Object object = this.gateway.getObject(targetObjectId);
        Field field = this.reflectionEngine.getField(object, fieldName);
        this.logger.finer("Getting field " + fieldName);
        String returnCommand = null;
        if (field == null) {
            returnCommand = Protocol.getNoSuchFieldOutputCommand();
        } else {
            Object fieldObject = this.reflectionEngine.getFieldValue(object, field);
            ReturnObject rObject = this.gateway.getReturnObject(fieldObject);
            returnCommand = Protocol.getOutputCommand(rObject);
        }
        return returnCommand;
    }

    @Override
    public void init(Gateway gateway) {
        super.init(gateway);
        this.reflectionEngine = gateway.getReflectionEngine();
    }

    private String setField(BufferedReader reader) throws IOException {
        String targetObjectId = reader.readLine();
        String fieldName = reader.readLine();
        String value = reader.readLine();
        reader.readLine();
        Object valueObject = Protocol.getObject(value, this.gateway);
        Object object = this.gateway.getObject(targetObjectId);
        Field field = this.reflectionEngine.getField(object, fieldName);
        this.logger.finer("Setting field " + fieldName);
        String returnCommand = null;
        if (field == null) {
            returnCommand = Protocol.getNoSuchFieldOutputCommand();
        } else {
            this.reflectionEngine.setFieldValue(object, field, valueObject);
            returnCommand = Protocol.getOutputVoidCommand();
        }
        return returnCommand;
    }
}

