/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.evaluation.string;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class RegexMatch
extends EvalFunc<Integer> {
    String mExpression = null;
    Pattern mPattern = null;

    public Schema outputSchema(Schema input) {
        try {
            return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), input), 10));
        }
        catch (Exception e) {
            return null;
        }
    }

    public Integer exec(Tuple input) throws IOException {
        block7: {
            if (input.size() != 2) {
                String msg = "RegexMatch : Only 2 parameters are allowed.";
                throw new IOException(msg);
            }
            if (input.get(0) == null) {
                return null;
            }
            try {
                if (input.get(1).equals(this.mExpression)) break block7;
                this.mExpression = (String)input.get(1);
                try {
                    this.mPattern = Pattern.compile(this.mExpression);
                }
                catch (Exception e) {
                    String msg = "RegexMatch : Mal-Formed Regular Expression " + input.get(1);
                    throw new IOException(msg);
                }
            }
            catch (NullPointerException e) {
                String msg = "RegexMatch : Regular Expression is null ";
                throw new IOException(msg);
            }
        }
        if (this.mPattern.matcher((String)input.get(0)).matches()) {
            return 1;
        }
        return 0;
    }

    public List<FuncSpec> getArgToFuncMapping() throws FrontendException {
        ArrayList<FuncSpec> funcList = new ArrayList<FuncSpec>();
        Schema s = new Schema();
        s.add(new Schema.FieldSchema(null, 55));
        s.add(new Schema.FieldSchema(null, 55));
        funcList.add(new FuncSpec(((Object)((Object)this)).getClass().getName(), s));
        return funcList;
    }
}

