/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui.javaoptions;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.aspectj.ajde.ui.javaoptions.JavaBuildOptions;
import org.aspectj.ajde.ui.swing.OptionsPanel;

public class JavaComplianceOptionsPanel
extends OptionsPanel {
    private final String[] complianceLevels = new String[]{"1.3", "1.4", "1.5", "1.6"};
    private static final long serialVersionUID = 4491319302490183151L;
    private JPanel parentPanel;
    private Border complianceEtchedBorder;
    private TitledBorder complianceTitleBorder;
    private Border complianceCompoundBorder;
    private JPanel compliancePanel;
    private Box complianceBox = Box.createVerticalBox();
    private JavaBuildOptions javaBuildOptions;
    private Map complianceComboBoxes = new HashMap();

    public JavaComplianceOptionsPanel(JavaBuildOptions javaBuildOptions) {
        this.javaBuildOptions = javaBuildOptions;
        try {
            this.jbInit();
            this.setName("Java Compliance Options");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadOptions() throws IOException {
        this.createComplianceContents();
    }

    public void saveOptions() throws IOException {
        Set s = this.complianceComboBoxes.entrySet();
        Iterator iterator = s.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String javaOption = (String)entry.getKey();
            JComboBox combo = (JComboBox)entry.getValue();
            String value = (String)combo.getSelectedItem();
            this.javaBuildOptions.setOption(javaOption, value);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.createBorders();
        this.addBordersToPanel();
        this.add((Component)this.parentPanel, "North");
    }

    private void createComplianceContents() {
        this.createComplianceEntry("AjCompiler compliance level: ", "org.eclipse.jdt.core.compiler.compliance");
        this.createComplianceEntry("Source compatibility: ", "org.eclipse.jdt.core.compiler.source");
        this.createComplianceEntry("Generated class file compatibility: ", "org.eclipse.jdt.core.compiler.codegen.targetPlatform");
        this.compliancePanel.add(this.complianceBox);
    }

    private void createComplianceEntry(String labelText, String javaOptionToSet) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JLabel label = new JLabel();
        label.setFont(new Font("Dialog", 0, 11));
        label.setText(labelText);
        panel.add((Component)label, "West");
        JComboBox<String> levels = new JComboBox<String>(this.complianceLevels);
        String value = (String)this.javaBuildOptions.getJavaBuildOptionsMap().get(javaOptionToSet);
        if (value == null) {
            levels.setSelectedIndex(2);
        } else if (value.equals("1.3")) {
            levels.setSelectedIndex(0);
        } else if (value.equals("1.4")) {
            levels.setSelectedIndex(1);
        } else if (value.equals("1.5")) {
            levels.setSelectedIndex(2);
        } else if (value.equals("1.6")) {
            levels.setSelectedIndex(3);
        }
        panel.add(levels, "East");
        this.complianceBox.add((Component)panel, null);
        this.complianceComboBoxes.put(javaOptionToSet, levels);
    }

    private void createBorders() {
        this.complianceEtchedBorder = BorderFactory.createEtchedBorder(Color.white, new Color(156, 156, 158));
        this.complianceTitleBorder = new TitledBorder(this.complianceEtchedBorder, "Compliance Options");
        this.complianceCompoundBorder = BorderFactory.createCompoundBorder(this.complianceTitleBorder, BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.complianceTitleBorder.setTitleFont(new Font("Dialog", 0, 11));
    }

    private void addBordersToPanel() {
        this.parentPanel = new JPanel();
        this.parentPanel.setLayout(new BorderLayout());
        this.compliancePanel = new JPanel();
        this.compliancePanel.setBorder(this.complianceCompoundBorder);
        this.parentPanel.add((Component)this.compliancePanel, "Center");
    }
}

